/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.stax.impl.processor.output;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.codec.binary.Base64;
import org.apache.wss4j.stax.ext.WSSConstants;
import org.apache.wss4j.stax.ext.WSSSecurityProperties;
import org.apache.wss4j.stax.ext.WSSUtils;
import org.apache.wss4j.stax.impl.processor.output.EncryptEndingOutputProcessor;
import org.apache.wss4j.stax.impl.processor.output.WSSSignatureOutputProcessor;
import org.apache.wss4j.stax.impl.securityToken.KerberosClientSecurityToken;
import org.apache.wss4j.stax.securityToken.WSSecurityTokenConstants;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.ext.AbstractOutputProcessor;
import org.apache.xml.security.stax.ext.OutputProcessor;
import org.apache.xml.security.stax.ext.OutputProcessorChain;
import org.apache.xml.security.stax.ext.XMLSecurityConstants;
import org.apache.xml.security.stax.ext.stax.XMLSecAttribute;
import org.apache.xml.security.stax.ext.stax.XMLSecEvent;
import org.apache.xml.security.stax.impl.securityToken.GenericOutboundSecurityToken;
import org.apache.xml.security.stax.securityToken.OutboundSecurityToken;
import org.apache.xml.security.stax.securityToken.SecurityTokenProvider;

public class BinarySecurityTokenOutputProcessor
extends AbstractOutputProcessor {
    public BinarySecurityTokenOutputProcessor() throws XMLSecurityException {
        this.addBeforeProcessor(WSSSignatureOutputProcessor.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(XMLSecEvent xmlSecEvent, OutputProcessorChain outputProcessorChain) throws XMLStreamException, XMLSecurityException {
        try {
            GenericOutboundSecurityToken securityToken = null;
            XMLSecurityConstants.Action action = this.getAction();
            String tokenId = null;
            if (WSSConstants.SIGNATURE.equals((Object)action) || WSSConstants.SAML_TOKEN_SIGNED.equals((Object)action)) {
                tokenId = (String)outputProcessorChain.getSecurityContext().get("PROP_USE_THIS_TOKEN_ID_FOR_SIGNATURE");
            } else if (WSSConstants.ENCRYPT.equals((Object)action)) {
                tokenId = (String)outputProcessorChain.getSecurityContext().get("PROP_USE_THIS_TOKEN_ID_FOR_ENCRYPTED_KEY");
            } else if (WSSConstants.ENCRYPT_WITH_KERBEROS_TOKEN.equals((Object)this.getAction()) || WSSConstants.SIGNATURE_WITH_KERBEROS_TOKEN.equals((Object)this.getAction()) || WSSConstants.KERBEROS_TOKEN.equals((Object)this.getAction())) {
                tokenId = (String)outputProcessorChain.getSecurityContext().get("PROP_USE_THIS_TOKEN_ID_FOR_KERBEROS");
            }
            SecurityTokenProvider tokenProvider = null;
            if (tokenId != null && (tokenProvider = outputProcessorChain.getSecurityContext().getSecurityTokenProvider(tokenId)) != null) {
                securityToken = (GenericOutboundSecurityToken)tokenProvider.getSecurityToken();
            }
            if (securityToken != null) {
                if (WSSConstants.SIGNATURE.equals((Object)action) || WSSConstants.SAML_TOKEN_SIGNED.equals((Object)action)) {
                    boolean includeSignatureToken = ((WSSSecurityProperties)this.getSecurityProperties()).isIncludeSignatureToken();
                    if ((includeSignatureToken || WSSecurityTokenConstants.KeyIdentifier_SecurityTokenDirectReference.equals((Object)this.getSecurityProperties().getSignatureKeyIdentifier())) && (securityToken.getTokenType() == null || WSSecurityTokenConstants.X509V3Token.equals((Object)securityToken.getTokenType()))) {
                        FinalBinarySecurityTokenOutputProcessor finalBinarySecurityTokenOutputProcessor = new FinalBinarySecurityTokenOutputProcessor((OutboundSecurityToken)securityToken);
                        finalBinarySecurityTokenOutputProcessor.setXMLSecurityProperties(this.getSecurityProperties());
                        finalBinarySecurityTokenOutputProcessor.setAction(this.getAction());
                        finalBinarySecurityTokenOutputProcessor.addBeforeProcessor(WSSSignatureOutputProcessor.class.getName());
                        finalBinarySecurityTokenOutputProcessor.init(outputProcessorChain);
                        securityToken.setProcessor((Object)finalBinarySecurityTokenOutputProcessor);
                    }
                } else if (WSSConstants.ENCRYPT.equals((Object)action) && (securityToken.getTokenType() == null || WSSecurityTokenConstants.X509V3Token.equals((Object)securityToken.getTokenType()))) {
                    if (WSSecurityTokenConstants.KeyIdentifier_SecurityTokenDirectReference.equals((Object)((WSSSecurityProperties)this.getSecurityProperties()).getEncryptionKeyIdentifier())) {
                        FinalBinarySecurityTokenOutputProcessor finalBinarySecurityTokenOutputProcessor = new FinalBinarySecurityTokenOutputProcessor((OutboundSecurityToken)securityToken);
                        finalBinarySecurityTokenOutputProcessor.setXMLSecurityProperties(this.getSecurityProperties());
                        finalBinarySecurityTokenOutputProcessor.setAction(this.getAction());
                        finalBinarySecurityTokenOutputProcessor.addAfterProcessor(EncryptEndingOutputProcessor.class.getName());
                        finalBinarySecurityTokenOutputProcessor.init(outputProcessorChain);
                        securityToken.setProcessor((Object)finalBinarySecurityTokenOutputProcessor);
                    }
                } else if (WSSConstants.ENCRYPT_WITH_KERBEROS_TOKEN.equals((Object)this.getAction()) || WSSConstants.SIGNATURE_WITH_KERBEROS_TOKEN.equals((Object)this.getAction()) || WSSConstants.KERBEROS_TOKEN.equals((Object)this.getAction())) {
                    FinalBinarySecurityTokenOutputProcessor finalBinarySecurityTokenOutputProcessor = new FinalBinarySecurityTokenOutputProcessor((OutboundSecurityToken)securityToken);
                    finalBinarySecurityTokenOutputProcessor.setXMLSecurityProperties(this.getSecurityProperties());
                    finalBinarySecurityTokenOutputProcessor.setAction(this.getAction());
                    finalBinarySecurityTokenOutputProcessor.addBeforeProcessor(WSSSignatureOutputProcessor.class.getName());
                    finalBinarySecurityTokenOutputProcessor.addAfterProcessor(EncryptEndingOutputProcessor.class.getName());
                    finalBinarySecurityTokenOutputProcessor.init(outputProcessorChain);
                    securityToken.setProcessor((Object)finalBinarySecurityTokenOutputProcessor);
                }
            }
        }
        finally {
            outputProcessorChain.removeProcessor((OutputProcessor)this);
        }
        outputProcessorChain.processEvent(xmlSecEvent);
    }

    class FinalBinarySecurityTokenOutputProcessor
    extends AbstractOutputProcessor {
        private final OutboundSecurityToken securityToken;

        FinalBinarySecurityTokenOutputProcessor(OutboundSecurityToken securityToken) throws XMLSecurityException {
            this.addAfterProcessor(BinarySecurityTokenOutputProcessor.class.getName());
            this.securityToken = securityToken;
        }

        public void processEvent(XMLSecEvent xmlSecEvent, OutputProcessorChain outputProcessorChain) throws XMLStreamException, XMLSecurityException {
            outputProcessorChain.processEvent(xmlSecEvent);
            if (WSSUtils.isSecurityHeaderElement(xmlSecEvent, ((WSSSecurityProperties)this.getSecurityProperties()).getActor())) {
                QName headerElementName = WSSConstants.TAG_wsse_BinarySecurityToken;
                WSSUtils.updateSecurityHeaderOrder(outputProcessorChain, headerElementName, this.getAction(), false);
                OutputProcessorChain subOutputProcessorChain = outputProcessorChain.createSubChain((OutputProcessor)this);
                if (WSSConstants.ENCRYPT_WITH_KERBEROS_TOKEN.equals((Object)this.getAction()) || WSSConstants.SIGNATURE_WITH_KERBEROS_TOKEN.equals((Object)this.getAction()) || WSSConstants.KERBEROS_TOKEN.equals((Object)this.getAction())) {
                    ArrayList<XMLSecAttribute> attributes = new ArrayList<XMLSecAttribute>(3);
                    attributes.add(this.createAttribute(WSSConstants.ATT_NULL_EncodingType, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary"));
                    attributes.add(this.createAttribute(WSSConstants.ATT_NULL_ValueType, "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ"));
                    attributes.add(this.createAttribute(WSSConstants.ATT_wsu_Id, this.securityToken.getId()));
                    this.createStartElementAndOutputAsEvent(subOutputProcessorChain, headerElementName, false, attributes);
                    this.createCharactersAndOutputAsEvent(subOutputProcessorChain, new Base64(76, new byte[]{10}).encodeToString(((KerberosClientSecurityToken)this.securityToken).getTicket()));
                    this.createEndElementAndOutputAsEvent(subOutputProcessorChain, headerElementName);
                    if (WSSConstants.ENCRYPT_WITH_KERBEROS_TOKEN.equals((Object)this.getAction())) {
                        WSSUtils.updateSecurityHeaderOrder(outputProcessorChain, WSSConstants.TAG_xenc_ReferenceList, this.getAction(), false);
                        WSSUtils.createReferenceListStructureForEncryption(this, subOutputProcessorChain);
                    }
                } else {
                    boolean useSingleCertificate = this.getSecurityProperties().isUseSingleCert();
                    WSSUtils.createBinarySecurityTokenStructure(this, subOutputProcessorChain, this.securityToken.getId(), this.securityToken.getX509Certificates(), useSingleCertificate);
                }
                outputProcessorChain.removeProcessor((OutputProcessor)this);
            }
        }
    }
}

