/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.stax.impl.processor.output;

import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.callback.Callback;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.codec.binary.Base64;
import org.apache.wss4j.common.derivedKey.AlgoFactory;
import org.apache.wss4j.common.derivedKey.ConversationException;
import org.apache.wss4j.common.derivedKey.DerivationAlgorithm;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.stax.ext.WSSConstants;
import org.apache.wss4j.stax.ext.WSSSecurityProperties;
import org.apache.wss4j.stax.ext.WSSUtils;
import org.apache.wss4j.stax.impl.processor.output.ReferenceListOutputProcessor;
import org.apache.wss4j.stax.securityToken.WSSecurityTokenConstants;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.config.JCEAlgorithmMapper;
import org.apache.xml.security.stax.ext.AbstractOutputProcessor;
import org.apache.xml.security.stax.ext.OutputProcessor;
import org.apache.xml.security.stax.ext.OutputProcessorChain;
import org.apache.xml.security.stax.ext.XMLSecurityConstants;
import org.apache.xml.security.stax.ext.stax.XMLSecAttribute;
import org.apache.xml.security.stax.ext.stax.XMLSecEvent;
import org.apache.xml.security.stax.impl.securityToken.GenericOutboundSecurityToken;
import org.apache.xml.security.stax.impl.util.IDGenerator;
import org.apache.xml.security.stax.securityToken.OutboundSecurityToken;
import org.apache.xml.security.stax.securityToken.SecurityToken;
import org.apache.xml.security.stax.securityToken.SecurityTokenConstants;
import org.apache.xml.security.stax.securityToken.SecurityTokenProvider;

public class DerivedKeyTokenOutputProcessor
extends AbstractOutputProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(XMLSecEvent xmlSecEvent, OutputProcessorChain outputProcessorChain) throws XMLStreamException, XMLSecurityException {
        try {
            byte[] derivedKeyBytes;
            DerivationAlgorithm derivationAlgorithm;
            byte[] label;
            String tokenId = (String)outputProcessorChain.getSecurityContext().get("PROP_USE_THIS_TOKEN_ID_FOR_DERIVED_KEY");
            if (tokenId == null) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE);
            }
            SecurityTokenProvider wrappingSecurityTokenProvider = outputProcessorChain.getSecurityContext().getSecurityTokenProvider(tokenId);
            if (wrappingSecurityTokenProvider == null) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE);
            }
            OutboundSecurityToken wrappingSecurityToken = (OutboundSecurityToken)wrappingSecurityTokenProvider.getSecurityToken();
            if (wrappingSecurityToken == null) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE);
            }
            final String wsuIdDKT = IDGenerator.generateID(null);
            int offset = 0;
            int length = 0;
            XMLSecurityConstants.Action action = this.getAction();
            if (WSSConstants.SIGNATURE_WITH_DERIVED_KEY.equals((Object)action)) {
                length = ((WSSSecurityProperties)this.getSecurityProperties()).getDerivedSignatureKeyLength() > 0 ? ((WSSSecurityProperties)this.getSecurityProperties()).getDerivedSignatureKeyLength() : JCEAlgorithmMapper.getKeyLengthFromURI((String)this.getSecurityProperties().getSignatureAlgorithm()) / 8;
            } else if (WSSConstants.ENCRYPT_WITH_DERIVED_KEY.equals((Object)action)) {
                length = ((WSSSecurityProperties)this.getSecurityProperties()).getDerivedEncryptionKeyLength() > 0 ? ((WSSSecurityProperties)this.getSecurityProperties()).getDerivedEncryptionKeyLength() : JCEAlgorithmMapper.getKeyLengthFromURI((String)this.getSecurityProperties().getEncryptionSymAlgorithm()) / 8;
            }
            try {
                String defaultLabel = "WS-SecureConversationWS-SecureConversation";
                label = defaultLabel.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "empty", (Exception)e, new Object[]{"UTF-8 encoding is not supported"});
            }
            byte[] nonce = WSSConstants.generateBytes((int)16);
            byte[] seed = new byte[label.length + nonce.length];
            System.arraycopy(label, 0, seed, 0, label.length);
            System.arraycopy(nonce, 0, seed, label.length, nonce.length);
            try {
                derivationAlgorithm = AlgoFactory.getInstance((String)"http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1");
            }
            catch (ConversationException e) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, (Exception)((Object)e));
            }
            try {
                byte[] secret;
                if (WSSecurityTokenConstants.SecurityContextToken.equals((Object)wrappingSecurityToken.getTokenType())) {
                    WSPasswordCallback passwordCallback = new WSPasswordCallback(wsuIdDKT, 9);
                    WSSUtils.doSecretKeyCallback(((WSSSecurityProperties)this.securityProperties).getCallbackHandler(), (Callback)passwordCallback, wsuIdDKT);
                    if (passwordCallback.getKey() == null) {
                        throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "noKey", new Object[]{wsuIdDKT});
                    }
                    secret = passwordCallback.getKey();
                } else {
                    secret = wrappingSecurityToken.getSecretKey("").getEncoded();
                }
                derivedKeyBytes = derivationAlgorithm.createKey(secret, seed, offset, (long)length);
            }
            catch (ConversationException e) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, (Exception)((Object)e));
            }
            final GenericOutboundSecurityToken derivedKeySecurityToken = new GenericOutboundSecurityToken(wsuIdDKT, WSSecurityTokenConstants.DerivedKeyToken){

                public Key getSecretKey(String algorithmURI) throws WSSecurityException {
                    Key key = null;
                    try {
                        key = super.getSecretKey(algorithmURI);
                    }
                    catch (XMLSecurityException e) {
                        throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, (Exception)((Object)e));
                    }
                    if (key != null) {
                        return key;
                    }
                    String algoFamily = JCEAlgorithmMapper.getJCEKeyAlgorithmFromURI((String)algorithmURI);
                    key = new SecretKeySpec(derivedKeyBytes, algoFamily);
                    this.setSecretKey(algorithmURI, key);
                    return key;
                }
            };
            derivedKeySecurityToken.setKeyWrappingToken(wrappingSecurityToken);
            wrappingSecurityToken.addWrappedToken((OutboundSecurityToken)derivedKeySecurityToken);
            SecurityTokenProvider<OutboundSecurityToken> derivedKeysecurityTokenProvider = new SecurityTokenProvider<OutboundSecurityToken>(){

                public OutboundSecurityToken getSecurityToken() throws WSSecurityException {
                    return derivedKeySecurityToken;
                }

                public String getId() {
                    return wsuIdDKT;
                }
            };
            if (WSSConstants.SIGNATURE_WITH_DERIVED_KEY.equals((Object)action)) {
                outputProcessorChain.getSecurityContext().put("PROP_USE_THIS_TOKEN_ID_FOR_SIGNATURE", (Object)wsuIdDKT);
            } else if (WSSConstants.ENCRYPT_WITH_DERIVED_KEY.equals((Object)action)) {
                outputProcessorChain.getSecurityContext().put("PROP_USE_THIS_TOKEN_ID_FOR_ENCRYPTION", (Object)wsuIdDKT);
            }
            outputProcessorChain.getSecurityContext().registerSecurityTokenProvider(wsuIdDKT, (SecurityTokenProvider)derivedKeysecurityTokenProvider);
            FinalDerivedKeyTokenOutputProcessor finalDerivedKeyTokenOutputProcessor = new FinalDerivedKeyTokenOutputProcessor((OutboundSecurityToken)derivedKeySecurityToken, offset, length, new String(Base64.encodeBase64((byte[])nonce)), ((WSSSecurityProperties)this.getSecurityProperties()).isUse200512Namespace(), wrappingSecurityToken.getSha1Identifier());
            finalDerivedKeyTokenOutputProcessor.setXMLSecurityProperties(this.getSecurityProperties());
            finalDerivedKeyTokenOutputProcessor.setAction(this.getAction());
            if (wrappingSecurityToken.getProcessor() != null) {
                finalDerivedKeyTokenOutputProcessor.addBeforeProcessor(wrappingSecurityToken.getProcessor());
            } else {
                finalDerivedKeyTokenOutputProcessor.addAfterProcessor(ReferenceListOutputProcessor.class.getName());
            }
            finalDerivedKeyTokenOutputProcessor.init(outputProcessorChain);
            derivedKeySecurityToken.setProcessor((Object)finalDerivedKeyTokenOutputProcessor);
        }
        finally {
            outputProcessorChain.removeProcessor((OutputProcessor)this);
        }
        outputProcessorChain.processEvent(xmlSecEvent);
    }

    class FinalDerivedKeyTokenOutputProcessor
    extends AbstractOutputProcessor {
        private final OutboundSecurityToken securityToken;
        private final int offset;
        private final int length;
        private final String nonce;
        private final boolean use200512Namespace;
        private final String sha1Identifier;

        FinalDerivedKeyTokenOutputProcessor(OutboundSecurityToken securityToken, int offset, int length, String nonce, boolean use200512Namespace, String sha1Identifier) throws XMLSecurityException {
            this.securityToken = securityToken;
            this.offset = offset;
            this.length = length;
            this.nonce = nonce;
            this.use200512Namespace = use200512Namespace;
            this.sha1Identifier = sha1Identifier;
        }

        public void processEvent(XMLSecEvent xmlSecEvent, OutputProcessorChain outputProcessorChain) throws XMLStreamException, XMLSecurityException {
            outputProcessorChain.processEvent(xmlSecEvent);
            if (WSSUtils.isSecurityHeaderElement(xmlSecEvent, ((WSSSecurityProperties)this.getSecurityProperties()).getActor())) {
                QName headerElementName = this.getHeaderElementName();
                WSSUtils.updateSecurityHeaderOrder(outputProcessorChain, headerElementName, this.getAction(), false);
                OutputProcessorChain subOutputProcessorChain = outputProcessorChain.createSubChain((OutputProcessor)this);
                ArrayList<XMLSecAttribute> attributes = new ArrayList<XMLSecAttribute>(1);
                attributes.add(this.createAttribute(WSSConstants.ATT_wsu_Id, this.securityToken.getId()));
                this.createStartElementAndOutputAsEvent(subOutputProcessorChain, headerElementName, true, attributes);
                this.createSecurityTokenReferenceStructureForDerivedKey(subOutputProcessorChain, this.securityToken, ((WSSSecurityProperties)this.getSecurityProperties()).getDerivedKeyKeyIdentifier(), ((WSSSecurityProperties)this.getSecurityProperties()).getDerivedKeyTokenReference(), this.getSecurityProperties().isUseSingleCert());
                this.createStartElementAndOutputAsEvent(subOutputProcessorChain, this.getOffsetName(), false, null);
                this.createCharactersAndOutputAsEvent(subOutputProcessorChain, "" + this.offset);
                this.createEndElementAndOutputAsEvent(subOutputProcessorChain, this.getOffsetName());
                this.createStartElementAndOutputAsEvent(subOutputProcessorChain, this.getLengthName(), false, null);
                this.createCharactersAndOutputAsEvent(subOutputProcessorChain, "" + this.length);
                this.createEndElementAndOutputAsEvent(subOutputProcessorChain, this.getLengthName());
                this.createStartElementAndOutputAsEvent(subOutputProcessorChain, this.getNonceName(), false, null);
                this.createCharactersAndOutputAsEvent(subOutputProcessorChain, this.nonce);
                this.createEndElementAndOutputAsEvent(subOutputProcessorChain, this.getNonceName());
                this.createEndElementAndOutputAsEvent(subOutputProcessorChain, headerElementName);
                outputProcessorChain.removeProcessor((OutputProcessor)this);
            }
        }

        protected void createSecurityTokenReferenceStructureForDerivedKey(OutputProcessorChain outputProcessorChain, OutboundSecurityToken securityToken, SecurityTokenConstants.KeyIdentifier keyIdentifier, WSSConstants.DerivedKeyTokenReference derivedKeyTokenReference, boolean useSingleCertificate) throws XMLStreamException, XMLSecurityException {
            SecurityToken wrappingToken = securityToken.getKeyWrappingToken();
            ArrayList<XMLSecAttribute> attributes = new ArrayList<XMLSecAttribute>(2);
            attributes.add(this.createAttribute(WSSConstants.ATT_wsu_Id, IDGenerator.generateID(null)));
            if (WSSecurityTokenConstants.KeyIdentifier_SecurityTokenDirectReference.equals((Object)keyIdentifier) && !useSingleCertificate) {
                attributes.add(this.createAttribute(WSSConstants.ATT_wsse11_TokenType, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509PKIPathv1"));
            } else if (derivedKeyTokenReference == WSSConstants.DerivedKeyTokenReference.EncryptedKey || WSSecurityTokenConstants.KeyIdentifier_EncryptedKeySha1Identifier.equals((Object)keyIdentifier)) {
                attributes.add(this.createAttribute(WSSConstants.ATT_wsse11_TokenType, "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey"));
            } else if (WSSecurityTokenConstants.KerberosToken.equals((Object)wrappingToken.getTokenType())) {
                attributes.add(this.createAttribute(WSSConstants.ATT_wsse11_TokenType, "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ"));
            }
            this.createStartElementAndOutputAsEvent(outputProcessorChain, WSSConstants.TAG_wsse_SecurityTokenReference, false, attributes);
            X509Certificate[] x509Certificates = wrappingToken.getX509Certificates();
            String tokenId = wrappingToken.getId();
            if (derivedKeyTokenReference == WSSConstants.DerivedKeyTokenReference.EncryptedKey) {
                String valueType = "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey";
                WSSUtils.createBSTReferenceStructure(this, outputProcessorChain, tokenId, valueType, true);
            } else if (WSSecurityTokenConstants.KeyIdentifier_IssuerSerial.equals((Object)keyIdentifier)) {
                WSSUtils.createX509IssuerSerialStructure((AbstractOutputProcessor)this, (OutputProcessorChain)outputProcessorChain, (X509Certificate[])x509Certificates);
            } else if (WSSecurityTokenConstants.KeyIdentifier_SkiKeyIdentifier.equals((Object)keyIdentifier)) {
                WSSUtils.createX509SubjectKeyIdentifierStructure(this, outputProcessorChain, x509Certificates);
            } else if (WSSecurityTokenConstants.KeyIdentifier_X509KeyIdentifier.equals((Object)keyIdentifier)) {
                WSSUtils.createX509KeyIdentifierStructure(this, outputProcessorChain, x509Certificates);
            } else if (WSSecurityTokenConstants.KeyIdentifier_KerberosSha1Identifier.equals((Object)keyIdentifier)) {
                String identifier = wrappingToken.getSha1Identifier();
                WSSUtils.createKerberosSha1IdentifierStructure(this, outputProcessorChain, identifier);
            } else if (WSSecurityTokenConstants.KeyIdentifier_ThumbprintIdentifier.equals((Object)keyIdentifier)) {
                WSSUtils.createThumbprintKeyIdentifierStructure(this, outputProcessorChain, x509Certificates);
            } else if (WSSecurityTokenConstants.KeyIdentifier_SecurityTokenDirectReference.equals((Object)keyIdentifier)) {
                boolean use200512Namespace;
                String valueType = WSSecurityTokenConstants.KerberosToken.equals((Object)wrappingToken.getTokenType()) ? "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ" : (WSSecurityTokenConstants.SpnegoContextToken.equals((Object)wrappingToken.getTokenType()) || WSSecurityTokenConstants.SecurityContextToken.equals((Object)wrappingToken.getTokenType()) || WSSecurityTokenConstants.SecureConversationToken.equals((Object)wrappingToken.getTokenType()) ? ((use200512Namespace = ((WSSSecurityProperties)this.getSecurityProperties()).isUse200512Namespace()) ? "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/sct" : "http://schemas.xmlsoap.org/ws/2005/02/sc/sct") : (useSingleCertificate ? "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3" : "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509PKIPathv1"));
                boolean included = ((WSSSecurityProperties)this.getSecurityProperties()).isIncludeSignatureToken();
                WSSUtils.createBSTReferenceStructure(this, outputProcessorChain, tokenId, valueType, included);
            } else if (WSSecurityTokenConstants.KeyIdentifier_EncryptedKeySha1Identifier.equals((Object)keyIdentifier)) {
                WSSUtils.createEncryptedKeySha1IdentifierStructure((AbstractOutputProcessor)this, outputProcessorChain, this.sha1Identifier);
            } else {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "unsupportedSecurityToken", new Object[0]);
            }
            this.createEndElementAndOutputAsEvent(outputProcessorChain, WSSConstants.TAG_wsse_SecurityTokenReference);
        }

        private QName getHeaderElementName() {
            if (this.use200512Namespace) {
                return WSSConstants.TAG_wsc0512_DerivedKeyToken;
            }
            return WSSConstants.TAG_wsc0502_DerivedKeyToken;
        }

        private QName getOffsetName() {
            if (this.use200512Namespace) {
                return WSSConstants.TAG_wsc0512_Offset;
            }
            return WSSConstants.TAG_wsc0502_Offset;
        }

        private QName getLengthName() {
            if (this.use200512Namespace) {
                return WSSConstants.TAG_wsc0512_Length;
            }
            return WSSConstants.TAG_wsc0502_Length;
        }

        private QName getNonceName() {
            if (this.use200512Namespace) {
                return WSSConstants.TAG_wsc0512_Nonce;
            }
            return WSSConstants.TAG_wsc0502_Nonce;
        }
    }
}

