/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.stax.impl.processor.output;

import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import org.apache.wss4j.common.ext.Attachment;
import org.apache.wss4j.common.ext.AttachmentRequestCallback;
import org.apache.wss4j.common.ext.AttachmentResultCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.AttachmentUtils;
import org.apache.wss4j.stax.ext.WSSConstants;
import org.apache.wss4j.stax.ext.WSSSecurityProperties;
import org.apache.wss4j.stax.ext.WSSUtils;
import org.apache.wss4j.stax.impl.processor.output.EncryptEndingOutputProcessor;
import org.apache.wss4j.stax.securityToken.WSSecurityTokenConstants;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.config.JCEAlgorithmMapper;
import org.apache.xml.security.stax.config.TransformerAlgorithmMapper;
import org.apache.xml.security.stax.ext.AbstractOutputProcessor;
import org.apache.xml.security.stax.ext.OutputProcessor;
import org.apache.xml.security.stax.ext.OutputProcessorChain;
import org.apache.xml.security.stax.ext.SecurePart;
import org.apache.xml.security.stax.ext.XMLSecurityConstants;
import org.apache.xml.security.stax.ext.stax.XMLSecAttribute;
import org.apache.xml.security.stax.ext.stax.XMLSecEvent;
import org.apache.xml.security.stax.ext.stax.XMLSecStartElement;
import org.apache.xml.security.stax.impl.EncryptionPartDef;
import org.apache.xml.security.stax.impl.processor.output.AbstractEncryptOutputProcessor;
import org.apache.xml.security.stax.impl.util.IDGenerator;
import org.apache.xml.security.stax.securityToken.OutboundSecurityToken;
import org.apache.xml.security.stax.securityToken.SecurityTokenConstants;
import org.apache.xml.security.stax.securityToken.SecurityTokenProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptOutputProcessor
extends AbstractEncryptOutputProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(EncryptOutputProcessor.class);

    public void init(OutputProcessorChain outputProcessorChain) throws XMLSecurityException {
        super.init(outputProcessorChain);
        EncryptEndingOutputProcessor encryptEndingOutputProcessor = new EncryptEndingOutputProcessor();
        encryptEndingOutputProcessor.setXMLSecurityProperties(this.getSecurityProperties());
        encryptEndingOutputProcessor.setAction(this.getAction());
        encryptEndingOutputProcessor.init(outputProcessorChain);
    }

    public void processEvent(XMLSecEvent xmlSecEvent, OutputProcessorChain outputProcessorChain) throws XMLStreamException, XMLSecurityException {
        if (xmlSecEvent.getEventType() == 1) {
            SecurePart securePart;
            XMLSecStartElement xmlSecStartElement = xmlSecEvent.asStartElement();
            if (this.getActiveInternalEncryptionOutputProcessor() == null && (securePart = this.securePartMatches(xmlSecStartElement, outputProcessorChain, "encryptionParts")) != null) {
                LOG.debug("Matched encryptionPart for encryption");
                String tokenId = (String)outputProcessorChain.getSecurityContext().get("PROP_USE_THIS_TOKEN_ID_FOR_ENCRYPTION");
                SecurityTokenProvider securityTokenProvider = outputProcessorChain.getSecurityContext().getSecurityTokenProvider(tokenId);
                OutboundSecurityToken securityToken = (OutboundSecurityToken)securityTokenProvider.getSecurityToken();
                EncryptionPartDef encryptionPartDef = new EncryptionPartDef();
                encryptionPartDef.setSecurePart(securePart);
                encryptionPartDef.setModifier(securePart.getModifier());
                encryptionPartDef.setEncRefId(IDGenerator.generateID(null));
                encryptionPartDef.setKeyId(securityTokenProvider.getId());
                encryptionPartDef.setSymmetricKey(securityToken.getSecretKey(this.getSecurityProperties().getEncryptionSymAlgorithm()));
                outputProcessorChain.getSecurityContext().putAsList(EncryptionPartDef.class, (Object)encryptionPartDef);
                InternalEncryptionOutputProcessor internalEncryptionOutputProcessor = new InternalEncryptionOutputProcessor(encryptionPartDef, xmlSecStartElement, outputProcessorChain.getDocumentContext().getEncoding(), securityToken);
                internalEncryptionOutputProcessor.setXMLSecurityProperties(this.getSecurityProperties());
                internalEncryptionOutputProcessor.setAction(this.getAction());
                internalEncryptionOutputProcessor.init(outputProcessorChain);
                this.setActiveInternalEncryptionOutputProcessor(internalEncryptionOutputProcessor);
                if ("Body".equals(xmlSecStartElement.getName().getLocalPart()) && WSSUtils.isInSOAPBody((XMLSecEvent)xmlSecStartElement)) {
                    this.doFinalInternal(outputProcessorChain);
                    outputProcessorChain.removeProcessor((OutputProcessor)this);
                }
            }
        }
        outputProcessorChain.processEvent(xmlSecEvent);
    }

    protected SecurePart securePartMatches(XMLSecStartElement xmlSecStartElement, Map<Object, SecurePart> secureParts) {
        if (xmlSecStartElement.getOnElementDeclaredAttributes().size() >= 0) {
            SecurePart securePart;
            Attribute attribute = xmlSecStartElement.getAttributeByName(WSSConstants.ATT_wsu_Id);
            if (attribute != null && (securePart = secureParts.get(attribute.getValue())) != null) {
                return securePart;
            }
            attribute = xmlSecStartElement.getAttributeByName(WSSConstants.ATT_NULL_Id);
            if (attribute != null && (securePart = secureParts.get(attribute.getValue())) != null) {
                return securePart;
            }
            attribute = xmlSecStartElement.getAttributeByName(WSSConstants.ATT_NULL_ID);
            if (attribute != null && (securePart = secureParts.get(attribute.getValue())) != null) {
                return securePart;
            }
            attribute = xmlSecStartElement.getAttributeByName(WSSConstants.ATT_NULL_AssertionID);
            if (attribute != null && (securePart = secureParts.get(attribute.getValue())) != null) {
                return securePart;
            }
        }
        return secureParts.get(xmlSecStartElement.getName());
    }

    public void doFinalInternal(OutputProcessorChain outputProcessorChain) throws XMLSecurityException {
        this.setupAttachmentEncryptionStreams(outputProcessorChain);
        super.doFinalInternal(outputProcessorChain);
    }

    protected void setupAttachmentEncryptionStreams(OutputProcessorChain outputProcessorChain) throws XMLSecurityException {
        SecurePart attachmentSecurePart = null;
        Map dynamicSecureParts = outputProcessorChain.getSecurityContext().getAsMap((Object)"encryptionParts");
        Iterator securePartsMapIterator = dynamicSecureParts.entrySet().iterator();
        String externalId = "";
        while (securePartsMapIterator.hasNext()) {
            Map.Entry securePartEntry = securePartsMapIterator.next();
            SecurePart securePart = (SecurePart)securePartEntry.getValue();
            String externalReference = securePart.getExternalReference();
            if (externalReference == null || !externalReference.startsWith("cid:")) continue;
            attachmentSecurePart = securePart;
            externalId = externalReference.substring(4);
            break;
        }
        if (attachmentSecurePart == null) {
            return;
        }
        CallbackHandler attachmentCallbackHandler = ((WSSSecurityProperties)this.getSecurityProperties()).getAttachmentCallbackHandler();
        if (attachmentCallbackHandler == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "empty", new Object[]{"no attachment callbackhandler supplied"});
        }
        AttachmentRequestCallback attachmentRequestCallback = new AttachmentRequestCallback();
        attachmentRequestCallback.setAttachmentId(externalId);
        try {
            attachmentCallbackHandler.handle(new Callback[]{attachmentRequestCallback});
        }
        catch (Exception e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, e);
        }
        List attachments = attachmentRequestCallback.getAttachments();
        for (int i = 0; i < attachments.size(); ++i) {
            Attachment attachment = (Attachment)attachments.get(i);
            String attachmentId = attachment.getId();
            String tokenId = (String)outputProcessorChain.getSecurityContext().get("PROP_USE_THIS_TOKEN_ID_FOR_ENCRYPTION");
            SecurityTokenProvider securityTokenProvider = outputProcessorChain.getSecurityContext().getSecurityTokenProvider(tokenId);
            OutboundSecurityToken securityToken = (OutboundSecurityToken)securityTokenProvider.getSecurityToken();
            EncryptionPartDef encryptionPartDef = new EncryptionPartDef();
            encryptionPartDef.setSecurePart(attachmentSecurePart);
            encryptionPartDef.setModifier(attachmentSecurePart.getModifier());
            encryptionPartDef.setCipherReferenceId(attachment.getId());
            encryptionPartDef.setMimeType(attachment.getMimeType());
            encryptionPartDef.setEncRefId(IDGenerator.generateID(null));
            encryptionPartDef.setKeyId(securityTokenProvider.getId());
            encryptionPartDef.setSymmetricKey(securityToken.getSecretKey(this.getSecurityProperties().getEncryptionSymAlgorithm()));
            outputProcessorChain.getSecurityContext().putAsList(EncryptionPartDef.class, (Object)encryptionPartDef);
            Attachment resultAttachment = new Attachment();
            resultAttachment.setId(attachmentId);
            resultAttachment.setMimeType("application/octet-stream");
            String encryptionSymAlgorithm = this.getSecurityProperties().getEncryptionSymAlgorithm();
            String jceAlgorithm = JCEAlgorithmMapper.translateURItoJCEID((String)encryptionSymAlgorithm);
            if (jceAlgorithm == null) {
                throw new XMLSecurityException("algorithms.NoSuchMap", new Object[]{encryptionSymAlgorithm});
            }
            Cipher cipher = null;
            try {
                cipher = Cipher.getInstance(jceAlgorithm);
                if ("AES/GCM/NoPadding".equals(cipher.getAlgorithm())) {
                    byte[] temp = XMLSecurityConstants.generateBytes((int)12);
                    IvParameterSpec ivParameterSpec = new IvParameterSpec(temp);
                    cipher.init(1, encryptionPartDef.getSymmetricKey(), ivParameterSpec);
                } else {
                    cipher.init(1, encryptionPartDef.getSymmetricKey());
                }
            }
            catch (Exception e) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_ENCRYPTION, e);
            }
            HashMap headers = new HashMap();
            headers.putAll(attachment.getHeaders());
            resultAttachment.setSourceStream(AttachmentUtils.setupAttachmentEncryptionStream((Cipher)cipher, (SecurePart.Modifier.Element == encryptionPartDef.getModifier() ? 1 : 0) != 0, (Attachment)attachment, headers));
            resultAttachment.addHeaders(headers);
            AttachmentResultCallback attachmentResultCallback = new AttachmentResultCallback();
            attachmentResultCallback.setAttachmentId(attachmentId);
            attachmentResultCallback.setAttachment(resultAttachment);
            try {
                attachmentCallbackHandler.handle(new Callback[]{attachmentResultCallback});
                continue;
            }
            catch (Exception e) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_ENCRYPTION, e);
            }
        }
    }

    class InternalEncryptionOutputProcessor
    extends AbstractEncryptOutputProcessor.AbstractInternalEncryptionOutputProcessor {
        private boolean doEncryptedHeader;
        private final OutboundSecurityToken securityToken;

        InternalEncryptionOutputProcessor(EncryptionPartDef encryptionPartDef, XMLSecStartElement xmlSecStartElement, String encoding, OutboundSecurityToken securityToken) throws XMLSecurityException, XMLStreamException {
            super((AbstractEncryptOutputProcessor)EncryptOutputProcessor.this, encryptionPartDef, xmlSecStartElement, encoding);
            this.doEncryptedHeader = false;
            this.addBeforeProcessor(EncryptEndingOutputProcessor.class.getName());
            this.addBeforeProcessor(InternalEncryptionOutputProcessor.class.getName());
            this.addAfterProcessor(EncryptOutputProcessor.class.getName());
            this.securityToken = securityToken;
        }

        protected OutputStream applyTransforms(OutputStream outputStream) throws XMLSecurityException {
            String compressionAlgorithm = ((WSSSecurityProperties)this.getSecurityProperties()).getEncryptionCompressionAlgorithm();
            if (compressionAlgorithm != null) {
                Class transformerClass = TransformerAlgorithmMapper.getTransformerClass((String)compressionAlgorithm, (XMLSecurityConstants.DIRECTION)XMLSecurityConstants.DIRECTION.OUT);
                try {
                    Constructor constructor = transformerClass.getConstructor(OutputStream.class);
                    outputStream = (OutputStream)constructor.newInstance(outputStream);
                }
                catch (InvocationTargetException e) {
                    throw new XMLSecurityException((Exception)e);
                }
                catch (NoSuchMethodException e) {
                    throw new XMLSecurityException((Exception)e);
                }
                catch (InstantiationException e) {
                    throw new XMLSecurityException((Exception)e);
                }
                catch (IllegalAccessException e) {
                    throw new XMLSecurityException((Exception)e);
                }
            }
            return outputStream;
        }

        protected void processEventInternal(XMLSecStartElement xmlSecStartElement, OutputProcessorChain outputProcessorChain) throws XMLStreamException, XMLSecurityException {
            List elementPath = xmlSecStartElement.getElementPath();
            if (elementPath.size() == 3 && WSSUtils.isInSOAPHeader(elementPath) && SecurePart.Modifier.Content != super.getEncryptionPartDef().getModifier()) {
                this.doEncryptedHeader = true;
                ArrayList<XMLSecAttribute> attributes = new ArrayList<XMLSecAttribute>(1);
                Iterator attributeIterator = this.getXmlSecStartElement().getAttributes();
                while (attributeIterator.hasNext()) {
                    Attribute attribute = (Attribute)attributeIterator.next();
                    if (attribute.isNamespace() || !"http://schemas.xmlsoap.org/soap/envelope/".equals(attribute.getName().getNamespaceURI()) && !"http://www.w3.org/2003/05/soap-envelope".equals(attribute.getName().getNamespaceURI())) continue;
                    attributes.add(this.createAttribute(attribute.getName(), attribute.getValue()));
                }
                this.createStartElementAndOutputAsEvent(outputProcessorChain, WSSConstants.TAG_wsse11_EncryptedHeader, true, attributes);
            }
            super.processEventInternal(xmlSecStartElement, outputProcessorChain);
        }

        protected void createKeyInfoStructure(OutputProcessorChain outputProcessorChain) throws XMLStreamException, XMLSecurityException {
            this.createStartElementAndOutputAsEvent(outputProcessorChain, XMLSecurityConstants.TAG_dsig_KeyInfo, true, null);
            if (this.securityToken.getCustomTokenReference() != null) {
                this.outputDOMElement(this.securityToken.getCustomTokenReference(), outputProcessorChain);
                this.createEndElementAndOutputAsEvent(outputProcessorChain, XMLSecurityConstants.TAG_dsig_KeyInfo);
                return;
            }
            SecurityTokenConstants.KeyIdentifier keyIdentifier = ((WSSSecurityProperties)this.getSecurityProperties()).getEncryptionKeyIdentifier();
            if (WSSecurityTokenConstants.KeyIdentifier_EncryptedKeySha1Identifier.equals((Object)keyIdentifier)) {
                ArrayList<XMLSecAttribute> attributes = new ArrayList<XMLSecAttribute>(1);
                attributes.add(this.createAttribute(WSSConstants.ATT_wsse11_TokenType, "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey"));
                this.createStartElementAndOutputAsEvent(outputProcessorChain, WSSConstants.TAG_wsse_SecurityTokenReference, false, attributes);
                if (this.securityToken.getSha1Identifier() != null) {
                    WSSUtils.createEncryptedKeySha1IdentifierStructure((AbstractOutputProcessor)this, outputProcessorChain, this.securityToken.getSha1Identifier());
                } else {
                    WSSUtils.createEncryptedKeySha1IdentifierStructure((AbstractOutputProcessor)this, outputProcessorChain, this.getEncryptionPartDef().getSymmetricKey());
                }
            } else if (WSSecurityTokenConstants.KeyIdentifier_KerberosSha1Identifier.equals((Object)keyIdentifier)) {
                ArrayList<XMLSecAttribute> attributes = new ArrayList<XMLSecAttribute>(1);
                attributes.add(this.createAttribute(WSSConstants.ATT_wsse11_TokenType, "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5_AP_REQ"));
                this.createStartElementAndOutputAsEvent(outputProcessorChain, WSSConstants.TAG_wsse_SecurityTokenReference, false, attributes);
                WSSUtils.createKerberosSha1IdentifierStructure((AbstractOutputProcessor)this, outputProcessorChain, this.securityToken.getSha1Identifier());
            } else {
                ArrayList<XMLSecAttribute> attributes;
                boolean isSAMLToken = false;
                if (WSSecurityTokenConstants.KerberosToken.equals((Object)this.securityToken.getTokenType())) {
                    attributes = new ArrayList<XMLSecAttribute>(2);
                    attributes.add(this.createAttribute(WSSConstants.ATT_wsu_Id, IDGenerator.generateID(null)));
                    attributes.add(this.createAttribute(WSSConstants.ATT_wsse11_TokenType, "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ"));
                    this.createStartElementAndOutputAsEvent(outputProcessorChain, WSSConstants.TAG_wsse_SecurityTokenReference, false, attributes);
                } else if (WSSecurityTokenConstants.Saml10Token.equals((Object)this.securityToken.getTokenType()) || WSSecurityTokenConstants.Saml11Token.equals((Object)this.securityToken.getTokenType())) {
                    attributes = new ArrayList(2);
                    attributes.add(this.createAttribute(WSSConstants.ATT_wsu_Id, IDGenerator.generateID(null)));
                    attributes.add(this.createAttribute(WSSConstants.ATT_wsse11_TokenType, "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1"));
                    this.createStartElementAndOutputAsEvent(outputProcessorChain, WSSConstants.TAG_wsse_SecurityTokenReference, false, attributes);
                    isSAMLToken = true;
                } else if (WSSecurityTokenConstants.Saml20Token.equals((Object)this.securityToken.getTokenType())) {
                    attributes = new ArrayList(2);
                    attributes.add(this.createAttribute(WSSConstants.ATT_wsu_Id, IDGenerator.generateID(null)));
                    attributes.add(this.createAttribute(WSSConstants.ATT_wsse11_TokenType, "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0"));
                    this.createStartElementAndOutputAsEvent(outputProcessorChain, WSSConstants.TAG_wsse_SecurityTokenReference, false, attributes);
                    isSAMLToken = true;
                } else if (WSSecurityTokenConstants.EncryptedKeyToken.equals((Object)this.securityToken.getTokenType())) {
                    attributes = new ArrayList(2);
                    attributes.add(this.createAttribute(WSSConstants.ATT_wsu_Id, IDGenerator.generateID(null)));
                    attributes.add(this.createAttribute(WSSConstants.ATT_wsse11_TokenType, "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey"));
                    this.createStartElementAndOutputAsEvent(outputProcessorChain, WSSConstants.TAG_wsse_SecurityTokenReference, false, attributes);
                } else {
                    this.createStartElementAndOutputAsEvent(outputProcessorChain, WSSConstants.TAG_wsse_SecurityTokenReference, true, null);
                }
                if (isSAMLToken) {
                    WSSUtils.createSAMLKeyIdentifierStructure((AbstractOutputProcessor)this, outputProcessorChain, this.securityToken.getTokenType(), this.getEncryptionPartDef().getKeyId());
                } else {
                    attributes = new ArrayList(1);
                    attributes.add(this.createAttribute(WSSConstants.ATT_NULL_URI, "#" + this.getEncryptionPartDef().getKeyId()));
                    if (WSSecurityTokenConstants.KerberosToken.equals((Object)this.securityToken.getTokenType())) {
                        attributes.add(this.createAttribute(WSSConstants.ATT_NULL_ValueType, "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ"));
                    } else if (WSSecurityTokenConstants.DerivedKeyToken.equals((Object)this.securityToken.getTokenType())) {
                        boolean use200512Namespace = ((WSSSecurityProperties)this.getSecurityProperties()).isUse200512Namespace();
                        if (use200512Namespace) {
                            attributes.add(this.createAttribute(WSSConstants.ATT_NULL_ValueType, "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk"));
                        } else {
                            attributes.add(this.createAttribute(WSSConstants.ATT_NULL_ValueType, "http://schemas.xmlsoap.org/ws/2005/02/sc/dk"));
                        }
                    } else if (WSSecurityTokenConstants.SpnegoContextToken.equals((Object)this.securityToken.getTokenType()) || WSSecurityTokenConstants.SecurityContextToken.equals((Object)this.securityToken.getTokenType()) || WSSecurityTokenConstants.SecureConversationToken.equals((Object)this.securityToken.getTokenType())) {
                        boolean use200512Namespace = ((WSSSecurityProperties)this.getSecurityProperties()).isUse200512Namespace();
                        if (use200512Namespace) {
                            attributes.add(this.createAttribute(WSSConstants.ATT_NULL_ValueType, "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/sct"));
                        } else {
                            attributes.add(this.createAttribute(WSSConstants.ATT_NULL_ValueType, "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/sct"));
                        }
                    } else if (WSSecurityTokenConstants.EncryptedKeyToken.equals((Object)this.securityToken.getTokenType())) {
                        attributes.add(this.createAttribute(WSSConstants.ATT_NULL_ValueType, "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey"));
                    }
                    this.createStartElementAndOutputAsEvent(outputProcessorChain, WSSConstants.TAG_wsse_Reference, false, attributes);
                    this.createEndElementAndOutputAsEvent(outputProcessorChain, WSSConstants.TAG_wsse_Reference);
                }
            }
            this.createEndElementAndOutputAsEvent(outputProcessorChain, WSSConstants.TAG_wsse_SecurityTokenReference);
            this.createEndElementAndOutputAsEvent(outputProcessorChain, XMLSecurityConstants.TAG_dsig_KeyInfo);
        }

        protected void doFinalInternal(OutputProcessorChain outputProcessorChain) throws XMLStreamException, XMLSecurityException {
            super.doFinalInternal(outputProcessorChain);
            if (this.doEncryptedHeader) {
                this.createEndElementAndOutputAsEvent(outputProcessorChain, WSSConstants.TAG_wsse11_EncryptedHeader);
            }
        }
    }
}

