/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.stax.impl.securityToken;

import java.security.Principal;
import javax.security.auth.Subject;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.principal.PublicKeyPrincipalImpl;
import org.apache.wss4j.stax.ext.WSInboundSecurityContext;
import org.apache.wss4j.stax.securityToken.RsaKeyValueSecurityToken;
import org.apache.xml.security.binding.xmldsig.RSAKeyValueType;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.ext.InboundSecurityContext;

public class RsaKeyValueSecurityTokenImpl
extends org.apache.xml.security.stax.impl.securityToken.RsaKeyValueSecurityToken
implements RsaKeyValueSecurityToken {
    private Crypto crypto;
    private Principal principal;

    public RsaKeyValueSecurityTokenImpl(RSAKeyValueType rsaKeyValueType, WSInboundSecurityContext wsInboundSecurityContext, Crypto crypto) {
        super(rsaKeyValueType, (InboundSecurityContext)wsInboundSecurityContext);
        this.crypto = crypto;
    }

    public void verify() throws XMLSecurityException {
        this.crypto.verifyTrust(this.getPublicKey());
    }

    @Override
    public Subject getSubject() throws WSSecurityException {
        return null;
    }

    @Override
    public Principal getPrincipal() throws WSSecurityException {
        if (this.principal == null) {
            try {
                this.principal = new PublicKeyPrincipalImpl(this.getPublicKey());
            }
            catch (XMLSecurityException e) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY_TOKEN, (Exception)((Object)e));
            }
        }
        return this.principal;
    }
}

