/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.osgi.bundle.util;

import java.net.URL;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.xbean.osgi.bundle.util.BundleClassLoader;
import org.apache.xbean.osgi.bundle.util.BundleDescription;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleUtils {
    public static boolean canStart(Bundle bundle) {
        return bundle.getState() != 1 && bundle.getState() != 8 && !BundleUtils.isFragment(bundle);
    }

    public static boolean canStop(Bundle bundle) {
        return bundle.getState() != 1 && bundle.getState() != 16 && !BundleUtils.isFragment(bundle);
    }

    public static boolean canUninstall(Bundle bundle) {
        return bundle.getState() != 1;
    }

    public static boolean isFragment(Bundle bundle) {
        Dictionary headers = bundle.getHeaders();
        return headers != null && headers.get("Fragment-Host") != null;
    }

    public static Bundle getContextBundle(boolean unwrap) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader instanceof BundleClassLoader) {
            return ((BundleClassLoader)classLoader).getBundle(unwrap);
        }
        if (classLoader instanceof BundleReference) {
            return ((BundleReference)classLoader).getBundle();
        }
        return null;
    }

    public static Enumeration<String> getEntryPaths(Bundle bundle, String name) {
        Enumeration entries = bundle.findEntries(name, null, false);
        if (entries == null) {
            return null;
        }
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        while (entries.hasMoreElements()) {
            URL url = (URL)entries.nextElement();
            String path = url.getPath();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            paths.add(path);
        }
        return Collections.enumeration(paths);
    }

    public static URL getEntry(Bundle bundle, String name) {
        String pattern;
        String path;
        int pos;
        if (name.equals("/")) {
            return bundle.getEntry(name);
        }
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        if ((pos = name.lastIndexOf("/")) == -1) {
            path = "/";
            pattern = name;
        } else if (pos == 0) {
            path = "/";
            pattern = name.substring(1);
        } else {
            path = name.substring(0, pos);
            pattern = name.substring(pos + 1);
        }
        Enumeration entries = bundle.findEntries(path, pattern, false);
        if (entries != null && entries.hasMoreElements()) {
            return (URL)entries.nextElement();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedHashSet<Bundle> getWiredBundles(Bundle bundle) {
        ServiceReference reference = bundle.getBundleContext().getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = (PackageAdmin)bundle.getBundleContext().getService(reference);
        try {
            LinkedHashSet<Bundle> linkedHashSet = BundleUtils.getWiredBundles(packageAdmin, bundle);
            return linkedHashSet;
        }
        finally {
            bundle.getBundleContext().ungetService(reference);
        }
    }

    public static LinkedHashSet<Bundle> getWiredBundles(PackageAdmin packageAdmin, Bundle bundle) {
        BundleDescription description = new BundleDescription(bundle.getHeaders());
        List<BundleDescription.ImportPackage> imports = description.getExternalImports();
        LinkedHashSet<Bundle> wiredBundles = new LinkedHashSet<Bundle>();
        for (BundleDescription.ImportPackage packageImport : imports) {
            ExportedPackage[] exports = packageAdmin.getExportedPackages(packageImport.getName());
            Bundle wiredBundle = BundleUtils.getWiredBundle(bundle, exports);
            if (wiredBundle == null) continue;
            wiredBundles.add(wiredBundle);
        }
        if (!description.getDynamicImportPackage().isEmpty()) {
            for (Bundle b : bundle.getBundleContext().getBundles()) {
                ExportedPackage[] exports;
                Bundle wiredBundle;
                if (wiredBundles.contains(b) || (wiredBundle = BundleUtils.getWiredBundle(bundle, exports = packageAdmin.getExportedPackages(b))) == null) continue;
                wiredBundles.add(wiredBundle);
            }
        }
        return wiredBundles;
    }

    private static Bundle getWiredBundle(Bundle bundle, ExportedPackage[] exports) {
        if (exports != null) {
            for (ExportedPackage exportedPackage : exports) {
                Bundle[] importingBundles = exportedPackage.getImportingBundles();
                if (importingBundles == null) continue;
                for (Bundle importingBundle : importingBundles) {
                    if (importingBundle != bundle) continue;
                    return exportedPackage.getExportingBundle();
                }
            }
        }
        return null;
    }
}

