/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.finder;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceFinder {
    private final String path;
    private final ClassLoader classLoader;

    public ResourceFinder(String path) {
        this(path, Thread.currentThread().getContextClassLoader());
    }

    public ResourceFinder(String path, ClassLoader classLoader) {
        this.path = path;
        this.classLoader = classLoader;
    }

    public String findString(String key) throws IOException {
        String uri = this.path + key;
        URL resource = this.classLoader.getResource(uri);
        if (resource == null) {
            throw new IOException("Could not find command in : " + uri);
        }
        return this.readContents(resource);
    }

    public List<String> findAllStrings(String key) throws IOException {
        String uri = this.path + key;
        ArrayList<String> strings = new ArrayList<String>();
        Enumeration<URL> resources = this.classLoader.getResources(uri);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            String string = this.readContents(url);
            strings.add(string);
        }
        return strings;
    }

    public List<String> findAvailableStrings(String key) throws IOException {
        String uri = this.path + key;
        ArrayList<String> strings = new ArrayList<String>();
        Enumeration<URL> resources = this.classLoader.getResources(uri);
        while (resources.hasMoreElements()) {
            try {
                URL url = resources.nextElement();
                String string = this.readContents(url);
                strings.add(string);
            }
            catch (Exception notAvailable) {}
        }
        return strings;
    }

    public Map<String, String> mapAllStrings(String key) throws IOException {
        HashMap<String, String> strings = new HashMap<String, String>();
        Map<String, URL> resourcesMap = this.getResourcesMap(key);
        for (Map.Entry<String, URL> entry : resourcesMap.entrySet()) {
            String name = entry.getKey();
            URL url = entry.getValue();
            String value = this.readContents(url);
            strings.put(name, value);
        }
        return strings;
    }

    public Map<String, String> mapAvailableStrings(String key) throws IOException {
        HashMap<String, String> strings = new HashMap<String, String>();
        Map<String, URL> resourcesMap = this.getResourcesMap(key);
        Iterator<Map.Entry<String, URL>> iterator = resourcesMap.entrySet().iterator();
        while (iterator.hasNext()) {
            try {
                Map.Entry<String, URL> entry = iterator.next();
                String name = entry.getKey();
                URL url = entry.getValue();
                String value = this.readContents(url);
                strings.put(name, value);
            }
            catch (Exception notAvailable) {}
        }
        return strings;
    }

    public Class findClass(String key) throws IOException, ClassNotFoundException {
        String className = this.findString(key);
        Class<?> clazz = this.classLoader.loadClass(className);
        return clazz;
    }

    public List<Class> findAllClasses(String key) throws IOException, ClassNotFoundException {
        ArrayList<Class> classes = new ArrayList<Class>();
        List<String> strings = this.findAllStrings(key);
        for (String className : strings) {
            Class<?> clazz = this.classLoader.loadClass(className);
            classes.add(clazz);
        }
        return classes;
    }

    public List<Class> findAvailableClasses(String key) throws IOException {
        ArrayList<Class> classes = new ArrayList<Class>();
        List<String> strings = this.findAvailableStrings(key);
        for (String className : strings) {
            try {
                Class<?> clazz = this.classLoader.loadClass(className);
                classes.add(clazz);
            }
            catch (Exception notAvailable) {}
        }
        return classes;
    }

    public Map<String, Class> mapAllClasses(String key) throws IOException, ClassNotFoundException {
        HashMap<String, Class> classes = new HashMap<String, Class>();
        Map<String, String> map = this.mapAllStrings(key);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String className = entry.getValue();
            Class<?> clazz = this.classLoader.loadClass(className);
            classes.put(string, clazz);
        }
        return classes;
    }

    public Map<String, Class> mapAvailableClasses(String key) throws IOException {
        HashMap<String, Class> classes = new HashMap<String, Class>();
        Map<String, String> map = this.mapAvailableStrings(key);
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            try {
                Map.Entry<String, String> entry = iterator.next();
                String string = entry.getKey();
                String className = entry.getValue();
                Class<?> clazz = this.classLoader.loadClass(className);
                classes.put(string, clazz);
            }
            catch (Exception notAvailable) {}
        }
        return classes;
    }

    public Class findImplementation(Class interfase) throws IOException, ClassNotFoundException {
        String className = this.findString(interfase.getName());
        Class<?> impl = this.classLoader.loadClass(className);
        if (!interfase.isAssignableFrom(impl)) {
            throw new ClassCastException("Class not of type: " + interfase.getName());
        }
        return impl;
    }

    public List<Class> findAllImplementations(Class interfase) throws IOException, ClassNotFoundException {
        ArrayList<Class> implementations = new ArrayList<Class>();
        List<String> strings = this.findAllStrings(interfase.getName());
        for (String className : strings) {
            Class<?> impl = this.classLoader.loadClass(className);
            if (!interfase.isAssignableFrom(impl)) {
                throw new ClassCastException("Class not of type: " + interfase.getName());
            }
            implementations.add(impl);
        }
        return implementations;
    }

    public List<Class> findAvailableImplementations(Class interfase) throws IOException {
        ArrayList<Class> implementations = new ArrayList<Class>();
        List<String> strings = this.findAvailableStrings(interfase.getName());
        for (String className : strings) {
            try {
                Class<?> impl = this.classLoader.loadClass(className);
                if (!interfase.isAssignableFrom(impl)) continue;
                implementations.add(impl);
            }
            catch (Exception notAvailable) {}
        }
        return implementations;
    }

    public Map<String, Class> mapAllImplementations(Class interfase) throws IOException, ClassNotFoundException {
        HashMap<String, Class> implementations = new HashMap<String, Class>();
        Map<String, String> map = this.mapAllStrings(interfase.getName());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String className = entry.getValue();
            Class<?> impl = this.classLoader.loadClass(className);
            if (!interfase.isAssignableFrom(impl)) {
                throw new ClassCastException("Class not of type: " + interfase.getName());
            }
            implementations.put(string, impl);
        }
        return implementations;
    }

    public Map<String, Class> mapAvailableImplementations(Class interfase) throws IOException {
        HashMap<String, Class> implementations = new HashMap<String, Class>();
        Map<String, String> map = this.mapAvailableStrings(interfase.getName());
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            try {
                Map.Entry<String, String> entry = iterator.next();
                String string = entry.getKey();
                String className = entry.getValue();
                Class<?> impl = this.classLoader.loadClass(className);
                if (!interfase.isAssignableFrom(impl)) continue;
                implementations.put(string, impl);
            }
            catch (Exception notAvailable) {}
        }
        return implementations;
    }

    public Properties findProperties(String key) throws IOException {
        String uri = this.path + key;
        URL resource = this.classLoader.getResource(uri);
        if (resource == null) {
            throw new IOException("Could not find command in : " + uri);
        }
        return this.loadProperties(resource);
    }

    public List<Properties> findAllProperties(String key) throws IOException {
        String uri = this.path + key;
        ArrayList<Properties> properties = new ArrayList<Properties>();
        Enumeration<URL> resources = this.classLoader.getResources(uri);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            Properties props = this.loadProperties(url);
            properties.add(props);
        }
        return properties;
    }

    public List<Properties> findAvailableProperties(String key) throws IOException {
        String uri = this.path + key;
        ArrayList<Properties> properties = new ArrayList<Properties>();
        Enumeration<URL> resources = this.classLoader.getResources(uri);
        while (resources.hasMoreElements()) {
            try {
                URL url = resources.nextElement();
                Properties props = this.loadProperties(url);
                properties.add(props);
            }
            catch (Exception notAvailable) {}
        }
        return properties;
    }

    public Map<String, Properties> mapAllProperties(String key) throws IOException {
        HashMap<String, Properties> propertiesMap = new HashMap<String, Properties>();
        Map<String, URL> map = this.getResourcesMap(key);
        for (Map.Entry<String, URL> entry : map.entrySet()) {
            String string = entry.getKey();
            URL url = entry.getValue();
            Properties properties = this.loadProperties(url);
            propertiesMap.put(string, properties);
        }
        return propertiesMap;
    }

    public Map<String, Properties> mapAvailableProperties(String key) throws IOException {
        HashMap<String, Properties> propertiesMap = new HashMap<String, Properties>();
        Map<String, URL> map = this.getResourcesMap(key);
        Iterator<Map.Entry<String, URL>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            try {
                Map.Entry<String, URL> entry = iterator.next();
                String string = entry.getKey();
                URL url = entry.getValue();
                Properties properties = this.loadProperties(url);
                propertiesMap.put(string, properties);
            }
            catch (Exception notAvailable) {}
        }
        return propertiesMap;
    }

    public Map<String, URL> getResourcesMap(String key) throws IOException {
        String basePath = this.path + key;
        HashMap<String, URL> resources = new HashMap<String, URL>();
        if (!basePath.endsWith("/")) {
            basePath = basePath + "/";
        }
        Enumeration<URL> urls = this.classLoader.getResources(basePath);
        while (urls.hasMoreElements()) {
            URL location = urls.nextElement();
            try {
                if (location.getProtocol().equals("jar")) {
                    ResourceFinder.readJarEntries(location, basePath, resources);
                    continue;
                }
                if (!location.getProtocol().equals("file")) continue;
                ResourceFinder.readDirectoryEntries(location, resources);
            }
            catch (Exception e) {}
        }
        return resources;
    }

    private static void readDirectoryEntries(URL location, Map<String, URL> resources) throws MalformedURLException {
        File dir = new File(location.getPath());
        if (dir.isDirectory()) {
            File[] files;
            for (File file : files = dir.listFiles()) {
                if (file.isDirectory()) continue;
                String name = file.getName();
                URL url = file.toURL();
                resources.put(name, url);
            }
        }
    }

    private static void readJarEntries(URL location, String basePath, Map<String, URL> resources) throws IOException {
        JarURLConnection conn = (JarURLConnection)location.openConnection();
        JarFile jarfile = conn.getJarFile();
        Enumeration<JarEntry> entries = jarfile.entries();
        while (entries != null && entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (entry.isDirectory() || !name.startsWith(basePath) || name.length() == basePath.length() || (name = name.substring(basePath.length())).contains("/")) continue;
            URL resource = new URL(location, name);
            resources.put(name, resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(URL resource) throws IOException {
        InputStream in = resource.openStream();
        BufferedInputStream reader = null;
        try {
            reader = new BufferedInputStream(in);
            Properties properties = new Properties();
            properties.load(reader);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            try {
                in.close();
                reader.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readContents(URL resource) throws IOException {
        InputStream in = resource.openStream();
        BufferedInputStream reader = null;
        StringBuffer sb = new StringBuffer();
        try {
            reader = new BufferedInputStream(in);
            int b = reader.read();
            while (b != -1) {
                sb.append((char)b);
                b = reader.read();
            }
            String string = sb.toString().trim();
            return string;
        }
        finally {
            try {
                in.close();
                reader.close();
            }
            catch (Exception e) {}
        }
    }

    public Enumeration doFindCommands() throws IOException {
        return Thread.currentThread().getContextClassLoader().getResources(this.path);
    }
}

