/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.server.spring.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.xbean.kernel.AbstractServiceFactory;
import org.apache.xbean.kernel.ServiceCondition;
import org.apache.xbean.kernel.ServiceConditionContext;
import org.apache.xbean.kernel.ServiceContext;
import org.apache.xbean.kernel.ServiceFactory;
import org.apache.xbean.kernel.ServiceName;
import org.apache.xbean.server.spring.configuration.SpringConfiguration;
import org.springframework.context.support.AbstractXmlApplicationContext;

public class SpringConfigurationServiceFactory
extends AbstractServiceFactory {
    private final AbstractXmlApplicationContext applicationContext;
    private final ConfigurationStopCondition configurationStopCondition;
    private SpringConfiguration springConfiguration;

    public SpringConfigurationServiceFactory(AbstractXmlApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.configurationStopCondition = new ConfigurationStopCondition();
        this.addStopCondition(this.configurationStopCondition);
    }

    public String getId() {
        return this.applicationContext.getDisplayName();
    }

    public AbstractXmlApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Class[] getTypes() {
        return new Class[]{SpringConfiguration.class};
    }

    public boolean isRestartable() {
        return false;
    }

    public Set getOwnedServices() {
        if (this.springConfiguration != null) {
            return new HashSet(this.springConfiguration.getServiceFactories().keySet());
        }
        return Collections.EMPTY_SET;
    }

    public Object createService(ServiceContext serviceContext) throws Exception {
        this.springConfiguration = new SpringConfiguration(this.applicationContext, serviceContext.getKernel());
        Set ownedServices = this.springConfiguration.getServiceFactories().keySet();
        for (Map.Entry entry : this.springConfiguration.getServiceFactories().entrySet()) {
            ServiceName serviceName = (ServiceName)entry.getKey();
            ServiceFactory serviceFactory = (ServiceFactory)entry.getValue();
            if (!ownedServices.contains(serviceName)) continue;
            serviceFactory.addStopCondition(this.configurationStopCondition.createOwnedServiceStopCondition());
        }
        return this.springConfiguration;
    }

    public void destroyService(ServiceContext serviceContext) {
        if (this.springConfiguration != null) {
            this.springConfiguration.destroy();
            this.springConfiguration = null;
        }
        this.applicationContext.close();
    }

    public ClassLoader getClassLoader() {
        return SpringConfiguration.getClassLoader(this.applicationContext);
    }

    private static class ConfigurationStopCondition
    implements ServiceCondition {
        private final List ownedServiceConditions = new ArrayList();

        private ConfigurationStopCondition() {
        }

        public synchronized void initialize(ServiceConditionContext context) {
            for (OwnedServiceCondition ownedServiceCondition : this.ownedServiceConditions) {
                ownedServiceCondition.setSatisfied();
            }
        }

        public boolean isSatisfied() {
            return true;
        }

        public synchronized void destroy() {
            for (OwnedServiceCondition ownedServiceCondition : this.ownedServiceConditions) {
                ownedServiceCondition.setSatisfied();
            }
        }

        public ServiceCondition createOwnedServiceStopCondition() {
            OwnedServiceCondition ownedServiceCondition = new OwnedServiceCondition();
            this.ownedServiceConditions.add(ownedServiceCondition);
            return ownedServiceCondition;
        }

        private static class OwnedServiceCondition
        implements ServiceCondition {
            private boolean satisfied = false;
            private ServiceConditionContext context;

            private OwnedServiceCondition() {
            }

            public synchronized void initialize(ServiceConditionContext context) {
                this.context = context;
            }

            public synchronized boolean isSatisfied() {
                return this.satisfied;
            }

            private void setSatisfied() {
                this.satisfied = true;
                if (this.context != null) {
                    this.context.setSatisfied();
                }
            }

            public synchronized void destroy() {
                this.context = null;
            }
        }
    }
}

