/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.spring.context.v2b;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import org.apache.xbean.spring.context.impl.PropertyEditorHelper;
import org.apache.xbean.spring.context.impl.QNameReflectionHelper;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.w3c.dom.Element;

public class XBeanQNameHelper {
    private XmlReaderContext readerContext;
    private boolean qnameIsOnClassPath;
    private boolean initQNameOnClassPath;

    public XBeanQNameHelper(XmlReaderContext readerContext) {
        this.readerContext = readerContext;
    }

    public void coerceNamespaceAwarePropertyValues(BeanDefinition definition, Element element) {
        AbstractBeanDefinition bd;
        BeanInfo beanInfo;
        if (definition instanceof AbstractBeanDefinition && this.isQnameIsOnClassPath() && (beanInfo = this.getBeanInfo((bd = (AbstractBeanDefinition)definition).getBeanClassName())) != null) {
            PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < descriptors.length; ++i) {
                QNameReflectionHelper.coerceNamespaceAwarePropertyValues((AbstractBeanDefinition)bd, (Element)element, (PropertyDescriptor[])descriptors, (int)i);
            }
        }
    }

    public BeanInfo getBeanInfo(String className) throws BeanDefinitionStoreException {
        if (className == null) {
            return null;
        }
        BeanInfo info = null;
        Class type = null;
        try {
            type = this.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new BeanDefinitionStoreException("Failed to load type: " + className + ". Reason: " + e, (Throwable)e);
        }
        try {
            info = Introspector.getBeanInfo(type);
        }
        catch (IntrospectionException e) {
            throw new BeanDefinitionStoreException("Failed to introspect type: " + className + ". Reason: " + e, (Throwable)e);
        }
        return info;
    }

    protected Class loadClass(String name) throws ClassNotFoundException {
        ClassLoader contextClassLoader;
        ClassLoader beanClassLoader = this.readerContext.getReader().getBeanClassLoader();
        if (beanClassLoader != null) {
            try {
                return beanClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if ((contextClassLoader = Thread.currentThread().getContextClassLoader()) != null) {
            try {
                return contextClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return this.getClass().getClassLoader().loadClass(name);
    }

    protected boolean isQnameIsOnClassPath() {
        if (!this.initQNameOnClassPath) {
            this.qnameIsOnClassPath = PropertyEditorHelper.loadClass((String)"javax.xml.namespace.QName") != null;
            this.initQNameOnClassPath = true;
        }
        return this.qnameIsOnClassPath;
    }
}

