/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.util;

import java.util.ArrayList;

public class ByteString
implements Comparable,
Cloneable {
    private byte[] data;
    private final int pos;
    private final int len;
    private String string;
    private int hash;

    public ByteString(byte[] data, int pos, int len) {
        this.data = data;
        this.pos = pos;
        this.len = len;
        if (len < 0 || pos + len > data.length || pos < 0) {
            throw new IndexOutOfBoundsException("byte[" + data.length + "], " + pos + ", " + len);
        }
    }

    public ByteString(byte[] data) {
        this(data, 0, data.length);
    }

    public ByteString(String value) {
        this.pos = 0;
        this.len = value.length();
        this.data = new byte[this.len];
        for (int i = 0; i < this.len; ++i) {
            this.data[i] = (byte)value.charAt(i);
        }
    }

    public char charAt(int i) {
        return (char)this.byteAt(i);
    }

    public byte byteAt(int i) {
        if (i < 0 || i >= this.len) {
            throw new IndexOutOfBoundsException("" + i);
        }
        return this.data[this.pos + i];
    }

    public int length() {
        return this.len;
    }

    public Object clone() {
        ByteString result = new ByteString(this.data, this.pos, this.len);
        result.string = this.string;
        result.hash = this.hash;
        return result;
    }

    public int compareTo(Object o) {
        ByteString other = (ByteString)o;
        int min = this.len < other.len ? this.len : other.len;
        for (int i = 0; i < min; ++i) {
            byte me = this.data[this.pos + i];
            byte him = other.data[other.pos + i];
            if (me < him) {
                return -1;
            }
            if (me <= him) continue;
            return 1;
        }
        return this.len - other.len;
    }

    public ByteString substring(int index) {
        if (index < 0 || index > this.len) {
            throw new IndexOutOfBoundsException("" + index);
        }
        return new ByteString(this.data, this.pos + index, this.len - index);
    }

    public ByteString substring(int index, int endindex) {
        if (index < 0 || endindex > this.len) {
            throw new IndexOutOfBoundsException("" + index);
        }
        ByteString result = new ByteString(this.data, this.pos + index, endindex - index);
        return result;
    }

    public int indexOf(char ch) {
        return this.indexOf(ch, 0);
    }

    public int indexOf(char ch, int index) {
        return this.indexOf((byte)ch, index);
    }

    public int indexOf(byte by, int index) {
        int start = this.pos + index;
        int end = start + this.len;
        if (index < 0 || index >= this.len) {
            return -1;
        }
        for (int i = start; i < end; ++i) {
            if (this.data[i] != by) continue;
            return i - this.pos;
        }
        return -1;
    }

    public int lastIndexOf(char ch) {
        return this.lastIndexOf(ch, this.len - 1);
    }

    public int lastIndexOf(char ch, int index) {
        return this.lastIndexOf((byte)ch, index);
    }

    public int lastIndexOf(byte by, int index) {
        int start = this.pos + index;
        int end = this.pos;
        if (start >= this.pos + this.len) {
            return -1;
        }
        for (int i = start; i >= end; --i) {
            if (this.data[i] != by) continue;
            return i - this.pos;
        }
        return -1;
    }

    public boolean startsWith(ByteString prefix) {
        if (prefix.len > this.len) {
            return false;
        }
        for (int i = 0; i < prefix.len; ++i) {
            if (this.byteAt(i) == prefix.byteAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean startsWithIgnoreCase(ByteString prefix) {
        if (prefix.len > this.len) {
            return false;
        }
        for (int i = 0; i < prefix.len; ++i) {
            byte b2;
            byte b1 = this.byteAt(i);
            if (b1 == (b2 = prefix.byteAt(i)) || ByteString.toLowerCase(b1) == ByteString.toLowerCase(b2)) continue;
            return false;
        }
        return true;
    }

    public boolean startsWithIgnoreCase(String prefix) {
        if (prefix.length() > this.len) {
            return false;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            if (ByteString.toLowerCase(this.byteAt(i)) == ByteString.toLowerCase((byte)prefix.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(ByteString postfix) {
        if (postfix.len > this.len) {
            return false;
        }
        for (int i = 0; i < postfix.len; ++i) {
            if (this.byteAt(i) == postfix.byteAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String prefix) {
        if (prefix.length() > this.len) {
            return false;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            if (this.charAt(i) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(String postfix) {
        if (postfix.length() > this.len) {
            return false;
        }
        for (int i = 0; i < postfix.length(); ++i) {
            if (this.charAt(i) == postfix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static byte toUpperCase(byte ch) {
        if (ch >= 97 && ch <= 122) {
            return (byte)(ch - 97 + 65);
        }
        if (ch >= -32 && ch <= -2 && ch != -9) {
            return (byte)(ch - 224 + 192);
        }
        return ch;
    }

    private static byte toLowerCase(byte ch) {
        if (ch >= 65 && ch <= 90) {
            return (byte)(ch - 65 + 97);
        }
        if (ch >= -64 && ch <= -34 && ch != -41) {
            return (byte)(ch - 192 + 224);
        }
        return ch;
    }

    public ByteString toUpperCase(boolean overwrite) {
        if (!overwrite) {
            return this.toUpperCase();
        }
        for (int i = 0; i < this.len; ++i) {
            this.data[this.pos + i] = ByteString.toUpperCase(this.data[this.pos + i]);
        }
        return this;
    }

    public ByteString toUpperCase() {
        boolean didChange = false;
        byte[] up = null;
        for (int i = 0; i < this.len; ++i) {
            byte ch = this.data[this.pos + i];
            byte newCh = ByteString.toUpperCase(ch);
            if (ch != newCh && !didChange) {
                up = new byte[this.len];
                didChange = true;
                for (int j = 0; j < i; ++j) {
                    up[j] = this.data[this.pos + j];
                }
            }
            if (!didChange) continue;
            up[i] = newCh;
        }
        if (didChange) {
            return new ByteString(up, 0, this.len);
        }
        return this;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            int off = this.pos;
            byte[] val = this.data;
            for (int i = 0; i < this.len; ++i) {
                h = 31 * h + val[off++];
            }
            this.hash = h;
        }
        return h;
    }

    public int lowerCaseHashCode() {
        int h = 0;
        int off = this.pos;
        byte[] val = this.data;
        for (int i = 0; i < this.len; ++i) {
            h = 31 * h + ByteString.toLowerCase(val[off++]);
        }
        this.hash = h;
        return h;
    }

    public boolean equals(ByteString bs) {
        if (bs == null) {
            return false;
        }
        if (this.len != bs.len) {
            return false;
        }
        for (int i = 0; i < this.len; ++i) {
            if (this.data[this.pos + i] == bs.data[bs.pos + i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof ByteString)) {
            if (other instanceof String) {
                return this.toString().equals(other);
            }
            return false;
        }
        return this.equals((ByteString)other);
    }

    public boolean equalsIgnoreCase(Object other) {
        if (other instanceof ByteString) {
            return this.equalsIgnoreCase((ByteString)other);
        }
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof String) {
            return this.equalsIgnoreCase((String)other);
        }
        return false;
    }

    public boolean equalsIgnoreCase(ByteString bs) {
        if (bs == null) {
            return false;
        }
        if (this.len != bs.len) {
            return false;
        }
        for (int i = 0; i < this.len; ++i) {
            if (ByteString.toLowerCase(this.data[this.pos + i]) == ByteString.toLowerCase(bs.data[bs.pos + i])) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(String s) {
        if (this.len != s.length()) {
            return false;
        }
        for (int i = 0; i < this.len; ++i) {
            char c2;
            char c1 = (char)ByteString.toLowerCase(this.byteAt(i));
            if (c1 == (c2 = s.charAt(i)) || c1 == Character.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSpace(byte value) {
        return value == 32 || value == 9 || value == 10 || value == 13;
    }

    public ByteString trim() {
        int newStart;
        int newEnd = this.pos + this.len;
        for (newStart = this.pos; newStart < newEnd && ByteString.isSpace(this.data[newStart]); ++newStart) {
        }
        while (newStart < newEnd && ByteString.isSpace(this.data[newEnd - 1])) {
            --newEnd;
        }
        int newLen = newEnd - newStart;
        if (newLen == this.len) {
            return this;
        }
        return new ByteString(this.data, newStart, newLen);
    }

    public String toString() {
        if (this.string == null) {
            char[] chars = new char[this.len];
            for (int i = 0; i < this.len; ++i) {
                chars[i] = (char)this.data[this.pos + i];
            }
            this.string = new String(chars);
        }
        return this.string;
    }

    public ByteString[] split(char c) {
        ArrayList<ByteString> list = new ArrayList<ByteString>();
        int start = 0;
        for (int pos = 0; pos < this.len; ++pos) {
            if (this.charAt(pos) != c) continue;
            list.add(this.substring(start, pos));
            start = pos + 1;
        }
        if (start == 0) {
            return new ByteString[]{this};
        }
        list.add(this.substring(start, this.len));
        ByteString[] bsa = new ByteString[list.size()];
        list.toArray(bsa);
        return bsa;
    }

    public void copyInto(byte[] data, int off) {
        for (int i = 0; i < this.len; ++i) {
            data[i + off] = this.byteAt(i);
        }
    }

    byte[] getData() {
        return this.data;
    }

    protected void setData(byte[] data) {
        this.data = data;
    }

    int getOffset() {
        return this.pos;
    }

    public int parseInt(int start) {
        byte ch;
        int off;
        int pos = off = this.pos + start;
        int value = 0;
        while (this.data[pos] == 32 || this.data[pos] == 9) {
            ++pos;
        }
        while (pos < off + this.len && (ch = this.data[pos++]) >= 48 && ch <= 57) {
            int digit = ch - 48;
            value = value * 10 + digit;
        }
        return value;
    }
}

