/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.r;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterOutput;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.interpreter.LazyOpenInterpreter;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterEventClient;
import org.apache.zeppelin.r.ShinyInterpreter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class ShinyInterpreterTest {
    protected ShinyInterpreter interpreter;

    @BeforeEach
    public void setUp() throws InterpreterException {
        Properties properties = new Properties();
        InterpreterContext context = this.getInterpreterContext();
        InterpreterContext.set((InterpreterContext)context);
        this.interpreter = new ShinyInterpreter(properties);
        InterpreterGroup interpreterGroup = new InterpreterGroup();
        interpreterGroup.addInterpreterToSession((Interpreter)new LazyOpenInterpreter((Interpreter)this.interpreter), "session_1");
        this.interpreter.setInterpreterGroup(interpreterGroup);
        this.interpreter.open();
    }

    @AfterEach
    public void tearDown() throws InterpreterException {
        if (this.interpreter != null) {
            this.interpreter.close();
        }
    }

    @Test
    void testShinyApp() throws IOException, InterpreterException, InterruptedException, UnirestException {
        InterpreterContext context = this.getInterpreterContext();
        context.getLocalProperties().put("type", "ui");
        InterpreterResult result = this.interpreter.interpret(IOUtils.toString((URL)this.getClass().getResource("/ui.R"), (Charset)StandardCharsets.UTF_8), context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        context = this.getInterpreterContext();
        context.getLocalProperties().put("type", "server");
        result = this.interpreter.interpret(IOUtils.toString((URL)this.getClass().getResource("/server.R"), (Charset)StandardCharsets.UTF_8), context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        InterpreterContext context2 = this.getInterpreterContext();
        context2.getLocalProperties().put("type", "run");
        Thread thread = new Thread(() -> {
            try {
                this.interpreter.interpret("", context2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        thread.start();
        Thread.sleep(5000L);
        List resultMessages = context2.out.toInterpreterResultMessage();
        Assertions.assertEquals((int)1, (int)resultMessages.size(), (String)resultMessages.toString());
        Assertions.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)resultMessages.get(0)).getType());
        String resultMessageData = ((InterpreterResultMessage)resultMessages.get(0)).getData();
        Assertions.assertTrue((boolean)resultMessageData.contains("<iframe"), (String)resultMessageData);
        Pattern urlPattern = Pattern.compile(".*src=\"(http\\S*)\".*", 32);
        Matcher matcher = urlPattern.matcher(resultMessageData);
        if (!matcher.matches()) {
            Assertions.fail((String)("Unable to extract url: " + resultMessageData));
        }
        String shinyURL = matcher.group(1);
        HttpResponse response = Unirest.get((String)shinyURL).asString();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertTrue((boolean)((String)response.getBody()).contains("Shiny Text"), (String)((String)response.getBody()));
        context = this.getInterpreterContext();
        context.getLocalProperties().put("type", "ui");
        context.getLocalProperties().put("app", "app2");
        result = this.interpreter.interpret(IOUtils.toString((URL)this.getClass().getResource("/ui.R"), (Charset)StandardCharsets.UTF_8), context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        context = this.getInterpreterContext();
        context.getLocalProperties().put("type", "server");
        context.getLocalProperties().put("app", "app2");
        result = this.interpreter.interpret(IOUtils.toString((URL)this.getClass().getResource("/server.R"), (Charset)StandardCharsets.UTF_8), context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        InterpreterContext context3 = this.getInterpreterContext();
        context3.getLocalProperties().put("type", "run");
        context3.getLocalProperties().put("app", "app2");
        thread = new Thread(() -> {
            try {
                this.interpreter.interpret("", context3);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        thread.start();
        Thread.sleep(5000L);
        resultMessages = context3.out.toInterpreterResultMessage();
        Assertions.assertEquals((int)1, (int)resultMessages.size());
        Assertions.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)resultMessages.get(0)).getType());
        resultMessageData = ((InterpreterResultMessage)resultMessages.get(0)).getData();
        Assertions.assertTrue((boolean)resultMessageData.contains("<iframe"), (String)resultMessageData);
        matcher = urlPattern.matcher(resultMessageData);
        if (!matcher.matches()) {
            Assertions.fail((String)("Unable to extract url: " + resultMessageData));
        }
        String shinyURL2 = matcher.group(1);
        response = Unirest.get((String)shinyURL2).asString();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertTrue((boolean)((String)response.getBody()).contains("Shiny Text"), (String)((String)response.getBody()));
        this.interpreter.cancel(this.getInterpreterContext());
        Thread.sleep(1000L);
        try {
            Unirest.get((String)shinyURL).asString();
            Assertions.fail((String)"Should fail to connect to shiny app");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("Connection refused"), (String)e.getMessage());
        }
        response = Unirest.get((String)shinyURL2).asString();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertTrue((boolean)((String)response.getBody()).contains("Shiny Text"), (String)((String)response.getBody()));
    }

    @Test
    void testInvalidShinyApp() throws IOException, InterpreterException, InterruptedException, UnirestException {
        InterpreterContext context = this.getInterpreterContext();
        context.getLocalProperties().put("type", "ui");
        InterpreterResult result = this.interpreter.interpret(IOUtils.toString((URL)this.getClass().getResource("/invalid_ui.R"), (Charset)StandardCharsets.UTF_8), context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        context = this.getInterpreterContext();
        context.getLocalProperties().put("type", "server");
        result = this.interpreter.interpret(IOUtils.toString((URL)this.getClass().getResource("/server.R"), (Charset)StandardCharsets.UTF_8), context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        InterpreterContext context2 = this.getInterpreterContext();
        context2.getLocalProperties().put("type", "run");
        Thread thread = new Thread(() -> {
            try {
                this.interpreter.interpret("", context2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        thread.start();
        Thread.sleep(5000L);
        List resultMessages = context2.out.toInterpreterResultMessage();
        Assertions.assertEquals((int)1, (int)resultMessages.size(), (String)resultMessages.toString());
        Assertions.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)resultMessages.get(0)).getType());
        String resultMessageData = ((InterpreterResultMessage)resultMessages.get(0)).getData();
        Assertions.assertTrue((boolean)resultMessageData.contains("<iframe"), (String)resultMessageData);
        Pattern urlPattern = Pattern.compile(".*src=\"(http\\S*)\".*", 32);
        Matcher matcher = urlPattern.matcher(resultMessageData);
        if (!matcher.matches()) {
            Assertions.fail((String)("Unable to extract url: " + resultMessageData));
        }
        String shinyURL = matcher.group(1);
        HttpResponse response = Unirest.get((String)shinyURL).asString();
        Assertions.assertEquals((int)500, (int)response.getStatus());
        resultMessages = context2.out.toInterpreterResultMessage();
        Assertions.assertTrue((boolean)((InterpreterResultMessage)resultMessages.get(1)).getData().contains("object 'Invalid_code' not found"), (String)((InterpreterResultMessage)resultMessages.get(1)).getData());
        this.interpreter.cancel(this.getInterpreterContext());
        Thread.sleep(1000L);
        try {
            Unirest.get((String)shinyURL).asString();
            Assertions.fail((String)"Should fail to connect to shiny app");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("Connection refused"), (String)e.getMessage());
        }
    }

    protected InterpreterContext getInterpreterContext() {
        InterpreterContext context = InterpreterContext.builder().setNoteId("note_1").setParagraphId("paragraph_1").setInterpreterOut(new InterpreterOutput()).setLocalProperties(new HashMap()).setInterpreterClassName(ShinyInterpreter.class.getName()).setIntpEventClient((RemoteInterpreterEventClient)Mockito.mock(RemoteInterpreterEventClient.class)).build();
        return context;
    }
}

