/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.sap;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.sap.universe.UniverseClient;
import org.apache.zeppelin.sap.universe.UniverseCompleter;
import org.apache.zeppelin.sap.universe.UniverseException;
import org.apache.zeppelin.sap.universe.UniverseQuery;
import org.apache.zeppelin.sap.universe.UniverseQueryPrompt;
import org.apache.zeppelin.sap.universe.UniverseUtil;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;

public class UniverseInterpreter
extends Interpreter {
    private UniverseClient client;
    private UniverseUtil universeUtil;
    private UniverseCompleter universeCompleter;
    private static final String EMPTY_COLUMN_VALUE = "";
    private static final char WHITESPACE = ' ';
    private static final char NEWLINE = '\n';
    private static final char TAB = '\t';
    private static final String TABLE_MAGIC_TAG = "%table ";
    private static final String EMPTY_DATA_MESSAGE = "%html\n<h4><center><b>No Data Available</b></center></h4>";
    private static final String CONCURRENT_EXECUTION_KEY = "universe.concurrent.use";
    private static final String CONCURRENT_EXECUTION_COUNT = "universe.concurrent.maxConnection";

    public UniverseInterpreter(Properties properties) {
        super(properties);
    }

    public void open() throws InterpreterException {
        String user = this.getProperty("universe.user");
        String password = this.getProperty("universe.password");
        String apiUrl = this.getProperty("universe.api.url");
        String authType = this.getProperty("universe.authType");
        int queryTimeout = Integer.parseInt(StringUtils.defaultIfEmpty((String)this.getProperty("universe.queryTimeout"), (String)"7200000"));
        this.client = new UniverseClient(user, password, apiUrl, authType, queryTimeout);
        this.universeUtil = new UniverseUtil();
    }

    public void close() throws InterpreterException {
        try {
            this.client.close();
        }
        catch (Exception e) {
            throw new InterpreterException(e.getCause());
        }
    }

    public InterpreterResult interpret(String originalSt, InterpreterContext context) throws InterpreterException {
        String st = Boolean.parseBoolean(this.getProperty("universe.interpolation", "false")) ? this.interpolate(originalSt, context.getResourcePool()) : originalSt;
        try {
            InterpreterResult interpreterResult = new InterpreterResult(InterpreterResult.Code.SUCCESS);
            String paragraphId = context.getParagraphId();
            String token = this.client.getToken(paragraphId);
            this.client.loadUniverses(token);
            UniverseQuery universeQuery = this.universeUtil.convertQuery(st, this.client, token);
            String queryId = this.client.createQuery(token, universeQuery);
            List<UniverseQueryPrompt> parameters = this.client.getParameters(token, queryId);
            for (UniverseQueryPrompt parameter : parameters) {
                Object value = context.getGui().getParams().get(parameter.getName());
                if (value != null) {
                    parameter.setValue(value.toString());
                }
                context.getGui().textbox(parameter.getName(), EMPTY_COLUMN_VALUE);
            }
            if (!parameters.isEmpty() && parameters.size() != context.getGui().getParams().size()) {
                this.client.deleteQuery(token, queryId);
                interpreterResult.add("Set parameters");
                InterpreterResult interpreterResult2 = interpreterResult;
                return interpreterResult2;
            }
            if (!parameters.isEmpty()) {
                this.client.setParametersValues(token, queryId, parameters);
            }
            List<List<String>> results = this.client.getResults(token, queryId);
            String table = this.formatResults(results);
            this.client.deleteQuery(token, queryId);
            interpreterResult.add(table);
            InterpreterResult interpreterResult3 = interpreterResult;
            return interpreterResult3;
        }
        catch (Exception e) {
            throw new InterpreterException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                this.client.closeSession(context.getParagraphId());
            }
            catch (Exception e) {
                logger.error("Error close SAP session", (Throwable)e);
            }
        }
    }

    public void cancel(InterpreterContext context) throws InterpreterException {
        try {
            this.client.closeSession(context.getParagraphId());
        }
        catch (Exception e) {
            logger.error("Error close SAP session", (Throwable)e);
        }
    }

    public Interpreter.FormType getFormType() throws InterpreterException {
        return Interpreter.FormType.NATIVE;
    }

    public int getProgress(InterpreterContext context) throws InterpreterException {
        return 0;
    }

    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) throws InterpreterException {
        ArrayList<InterpreterCompletion> candidates = new ArrayList<InterpreterCompletion>();
        try {
            this.universeCompleter = this.createOrUpdateUniverseCompleter(interpreterContext, buf, cursor);
            this.universeCompleter.complete(buf, cursor, candidates);
        }
        catch (UniverseException e) {
            logger.error("Error update completer", (Throwable)e);
        }
        return candidates;
    }

    public Scheduler getScheduler() {
        String schedulerName = UniverseInterpreter.class.getName() + ((Object)((Object)this)).hashCode();
        return this.isConcurrentExecution() ? SchedulerFactory.singleton().createOrGetParallelScheduler(schedulerName, this.getMaxConcurrentConnection()) : SchedulerFactory.singleton().createOrGetFIFOScheduler(schedulerName);
    }

    private boolean isConcurrentExecution() {
        return Boolean.valueOf(this.getProperty(CONCURRENT_EXECUTION_KEY, "true"));
    }

    private int getMaxConcurrentConnection() {
        return Integer.valueOf(StringUtils.defaultIfEmpty((String)this.getProperty(CONCURRENT_EXECUTION_COUNT), (String)"10"));
    }

    private String formatResults(List<List<String>> results) {
        StringBuilder msg = new StringBuilder();
        if (results != null) {
            if (results.isEmpty()) {
                return EMPTY_DATA_MESSAGE;
            }
            msg.append(TABLE_MAGIC_TAG);
            for (int i = 0; i < results.size(); ++i) {
                List<String> items = results.get(i);
                for (int j = 0; j < items.size(); ++j) {
                    if (j > 0) {
                        msg.append('\t');
                    }
                    msg.append(this.replaceReservedChars(items.get(j)));
                }
                msg.append('\n');
            }
        }
        return msg.toString();
    }

    private String replaceReservedChars(String str) {
        if (str == null) {
            return EMPTY_COLUMN_VALUE;
        }
        return str.replace('\t', ' ').replace('\n', ' ');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UniverseCompleter createOrUpdateUniverseCompleter(InterpreterContext interpreterContext, final String buf, final int cursor) throws UniverseException {
        final UniverseCompleter completer = this.universeCompleter == null ? new UniverseCompleter(3600) : this.universeCompleter;
        try {
            final String token = this.client.getToken(interpreterContext.getParagraphId());
            ExecutorService executorService = Executors.newFixedThreadPool(1);
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    completer.createOrUpdate(UniverseInterpreter.this.client, token, buf, cursor);
                }
            });
            executorService.shutdown();
            executorService.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.warn("Completion timeout", (Throwable)e);
        }
        finally {
            try {
                this.client.closeSession(interpreterContext.getParagraphId());
            }
            catch (Exception e) {
                logger.error("Error close SAP session", (Throwable)e);
            }
        }
        return completer;
    }
}

