/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.sap.universe;

import com.sun.org.apache.xpath.internal.NodeSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.apache.zeppelin.sap.universe.UniverseException;
import org.apache.zeppelin.sap.universe.UniverseInfo;
import org.apache.zeppelin.sap.universe.UniverseNodeInfo;
import org.apache.zeppelin.sap.universe.UniverseQuery;
import org.apache.zeppelin.sap.universe.UniverseQueryPrompt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UniverseClient {
    private static Logger logger = LoggerFactory.getLogger(UniverseClient.class);
    private static final String TOKEN_HEADER = "X-SAP-LogonToken";
    private static final String EL_FOLDER = "folder";
    private static final String EL_ITEM = "item";
    private static final String EL_NAME = "name";
    private static final String EL_PATH = "path";
    private static final String EL_ID = "id";
    private static final String EL_TECH_NAME = "technicalName";
    private static final String EL_ANSWER = "answer";
    private static final String EL_INFO = "info";
    private Map<String, String> tokens = new HashMap<String, String>();
    private static final long DAY = 86400000L;
    private CloseableHttpClient httpClient;
    private String user;
    private String password;
    private String apiUrl;
    private String authType;
    private Header[] commonHeaders = new Header[]{new BasicHeader("Accept", "application/xml"), new BasicHeader("Content-Type", "application/xml")};
    private final Map<String, UniverseInfo> universesMap = new ConcurrentHashMap<String, UniverseInfo>();
    private final Map<String, Map<String, UniverseNodeInfo>> universeInfosMap = new ConcurrentHashMap<String, Map<String, UniverseNodeInfo>>();
    private long universesUpdated = 0L;
    private Map<String, Long> universesInfoUpdatedMap = new HashMap<String, Long>();
    private final String loginRequestTemplate = "<attrs xmlns=\"http://www.sap.com/rws/bip\">\n<attr name=\"userName\" type=\"string\">%s</attr>\n<attr name=\"password\" type=\"string\">%s</attr>\n<attr name=\"auth\" type=\"string\" possibilities=\"secEnterprise,secLDAP,secWinAD,secSAPR3\">%s</attr>\n</attrs>";
    private final String createQueryRequestTemplate = "<query xmlns=\"http://www.sap.com/rws/sl/universe\" dataSourceType=\"%s\" dataSourceId=\"%s\">\n<querySpecification version=\"1.0\">\n   <queryOptions>\n            <queryOption name=\"duplicatedRows\" value=\"%s\"/>\n            <queryOption name=\"maxRowsRetrieved\" activated=\"%s\" value=\"%d\"/>\n  </queryOptions>  <queryData>\n%s\n     %s\n  </queryData>\n</querySpecification>\n</query>\n";
    private final String filterPartTemplate = "<filterPart>%s\n</filterPart>";
    private final String errorMessageTemplate = "%s\n\n%s";
    private final String parameterTemplate = "<parameter type=\"prompt\">\n%s\n%s\n%s\n%s\n</parameter>\n";
    private final String parameterAnswerTemplate = "<answer constrained=\"%s\" type=\"%s\">\n            <info cardinality=\"%s\" keepLastValues=\"%s\"></info>\n               <values>\n                      <value>%s</value>\n              </values>\n        </answer>\n";

    public UniverseClient(String user, String password, String apiUrl, String authType, int queryTimeout) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(queryTimeout).setSocketTimeout(queryTimeout).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(100);
        cm.setDefaultMaxPerRoute(100);
        cm.closeIdleConnections(10L, TimeUnit.MINUTES);
        this.httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)cm).setDefaultRequestConfig(requestConfig).build();
        this.user = user;
        this.password = password;
        this.authType = authType;
        if (StringUtils.isNotBlank((String)apiUrl)) {
            this.apiUrl = apiUrl.replaceAll("/$", "");
        }
    }

    public void close() throws UniverseException {
        for (String s : this.tokens.keySet()) {
            this.closeSession(s);
        }
        try {
            this.httpClient.close();
        }
        catch (Exception e) {
            throw new UniverseException(String.format("%s\n\n%s", "UniverseClient (close all): Error close HTTP client", ExceptionUtils.getStackTrace((Throwable)e)));
        }
    }

    public String createQuery(String token, UniverseQuery query) throws UniverseException {
        try {
            HttpPost httpPost = new HttpPost(String.format("%s%s", this.apiUrl, "/sl/v1/queries"));
            this.setHeaders((HttpRequestBase)httpPost, token);
            String where = StringUtils.isNotBlank((String)query.getWhere()) ? String.format("<filterPart>%s\n</filterPart>", query.getWhere()) : "";
            httpPost.setEntity((HttpEntity)new StringEntity(String.format("<query xmlns=\"http://www.sap.com/rws/sl/universe\" dataSourceType=\"%s\" dataSourceId=\"%s\">\n<querySpecification version=\"1.0\">\n   <queryOptions>\n            <queryOption name=\"duplicatedRows\" value=\"%s\"/>\n            <queryOption name=\"maxRowsRetrieved\" activated=\"%s\" value=\"%d\"/>\n  </queryOptions>  <queryData>\n%s\n     %s\n  </queryData>\n</querySpecification>\n</query>\n", query.getUniverseInfo().getType(), query.getUniverseInfo().getId(), query.getDuplicatedRows(), query.getMaxRowsRetrieved().isPresent(), query.getMaxRowsRetrieved().orElse(0), query.getSelect(), where), "UTF-8"));
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() == 200) {
                return this.getValue(EntityUtils.toString((HttpEntity)response.getEntity()), "//success/id");
            }
            throw new UniverseException(String.format("%s\n\n%s", "UniverseClient (create query): Request failed\n", EntityUtils.toString((HttpEntity)response.getEntity())));
        }
        catch (IOException e) {
            throw new UniverseException(String.format("%s\n\n%s", "UniverseClient (create query): Request failed", ExceptionUtils.getStackTrace((Throwable)e)));
        }
        catch (ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new UniverseException(String.format("%s\n\n%s", "UniverseClient (create query): Response processing failed", ExceptionUtils.getStackTrace((Throwable)e)));
        }
    }

    public void deleteQuery(String token, String queryId) throws UniverseException {
        try {
            if (StringUtils.isNotBlank((String)queryId)) {
                HttpDelete httpDelete = new HttpDelete(String.format("%s%s%s", this.apiUrl, "/sl/v1/queries/", queryId));
                this.setHeaders((HttpRequestBase)httpDelete, token);
                this.httpClient.execute((HttpUriRequest)httpDelete);
            }
        }
        catch (Exception e) {
            throw new UniverseException(String.format("%s\n\n%s", "UniverseClient (delete query): Request failed", ExceptionUtils.getStackTrace((Throwable)e)));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<List<String>> getResults(String token, String queryId) throws UniverseException {
        HttpGet httpGet = new HttpGet(String.format("%s%s%s%s", this.apiUrl, "/sl/v1/queries/", queryId, "/data.svc/Flows0"));
        this.setHeaders((HttpRequestBase)httpGet, token);
        CloseableHttpResponse response = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new UniverseException(String.format("%s\n\n%s", "UniverseClient (get results): Request failed\n", EntityUtils.toString((HttpEntity)response.getEntity())));
            }
        }
        catch (IOException e) {
            throw new UniverseException(String.format("%s\n\n%s", "UniverseClient (get results): Request failed", ExceptionUtils.getStackTrace((Throwable)e)));
        }
        try (InputStream xmlStream = response.getEntity().getContent();){
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(xmlStream);
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            XPathExpression expr = xpath.compile("//feed/entry/content/properties");
            NodeList resultsNodes = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            if (resultsNodes != null) {
                List<List<String>> list = this.parseResults(resultsNodes);
                return list;
            }
            throw new UniverseException(String.format("%s\n\n%s", "UniverseClient (get results): Response processing failed"));
        }
        catch (IOException e) {
            throw new UniverseException(String.format("%s\n\n%s", "UniverseClient (get results): Request failed", ExceptionUtils.getStackTrace((Throwable)e)));
        }
        catch (ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new UniverseException(String.format("%s\n\n%s", "UniverseClient (get results): Response processing failed", ExceptionUtils.getStackTrace((Throwable)e)));
        }
    }

    public String getToken(String paragraphId) throws UniverseException {
        try {
            if (this.tokens.containsKey(paragraphId)) {
                return this.tokens.get(paragraphId);
            }
            HttpPost httpPost = new HttpPost(String.format("%s%s", this.apiUrl, "/logon/long"));
            this.setHeaders((HttpRequestBase)httpPost);
            httpPost.setEntity((HttpEntity)new StringEntity(String.format("<attrs xmlns=\"http://www.sap.com/rws/bip\">\n<attr name=\"userName\" type=\"string\">%s</attr>\n<attr name=\"password\" type=\"string\">%s</attr>\n<attr name=\"auth\" type=\"string\" possibilities=\"secEnterprise,secLDAP,secWinAD,secSAPR3\">%s</attr>\n</attrs>", this.user, this.password, this.authType), "UTF-8"));
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
            String result = null;
            if (response.getStatusLine().getStatusCode() == 200) {
                result = this.getValue(EntityUtils.toString((HttpEntity)response.getEntity()), "//content/attrs/attr[@name=\"logonToken\"]");
                this.tokens.put(paragraphId, result);
            }
            return result;
        }
        catch (IOException e) {
            throw new UniverseException(String.format("%s\n\n%s", "UniverseClient (get token): Request failed", ExceptionUtils.getStackTrace((Throwable)e)));
        }
        catch (ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new UniverseException(String.format("%s\n\n%s", "UniverseClient (get token): Response processing failed", ExceptionUtils.getStackTrace((Throwable)e)));
        }
    }

    public boolean closeSession(String paragraphId) throws UniverseException {
        try {
            if (this.tokens.containsKey(paragraphId)) {
                HttpPost httpPost = new HttpPost(String.format("%s%s", this.apiUrl, "/logoff"));
                this.setHeaders((HttpRequestBase)httpPost, this.tokens.get(paragraphId));
                CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
                if (response.getStatusLine().getStatusCode() == 200) {
                    boolean bl = true;
                    return bl;
                }
            }
            boolean httpPost = false;
            return httpPost;
        }
        catch (Exception e) {
            throw new UniverseException(String.format("%s\n\n%s", "UniverseClient (close session): Request failed", ExceptionUtils.getStackTrace((Throwable)e)));
        }
        finally {
            this.tokens.remove(paragraphId);
        }
    }

    public UniverseInfo getUniverseInfo(String universeName) {
        return this.universesMap.get(universeName);
    }

    public Map<String, UniverseNodeInfo> getUniverseNodesInfo(String token, String universeName) throws UniverseException {
        UniverseInfo universeInfo = this.universesMap.get(universeName);
        if (universeInfo != null && StringUtils.isNotBlank((String)universeInfo.getId())) {
            Map<String, UniverseNodeInfo> universeNodeInfoMap;
            block20: {
                universeNodeInfoMap = this.universeInfosMap.get(universeName);
                if (universeNodeInfoMap != null && this.universesInfoUpdatedMap.containsKey(universeName) && !this.isExpired(this.universesInfoUpdatedMap.get(universeName))) {
                    return universeNodeInfoMap;
                }
                universeNodeInfoMap = new HashMap<String, UniverseNodeInfo>();
                try {
                    HttpGet httpGet = new HttpGet(String.format("%s%s%s", this.apiUrl, "/sl/v1/universes/", universeInfo.getId()));
                    this.setHeaders((HttpRequestBase)httpGet, token);
                    CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);
                    if (response.getStatusLine().getStatusCode() != 200) break block20;
                    try (InputStream xmlStream = response.getEntity().getContent();){
                        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder builder = factory.newDocumentBuilder();
                        Document doc = builder.parse(xmlStream);
                        XPathFactory xPathfactory = XPathFactory.newInstance();
                        XPath xpath = xPathfactory.newXPath();
                        XPathExpression expr = xpath.compile("//outline/folder");
                        XPathExpression exprRootItems = xpath.compile("//outline/item");
                        NodeList universeInfoNodes = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
                        NodeList universeRootInfoNodes = (NodeList)exprRootItems.evaluate(doc, XPathConstants.NODESET);
                        if (universeInfoNodes != null) {
                            this.parseUniverseInfo(universeInfoNodes, universeNodeInfoMap);
                        }
                        if (universeRootInfoNodes != null) {
                            this.parseUniverseInfo(universeRootInfoNodes, universeNodeInfoMap);
                        }
                    }
                    catch (Exception e) {
                        throw new UniverseException(String.format("%s\n\n%s", "UniverseClient (get universe nodes info): Response processing failed", ExceptionUtils.getStackTrace((Throwable)e)));
                    }
                }
                catch (IOException e) {
                    throw new UniverseException(String.format("%s\n\n%s", "UniverseClient (get universe nodes info): Request failed", ExceptionUtils.getStackTrace((Throwable)e)));
                }
            }
            this.universeInfosMap.put(universeName, universeNodeInfoMap);
            this.universesInfoUpdatedMap.put(universeName, System.currentTimeMillis());
            return universeNodeInfoMap;
        }
        return Collections.emptyMap();
    }

    public void loadUniverses(String token) throws UniverseException {
        if (this.universesMap.isEmpty() || this.universesUpdated == 0L || this.isExpired(this.universesUpdated)) {
            ConcurrentHashMap<String, UniverseInfo> universes = new ConcurrentHashMap<String, UniverseInfo>();
            this.loadUniverses(token, 0, universes);
            this.universesMap.clear();
            this.universesMap.putAll(universes);
            this.universesUpdated = System.currentTimeMillis();
        }
    }

    public void cleanUniverses() {
        this.universesMap.clear();
    }

    public void removeUniverseInfo(String universe) {
        this.universeInfosMap.remove(universe);
    }

    public Map<String, UniverseInfo> getUniversesMap() {
        return this.universesMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<UniverseQueryPrompt> getParameters(String token, String queryId) throws UniverseException {
        HttpGet httpGet = new HttpGet(String.format("%s%s%s%s", this.apiUrl, "/sl/v1/queries/", queryId, "/parameters"));
        this.setHeaders((HttpRequestBase)httpGet, token);
        CloseableHttpResponse response = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new UniverseException(String.format("%s\n\n%s", "UniverseClient (get parameters): Request failed\n", EntityUtils.toString((HttpEntity)response.getEntity())));
            }
        }
        catch (IOException e) {
            throw new UniverseException(String.format("%s\n\n%s", "UniverseClient (get parameters): Request failed", ExceptionUtils.getStackTrace((Throwable)e)));
        }
        try (InputStream xmlStream = response.getEntity().getContent();){
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(xmlStream);
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            XPathExpression expr = xpath.compile("//parameters/parameter");
            NodeList parametersNodes = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            if (parametersNodes != null) {
                List<UniverseQueryPrompt> list = this.parseParameters(parametersNodes);
                return list;
            }
            throw new UniverseException(String.format("%s\n\n%s", "UniverseClient (get parameters): Response processing failed"));
        }
        catch (IOException e) {
            throw new UniverseException(String.format("%s\n\n%s", "UniverseClient (get parameters): Response processing failed", ExceptionUtils.getStackTrace((Throwable)e)));
        }
        catch (ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new UniverseException(String.format("%s\n\n%s", "UniverseClient (get parameters): Response processing failed", ExceptionUtils.getStackTrace((Throwable)e)));
        }
    }

    public void setParametersValues(String token, String queryId, List<UniverseQueryPrompt> parameters) throws UniverseException {
        HttpPut httpPut = new HttpPut(String.format("%s%s%s%s", this.apiUrl, "/sl/v1/queries/", queryId, "/parameters"));
        this.setHeaders((HttpRequestBase)httpPut, token);
        CloseableHttpResponse response = null;
        try {
            StringBuilder request = new StringBuilder();
            request.append("<parameters>\n");
            for (UniverseQueryPrompt parameter : parameters) {
                String answer = String.format("<answer constrained=\"%s\" type=\"%s\">\n            <info cardinality=\"%s\" keepLastValues=\"%s\"></info>\n               <values>\n                      <value>%s</value>\n              </values>\n        </answer>\n", parameter.getConstrained(), parameter.getType(), parameter.getCardinality(), parameter.getKeepLastValues(), parameter.getValue());
                String id = parameter.getId() != null ? String.format("<id>%s</id>\n", parameter.getId()) : "";
                String technicalName = parameter.getTechnicalName() != null ? String.format("<technicalName>%s</technicalName>\n", parameter.getTechnicalName()) : "";
                String name = parameter.getTechnicalName() != null ? String.format("<name>%s</name>\n", parameter.getName()) : "";
                request.append(String.format("<parameter type=\"prompt\">\n%s\n%s\n%s\n%s\n</parameter>\n", id, technicalName, name, answer));
            }
            request.append("</parameters>\n");
            httpPut.setEntity((HttpEntity)new StringEntity(request.toString(), "UTF-8"));
            response = this.httpClient.execute((HttpUriRequest)httpPut);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new UniverseException(String.format("%s\n\n%s", "UniverseClient (set parameters): Request failed\n", EntityUtils.toString((HttpEntity)response.getEntity())));
            }
        }
        catch (IOException e) {
            throw new UniverseException(String.format("%s\n\n%s", "UniverseClient (set parameters): Request failed", ExceptionUtils.getStackTrace((Throwable)e)));
        }
    }

    private void loadUniverses(String token, int offset, Map<String, UniverseInfo> universesMap) throws UniverseException {
        int limit = 50;
        HttpGet httpGet = new HttpGet(String.format("%s%s?offset=%s&limit=%s", this.apiUrl, "/sl/v1/universes", offset, limit));
        this.setHeaders((HttpRequestBase)httpGet, token);
        CloseableHttpResponse response = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)httpGet);
        }
        catch (Exception e) {
            throw new UniverseException(String.format("%s\n\n%s", "UniverseClient (get universes): Request failed", ExceptionUtils.getStackTrace((Throwable)e)));
        }
        if (response != null && response.getStatusLine().getStatusCode() == 200) {
            try (InputStream xmlStream = response.getEntity().getContent();){
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(xmlStream);
                XPathFactory xPathfactory = XPathFactory.newInstance();
                XPath xpath = xPathfactory.newXPath();
                XPathExpression expr = xpath.compile("//universe");
                NodeList universesNodes = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
                if (universesNodes != null) {
                    int count = universesNodes.getLength();
                    for (int i = 0; i < count; ++i) {
                        Node universe = universesNodes.item(i);
                        if (!universe.hasChildNodes()) continue;
                        NodeList universeParameters = universe.getChildNodes();
                        int parapetersCount = universeParameters.getLength();
                        String id = null;
                        String name = null;
                        String type = null;
                        for (int j = 0; j < parapetersCount; ++j) {
                            Node parameterNode = universeParameters.item(j);
                            parameterNode.getNodeName();
                            if (parameterNode.getNodeType() != 1) continue;
                            if (parameterNode.getNodeName().equalsIgnoreCase(EL_ID)) {
                                id = parameterNode.getTextContent();
                                continue;
                            }
                            if (parameterNode.getNodeName().equalsIgnoreCase(EL_NAME)) {
                                name = parameterNode.getTextContent();
                                continue;
                            }
                            if (!parameterNode.getNodeName().equalsIgnoreCase("type")) continue;
                            type = parameterNode.getTextContent();
                        }
                        if (StringUtils.isNotBlank(type)) {
                            name = name.replaceAll(String.format("\\.%s$", type), "");
                        }
                        universesMap.put(name, new UniverseInfo(id, name, type));
                    }
                    if (count == limit) {
                        this.loadUniverses(token, offset += limit, universesMap);
                    }
                }
            }
            catch (IOException e) {
                throw new UniverseException(String.format("%s\n\n%s", "UniverseClient (get universes): Response processing failed", ExceptionUtils.getStackTrace((Throwable)e)));
            }
            catch (ParserConfigurationException | XPathExpressionException | SAXException e) {
                throw new UniverseException(String.format("%s\n\n%s", "UniverseClient (get universes): Response processing failed", ExceptionUtils.getStackTrace((Throwable)e)));
            }
        }
    }

    private boolean isExpired(Long lastUpdated) {
        return lastUpdated == null || System.currentTimeMillis() - lastUpdated > 86400000L;
    }

    private void setHeaders(HttpRequestBase request) {
        this.setHeaders(request, null);
    }

    private void setHeaders(HttpRequestBase request, String token) {
        request.setHeaders(this.commonHeaders);
        if (StringUtils.isNotBlank((String)token)) {
            request.addHeader(TOKEN_HEADER, token);
        }
    }

    private String getValue(String response, String xPathString) throws ParserConfigurationException, IOException, SAXException, XPathExpressionException {
        try (ByteArrayInputStream xmlStream = new ByteArrayInputStream(response.getBytes());){
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(xmlStream);
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            XPathExpression expr = xpath.compile(xPathString);
            Node tokenNode = (Node)expr.evaluate(doc, XPathConstants.NODE);
            if (tokenNode != null) {
                String string = tokenNode.getTextContent();
                return string;
            }
        }
        return null;
    }

    private List<UniverseQueryPrompt> parseParameters(NodeList parametersNodeList) {
        ArrayList<UniverseQueryPrompt> parameters = new ArrayList<UniverseQueryPrompt>();
        if (parametersNodeList != null) {
            int count = parametersNodeList.getLength();
            for (int i = 0; i < count; ++i) {
                Node parameterNode = parametersNodeList.item(i);
                Node type = parameterNode.getAttributes().getNamedItem("type");
                if (type == null || !type.getTextContent().equalsIgnoreCase("prompt") || !parameterNode.hasChildNodes()) continue;
                NodeList parameterInfoNodes = parameterNode.getChildNodes();
                int childNodesCount = parameterInfoNodes.getLength();
                String name = null;
                Integer id = null;
                String cardinality = null;
                String constrained = null;
                String valueType = null;
                String technicalName = null;
                String keepLastValues = null;
                block1: for (int j = 0; j < childNodesCount; ++j) {
                    Node childNode = parameterInfoNodes.item(j);
                    String childNodeName = childNode.getNodeName();
                    if (childNodeName.equalsIgnoreCase(EL_NAME)) {
                        name = childNode.getTextContent();
                        continue;
                    }
                    if (childNodeName.equalsIgnoreCase(EL_ID)) {
                        id = Integer.parseInt(childNode.getTextContent());
                        continue;
                    }
                    if (childNodeName.equalsIgnoreCase(EL_TECH_NAME)) {
                        technicalName = childNode.getTextContent();
                        continue;
                    }
                    if (!childNodeName.equalsIgnoreCase(EL_ANSWER)) continue;
                    NamedNodeMap answerAttributes = childNode.getAttributes();
                    if (answerAttributes.getNamedItem("constrained") != null) {
                        constrained = answerAttributes.getNamedItem("constrained").getTextContent();
                    }
                    if (answerAttributes.getNamedItem("type") != null) {
                        valueType = answerAttributes.getNamedItem("type").getTextContent();
                    }
                    NodeList answerNodes = childNode.getChildNodes();
                    int answerCount = answerNodes.getLength();
                    for (int k = 0; k < answerCount; ++k) {
                        Node answerChildNode = answerNodes.item(k);
                        String answerChildNodeName = answerChildNode.getNodeName();
                        if (!answerChildNodeName.equalsIgnoreCase(EL_INFO)) continue;
                        NamedNodeMap infoAttributes = answerChildNode.getAttributes();
                        if (infoAttributes.getNamedItem("cardinality") != null) {
                            cardinality = infoAttributes.getNamedItem("cardinality").getTextContent();
                        }
                        if (infoAttributes.getNamedItem("keepLastValues") == null) continue block1;
                        keepLastValues = infoAttributes.getNamedItem("keepLastValues").getTextContent();
                        continue block1;
                    }
                }
                if (name == null || id == null || cardinality == null) continue;
                parameters.add(new UniverseQueryPrompt(id, name, cardinality, constrained, valueType, technicalName, keepLastValues));
                break;
            }
        }
        return parameters;
    }

    private List<List<String>> parseResults(NodeList resultsNodeList) {
        ArrayList<List<String>> results = new ArrayList<List<String>>();
        if (resultsNodeList != null) {
            int count = resultsNodeList.getLength();
            for (int i = 0; i < count; ++i) {
                NodeList properties;
                Node node = resultsNodeList.item(i);
                if (node.getNodeType() != 1 || !node.hasChildNodes() || (properties = node.getChildNodes()) == null) continue;
                int countProperties = properties.getLength();
                ArrayList<String> headers = new ArrayList<String>();
                ArrayList<String> row = new ArrayList<String>();
                for (int j = 1; j < countProperties; ++j) {
                    Node propertyNode = properties.item(j);
                    if (i == 0) {
                        headers.add(propertyNode.getNodeName().replaceAll("^\\w*:", ""));
                    }
                    row.add(propertyNode.getTextContent());
                }
                if (i == 0) {
                    results.add(headers);
                }
                results.add(row);
            }
        }
        return results;
    }

    private void addAttributesToDimension(Node universeNode, Map<String, UniverseNodeInfo> nodes) {
        NodeList attributeNodes = universeNode.getChildNodes();
        int attributeNodesCount = attributeNodes.getLength();
        for (int i = 0; i < attributeNodesCount; ++i) {
            Node attributeNode = attributeNodes.item(i);
            if (!attributeNode.getNodeName().equalsIgnoreCase(EL_ITEM)) continue;
            NodeList childNodes = attributeNode.getChildNodes();
            int childNodesCount = childNodes.getLength();
            String nodeId = null;
            String nodeName = null;
            String nodePath = null;
            block11: for (int j = 0; j < childNodesCount; ++j) {
                Node childNode = childNodes.item(j);
                if (childNode.getNodeType() != 1) continue;
                switch (childNode.getNodeName().toLowerCase()) {
                    case "name": {
                        nodeName = childNode.getTextContent();
                        continue block11;
                    }
                    case "id": {
                        nodeId = childNode.getTextContent();
                        continue block11;
                    }
                    case "path": {
                        nodePath = childNode.getTextContent();
                    }
                }
            }
            StringBuilder key = new StringBuilder();
            if (!StringUtils.isNotBlank(nodeName)) continue;
            String nodeType = null;
            String[] parts = nodePath.split("\\\\");
            ArrayList<String> path = new ArrayList<String>();
            for (String part : parts) {
                String[] p = part.split("\\|");
                if (p.length != 2) continue;
                if (p[1].equalsIgnoreCase(EL_FOLDER) || p[1].equalsIgnoreCase("dimension")) {
                    path.add(p[0]);
                    continue;
                }
                nodeName = p[0];
                nodeType = p[1];
            }
            String folder = StringUtils.join(path, (String)"\\");
            key.append("[");
            key.append(StringUtils.join(path, (String)"].["));
            key.append(String.format("].[%s]", nodeName));
            nodes.put(key.toString(), new UniverseNodeInfo(nodeId, nodeName, nodeType, folder, nodePath));
        }
    }

    private void parseUniverseInfo(NodeList universeInfoNodes, Map<String, UniverseNodeInfo> nodes) {
        if (universeInfoNodes != null) {
            int count = universeInfoNodes.getLength();
            for (int i = 0; i < count; ++i) {
                Node node = universeInfoNodes.item(i);
                if (node.getNodeType() != 1 || !node.hasChildNodes()) continue;
                String name = node.getNodeName();
                NodeList childNodes = node.getChildNodes();
                int childNodesCount = childNodes.getLength();
                if (name.equalsIgnoreCase(EL_FOLDER)) {
                    NodeSet list = new NodeSet();
                    for (int j = 0; j < childNodesCount; ++j) {
                        String childNodeName;
                        Node childNode = childNodes.item(j);
                        if (childNode.getNodeType() != 1 || !childNode.hasChildNodes() || !(childNodeName = childNode.getNodeName()).equalsIgnoreCase(EL_FOLDER) && !childNodeName.equalsIgnoreCase(EL_ITEM)) continue;
                        list.addNode(childNode);
                    }
                    if (list.getLength() <= 0) continue;
                    this.parseUniverseInfo(list, nodes);
                    continue;
                }
                if (!name.equalsIgnoreCase(EL_ITEM)) continue;
                String nodeId = null;
                String nodeName = null;
                String nodePath = null;
                for (int j = 0; j < childNodesCount; ++j) {
                    Node childNode = childNodes.item(j);
                    if (childNode.getNodeType() != 1) continue;
                    String childNodeName = childNode.getNodeName();
                    if (childNodeName.equalsIgnoreCase(EL_NAME)) {
                        nodeName = childNode.getTextContent();
                        continue;
                    }
                    if (childNodeName.equalsIgnoreCase(EL_ID)) {
                        nodeId = childNode.getTextContent();
                        continue;
                    }
                    if (!childNodeName.equalsIgnoreCase(EL_PATH)) continue;
                    nodePath = childNode.getTextContent();
                }
                String folder = null;
                StringBuilder key = new StringBuilder();
                if (!StringUtils.isNotBlank(nodeName)) continue;
                String nodeType = null;
                if (StringUtils.isNotBlank(nodePath)) {
                    String[] parts = nodePath.split("\\\\");
                    ArrayList<String> path = new ArrayList<String>();
                    for (String part : parts) {
                        String[] p = part.split("\\|");
                        if (p.length != 2) continue;
                        if (p[1].equalsIgnoreCase(EL_FOLDER)) {
                            path.add(p[0]);
                            continue;
                        }
                        nodeName = p[0];
                        nodeType = p[1];
                        if (!p[1].equalsIgnoreCase("dimension")) continue;
                        this.addAttributesToDimension(node, nodes);
                    }
                    folder = StringUtils.join(path, (String)"\\");
                    if (path.isEmpty()) {
                        key.append(String.format("[%s]", nodeName));
                    } else {
                        key.append("[");
                        key.append(StringUtils.join(path, (String)"].["));
                        key.append(String.format("].[%s]", nodeName));
                    }
                }
                nodes.put(key.toString(), new UniverseNodeInfo(nodeId, nodeName, nodeType, folder, nodePath));
            }
        }
    }
}

