/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.spark;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.spark.SparkVersion;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Utils {
    public static Logger logger = LoggerFactory.getLogger(Utils.class);
    public static String DEPRRECATED_MESSAGE = "%html <font color=\"red\">Spark lower than 2.2 is deprecated, if you don't want to see this message, please set zeppelin.spark.deprecateMsg.show to false.</font>";

    Utils() {
    }

    static Object invokeMethod(Object o, String name) {
        return Utils.invokeMethod(o, name, new Class[0], new Object[0]);
    }

    static Object invokeMethod(Object o, String name, Class<?>[] argTypes, Object[] params) {
        try {
            return o.getClass().getMethod(name, argTypes).invoke(o, params);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    static Object invokeStaticMethod(Class<?> c, String name, Class<?>[] argTypes, Object[] params) {
        try {
            return c.getMethod(name, argTypes).invoke(null, params);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    static Object invokeStaticMethod(Class<?> c, String name) {
        return Utils.invokeStaticMethod(c, name, new Class[0], new Object[0]);
    }

    static Class<?> findClass(String name) {
        return Utils.findClass(name, false);
    }

    static Class<?> findClass(String name, boolean silence) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            if (!silence) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    static Object instantiateClass(String name, Class<?>[] argTypes, Object[] params) {
        try {
            Constructor<?> constructor = Utils.class.getClassLoader().loadClass(name).getConstructor(argTypes);
            return constructor.newInstance(params);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    static boolean isScala2_10() {
        try {
            Class.forName("org.apache.spark.repl.SparkIMain");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (IncompatibleClassChangeError e) {
            return false;
        }
    }

    public static String buildJobGroupId(InterpreterContext context) {
        String uName = "anonymous";
        if (context.getAuthenticationInfo() != null) {
            uName = Utils.getUserName(context.getAuthenticationInfo());
        }
        return "zeppelin|" + uName + "|" + context.getNoteId() + "|" + context.getParagraphId();
    }

    public static String buildJobDesc(InterpreterContext context) {
        return "Started by: " + Utils.getUserName(context.getAuthenticationInfo());
    }

    public static String getUserName(AuthenticationInfo info) {
        String uName = "";
        if (info != null) {
            uName = info.getUser();
        }
        if (uName == null || uName.isEmpty()) {
            uName = "anonymous";
        }
        return uName;
    }

    public static void printDeprecateMessage(SparkVersion sparkVersion, InterpreterContext context, Properties properties) throws InterpreterException {
        context.out.clear();
        if (sparkVersion.olderThan(SparkVersion.SPARK_2_2_0) && Boolean.parseBoolean(properties.getProperty("zeppelin.spark.deprecatedMsg.show", "true"))) {
            try {
                context.out.write(DEPRRECATED_MESSAGE);
                context.out.write("%text ");
            }
            catch (IOException e) {
                throw new InterpreterException((Throwable)e);
            }
        }
    }
}

