/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.spark;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkVersion {
    private static final Logger logger = LoggerFactory.getLogger(SparkVersion.class);
    public static final SparkVersion SPARK_2_0_0 = SparkVersion.fromVersionString("2.0.0");
    public static final SparkVersion SPARK_2_2_0 = SparkVersion.fromVersionString("2.2.0");
    public static final SparkVersion SPARK_2_3_0 = SparkVersion.fromVersionString("2.3.0");
    public static final SparkVersion SPARK_2_3_1 = SparkVersion.fromVersionString("2.3.1");
    public static final SparkVersion SPARK_2_4_0 = SparkVersion.fromVersionString("2.4.0");
    public static final SparkVersion SPARK_3_1_0 = SparkVersion.fromVersionString("3.1.0");
    public static final SparkVersion SPARK_3_3_0 = SparkVersion.fromVersionString("3.3.0");
    public static final SparkVersion MIN_SUPPORTED_VERSION = SPARK_2_0_0;
    public static final SparkVersion UNSUPPORTED_FUTURE_VERSION = SPARK_3_3_0;
    private int version;
    private int majorVersion;
    private int minorVersion;
    private int patchVersion;
    private String versionString;

    SparkVersion(String versionString) {
        this.versionString = versionString;
        try {
            int pos = versionString.indexOf(45);
            String numberPart = versionString;
            if (pos > 0) {
                numberPart = versionString.substring(0, pos);
            }
            String[] versions = numberPart.split("\\.");
            this.majorVersion = Integer.parseInt(versions[0]);
            this.minorVersion = Integer.parseInt(versions[1]);
            this.patchVersion = Integer.parseInt(versions[2]);
            this.version = Integer.parseInt(String.format("%d%02d%02d", this.majorVersion, this.minorVersion, this.patchVersion));
        }
        catch (Exception e) {
            logger.error("Can not recognize Spark version " + versionString + ". Assume it's a future release", (Throwable)e);
            this.version = 99999;
        }
    }

    public int toNumber() {
        return this.version;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public String toString() {
        return this.versionString;
    }

    public boolean isUnsupportedVersion() {
        return this.olderThan(MIN_SUPPORTED_VERSION) || this.newerThanEquals(UNSUPPORTED_FUTURE_VERSION);
    }

    public static SparkVersion fromVersionString(String versionString) {
        return new SparkVersion(versionString);
    }

    public boolean isSpark1() {
        return this.olderThan(SPARK_2_0_0);
    }

    public boolean isSecretSocketSupported() {
        return this.newerThanEquals(SPARK_2_4_0) || this.newerThanEqualsPatchVersion(SPARK_2_3_1) || this.newerThanEqualsPatchVersion(SparkVersion.fromVersionString("2.2.2")) || this.newerThanEqualsPatchVersion(SparkVersion.fromVersionString("2.1.3"));
    }

    public boolean equals(Object versionToCompare) {
        return this.version == ((SparkVersion)versionToCompare).version;
    }

    public boolean newerThan(SparkVersion versionToCompare) {
        return this.version > versionToCompare.version;
    }

    public boolean newerThanEquals(SparkVersion versionToCompare) {
        return this.version >= versionToCompare.version;
    }

    public boolean newerThanEqualsPatchVersion(SparkVersion versionToCompare) {
        return this.majorVersion == versionToCompare.majorVersion && this.minorVersion == versionToCompare.minorVersion && this.patchVersion >= versionToCompare.patchVersion;
    }

    public boolean olderThan(SparkVersion versionToCompare) {
        return this.version < versionToCompare.version;
    }

    public boolean olderThanEquals(SparkVersion versionToCompare) {
        return this.version <= versionToCompare.version;
    }
}

