/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.client.websocket;

import java.util.HashMap;
import java.util.Map;
import org.apache.zeppelin.client.websocket.AbstractMessageHandler;
import org.apache.zeppelin.client.websocket.StatementMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeMessageHandler
extends AbstractMessageHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeMessageHandler.class);
    private Map<String, StatementMessageHandler> messageHandlers = new HashMap<String, StatementMessageHandler>();

    public void addStatementMessageHandler(String statementId, StatementMessageHandler messageHandler) {
        this.messageHandlers.put(statementId, messageHandler);
    }

    @Override
    public void onStatementAppendOutput(String statementId, int index, String output) {
        StatementMessageHandler messageHandler = this.messageHandlers.get(statementId);
        if (messageHandler == null) {
            LOGGER.warn("No messagehandler for statement: " + statementId);
            return;
        }
        messageHandler.onStatementAppendOutput(statementId, index, output);
    }

    @Override
    public void onStatementUpdateOutput(String statementId, int index, String type, String output) {
        StatementMessageHandler messageHandler = this.messageHandlers.get(statementId);
        if (messageHandler == null) {
            LOGGER.warn("No messagehandler for statement: " + statementId);
            return;
        }
        messageHandler.onStatementUpdateOutput(statementId, index, type, output);
    }
}

