/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.client;

import java.util.ArrayList;
import java.util.List;
import kong.unirest.json.JSONArray;
import kong.unirest.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.client.Result;
import org.apache.zeppelin.client.Status;

public class ParagraphResult {
    private String paragraphId;
    private Status status;
    private int progress;
    private List<Result> results;
    private List<String> jobUrls;

    public ParagraphResult(JSONObject paragraphJson) {
        JSONObject jobUrlJson;
        JSONObject runtimeInfosJson;
        this.paragraphId = paragraphJson.getString("id");
        this.status = Status.valueOf(paragraphJson.getString("status"));
        if (paragraphJson.has("progress")) {
            this.progress = paragraphJson.getInt("progress");
        }
        this.results = new ArrayList<Result>();
        if (paragraphJson.has("results")) {
            JSONObject resultJson = paragraphJson.getJSONObject("results");
            JSONArray msgArray = resultJson.getJSONArray("msg");
            for (int i = 0; i < msgArray.length(); ++i) {
                JSONObject resultObject = msgArray.getJSONObject(i);
                this.results.add(new Result(resultObject));
            }
        }
        this.jobUrls = new ArrayList<String>();
        if (paragraphJson.has("runtimeInfos") && (runtimeInfosJson = paragraphJson.getJSONObject("runtimeInfos")).has("jobUrl") && (jobUrlJson = runtimeInfosJson.getJSONObject("jobUrl")).has("values")) {
            JSONArray valuesArray = jobUrlJson.getJSONArray("values");
            for (int i = 0; i < valuesArray.length(); ++i) {
                JSONObject object = valuesArray.getJSONObject(i);
                if (!object.has("jobUrl")) continue;
                this.jobUrls.add(object.getString("jobUrl"));
            }
        }
    }

    public String getParagraphId() {
        return this.paragraphId;
    }

    public Status getStatus() {
        return this.status;
    }

    public int getProgress() {
        return this.progress;
    }

    public List<Result> getResults() {
        return this.results;
    }

    public List<String> getJobUrls() {
        return this.jobUrls;
    }

    public String getResultInText() {
        StringBuilder builder = new StringBuilder();
        if (this.results != null) {
            for (Result result : this.results) {
                builder.append(result.getData() + "\n");
            }
        }
        return builder.toString();
    }

    public String toString() {
        return "ParagraphResult{paragraphId='" + this.paragraphId + '\'' + ", status=" + (Object)((Object)this.status) + ", results=" + StringUtils.join(this.results, (String)", ") + ", progress=" + this.progress + '}';
    }
}

