/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.client.websocket;

import com.google.gson.Gson;
import org.apache.zeppelin.client.websocket.MessageHandler;
import org.apache.zeppelin.common.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageHandler
implements MessageHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMessageHandler.class);
    private static final Gson GSON = new Gson();

    @Override
    public void onMessage(String msg) {
        try {
            Message messageReceived = (Message)GSON.fromJson(msg, Message.class);
            if (messageReceived.op != Message.OP.PING) {
                LOGGER.debug("RECEIVE: " + messageReceived.op + ", RECEIVE PRINCIPAL: " + messageReceived.principal + ", RECEIVE TICKET: " + messageReceived.ticket + ", RECEIVE ROLES: " + messageReceived.roles + ", RECEIVE DATA: " + messageReceived.data);
            }
            switch (messageReceived.op) {
                case PARAGRAPH_UPDATE_OUTPUT: {
                    String noteId = (String)messageReceived.data.get("noteId");
                    String paragraphId = (String)messageReceived.data.get("paragraphId");
                    int index = (int)Double.parseDouble(messageReceived.data.get("index").toString());
                    String type = (String)messageReceived.data.get("type");
                    String output = (String)messageReceived.data.get("data");
                    this.onStatementUpdateOutput(paragraphId, index, type, output);
                    break;
                }
                case PARAGRAPH_APPEND_OUTPUT: {
                    String noteId = (String)messageReceived.data.get("noteId");
                    String paragraphId = (String)messageReceived.data.get("paragraphId");
                    int index = (int)Double.parseDouble(messageReceived.data.get("index").toString());
                    String output = (String)messageReceived.data.get("data");
                    this.onStatementAppendOutput(paragraphId, index, output);
                    break;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Can't handle message: " + msg, (Throwable)e);
        }
    }

    public abstract void onStatementAppendOutput(String var1, int var2, String var3);

    public abstract void onStatementUpdateOutput(String var1, int var2, String var3, String var4);
}

