/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.dep;

import java.io.File;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.apache.zeppelin.dep.RepositorySystemFactory;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.RemoteRepository;

public class Booter {
    public static RepositorySystem newRepositorySystem() {
        return RepositorySystemFactory.newRepositorySystem();
    }

    public static RepositorySystemSession newRepositorySystemSession(RepositorySystem system, String localRepoPath) {
        MavenRepositorySystemSession session = new MavenRepositorySystemSession();
        String home = System.getenv("ZEPPELIN_HOME");
        if (home == null) {
            home = System.getProperty("zeppelin.home");
        }
        if (home == null) {
            home = "..";
        }
        String path = home + "/" + localRepoPath;
        LocalRepository localRepo = new LocalRepository(new File(path).getAbsolutePath());
        session.setLocalRepositoryManager(system.newLocalRepositoryManager(localRepo));
        return session;
    }

    public static RemoteRepository newCentralRepository() {
        return new RemoteRepository("central", "default", "http://repo1.maven.org/maven2/");
    }

    public static RemoteRepository newLocalRepository() {
        return new RemoteRepository("local", "default", "file://" + System.getProperty("user.home") + "/.m2/repository");
    }
}

