/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.dep;

import java.io.File;
import java.net.MalformedURLException;
import java.util.LinkedList;
import java.util.List;
import org.apache.zeppelin.dep.Booter;
import org.apache.zeppelin.dep.Dependency;
import org.apache.zeppelin.dep.Repository;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.resolution.DependencyRequest;
import org.sonatype.aether.resolution.DependencyResolutionException;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.sonatype.aether.util.filter.DependencyFilterUtils;
import org.sonatype.aether.util.filter.PatternExclusionsDependencyFilter;

public class DependencyContext {
    List<Dependency> dependencies = new LinkedList<Dependency>();
    List<Repository> repositories = new LinkedList<Repository>();
    List<File> files = new LinkedList<File>();
    List<File> filesDist = new LinkedList<File>();
    private RepositorySystem system = Booter.newRepositorySystem();
    private RepositorySystemSession session;
    private RemoteRepository mavenCentral = Booter.newCentralRepository();
    private RemoteRepository mavenLocal = Booter.newLocalRepository();

    public DependencyContext(String localRepoPath) {
        this.session = Booter.newRepositorySystemSession(this.system, localRepoPath);
    }

    public Dependency load(String lib) {
        Dependency dep = new Dependency(lib);
        if (this.dependencies.contains(dep)) {
            this.dependencies.remove(dep);
        }
        this.dependencies.add(dep);
        return dep;
    }

    public Repository addRepo(String name) {
        Repository rep = new Repository(name);
        this.repositories.add(rep);
        return rep;
    }

    public void reset() {
        this.dependencies = new LinkedList<Dependency>();
        this.repositories = new LinkedList<Repository>();
        this.files = new LinkedList<File>();
        this.filesDist = new LinkedList<File>();
    }

    public List<File> fetch() throws MalformedURLException, DependencyResolutionException, ArtifactResolutionException {
        for (Dependency dep : this.dependencies) {
            if (!dep.isLocalFsArtifact()) {
                List<ArtifactResult> artifacts = this.fetchArtifactWithDep(dep);
                for (ArtifactResult artifact : artifacts) {
                    if (dep.isDist()) {
                        this.filesDist.add(artifact.getArtifact().getFile());
                    }
                    this.files.add(artifact.getArtifact().getFile());
                }
                continue;
            }
            if (dep.isDist()) {
                this.filesDist.add(new File(dep.getGroupArtifactVersion()));
            }
            this.files.add(new File(dep.getGroupArtifactVersion()));
        }
        return this.files;
    }

    private List<ArtifactResult> fetchArtifactWithDep(Dependency dep) throws DependencyResolutionException, ArtifactResolutionException {
        DefaultArtifact artifact = new DefaultArtifact(dep.getGroupArtifactVersion());
        DependencyFilter classpathFilter = DependencyFilterUtils.classpathFilter("compile");
        PatternExclusionsDependencyFilter exclusionFilter = new PatternExclusionsDependencyFilter(dep.getExclusions());
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new org.sonatype.aether.graph.Dependency(artifact, "compile"));
        collectRequest.addRepository(this.mavenCentral);
        collectRequest.addRepository(this.mavenLocal);
        for (Repository repo : this.repositories) {
            RemoteRepository rr = new RemoteRepository(repo.getId(), "default", repo.getUrl());
            rr.setPolicy(repo.isSnapshot(), null);
            collectRequest.addRepository(rr);
        }
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, DependencyFilterUtils.andFilter(exclusionFilter, classpathFilter));
        return this.system.resolveDependencies(this.session, dependencyRequest).getArtifactResults();
    }

    public List<File> getFiles() {
        return this.files;
    }

    public List<File> getFilesDist() {
        return this.filesDist;
    }
}

