/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.display;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class Input
implements Serializable {
    String name;
    String displayName;
    String type;
    String argument;
    Object defaultValue;
    ParamOption[] options;
    boolean hidden;
    private static final Pattern VAR_PTN = Pattern.compile("([_])?[$][{]([^=}]*([=][^}]*)?)[}]");
    private static final String DEFAULT_DELIMITER = ",";

    public Input(String name, Object defaultValue, String type) {
        this.name = name;
        this.displayName = name;
        this.defaultValue = defaultValue;
        this.type = type;
    }

    public Input(String name, Object defaultValue, String type, ParamOption[] options) {
        this.name = name;
        this.displayName = name;
        this.defaultValue = defaultValue;
        this.type = type;
        this.options = options;
    }

    public Input(String name, String displayName, String type, String argument, Object defaultValue, ParamOption[] options, boolean hidden) {
        this.name = name;
        this.displayName = displayName;
        this.argument = argument;
        this.type = type;
        this.defaultValue = defaultValue;
        this.options = options;
        this.hidden = hidden;
    }

    public boolean equals(Object o) {
        return this.name.equals(((Input)o).getName());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public ParamOption[] getOptions() {
        return this.options;
    }

    public void setOptions(ParamOption[] options) {
        this.options = options;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    private static String[] getNameAndDisplayName(String str) {
        Pattern p = Pattern.compile("([^(]*)\\s*[(]([^)]*)[)]");
        Matcher m = p.matcher(str.trim());
        if (m == null || !m.find()) {
            return null;
        }
        String[] ret = new String[]{m.group(1), m.group(2)};
        return ret;
    }

    private static String[] getType(String str) {
        Pattern p = Pattern.compile("([^:()]*)\\s*([(][^()]*[)])?\\s*:(.*)");
        Matcher m = p.matcher(str.trim());
        if (m == null || !m.find()) {
            return null;
        }
        String[] ret = new String[3];
        ret[0] = m.group(1).trim();
        if (m.group(2) != null) {
            ret[1] = m.group(2).trim().replaceAll("[()]", "");
        }
        ret[2] = m.group(3).trim();
        return ret;
    }

    private static Input getInputForm(Matcher match) {
        String varName;
        String varNamePart;
        String valuePart;
        String namePart;
        String m;
        int p;
        String hiddenPart = match.group(1);
        boolean hidden = false;
        if ("_".equals(hiddenPart)) {
            hidden = true;
        }
        if ((p = (m = match.group(2)).indexOf(61)) > 0) {
            namePart = m.substring(0, p);
            valuePart = m.substring(p + 1);
        } else {
            namePart = m;
            valuePart = null;
        }
        String displayName = null;
        String type = null;
        String arg = null;
        String[] defaultValue = "";
        ParamOption[] paramOptions = null;
        String[] typeArray = Input.getType(namePart);
        if (typeArray != null) {
            type = typeArray[0];
            arg = typeArray[1];
            varNamePart = typeArray[2];
        } else {
            varNamePart = namePart;
        }
        String[] varNameArray = Input.getNameAndDisplayName(varNamePart);
        if (varNameArray != null) {
            varName = varNameArray[0];
            displayName = varNameArray[1];
        } else {
            varName = varNamePart.trim();
        }
        if (valuePart != null) {
            int optionP = valuePart.indexOf(DEFAULT_DELIMITER);
            if (optionP >= 0) {
                defaultValue = valuePart.substring(0, optionP);
                if (type != null && type.equals("checkbox")) {
                    defaultValue = Input.splitPipe((String)defaultValue);
                }
                String optionPart = valuePart.substring(optionP + 1);
                String[] options = Input.splitPipe(optionPart);
                paramOptions = new ParamOption[options.length];
                for (int i = 0; i < options.length; ++i) {
                    String[] optNameArray = Input.getNameAndDisplayName(options[i]);
                    paramOptions[i] = optNameArray != null ? new ParamOption(optNameArray[0], optNameArray[1]) : new ParamOption(options[i], null);
                }
            } else {
                defaultValue = valuePart;
            }
        }
        return new Input(varName, displayName, type, arg, defaultValue, paramOptions, hidden);
    }

    public static Map<String, Input> extractSimpleQueryParam(String script) {
        HashMap<String, Input> params = new HashMap<String, Input>();
        if (script == null) {
            return params;
        }
        String replaced = script;
        Matcher match = VAR_PTN.matcher(replaced);
        while (match.find()) {
            Input param = Input.getInputForm(match);
            params.put(param.name, param);
        }
        params.remove("pql");
        return params;
    }

    public static String getSimpleQuery(Map<String, Object> params, String script) {
        String replaced = script;
        Matcher match = VAR_PTN.matcher(replaced);
        while (match.find()) {
            String expanded;
            Input input = Input.getInputForm(match);
            Object value = params.containsKey(input.name) ? params.get(input.name) : input.defaultValue;
            if (value instanceof Object[] || value instanceof Collection) {
                String delimiter = input.argument;
                if (delimiter == null) {
                    delimiter = DEFAULT_DELIMITER;
                }
                List<Object> checked = value instanceof Collection ? (List<Object>)value : Arrays.asList((Object[])value);
                LinkedList validChecked = new LinkedList();
                block1: for (Object e : checked) {
                    for (ParamOption option : input.getOptions()) {
                        if (!option.getValue().equals(e)) continue;
                        validChecked.add(e);
                        continue block1;
                    }
                }
                params.put(input.name, validChecked);
                expanded = StringUtils.join(validChecked, delimiter);
            } else {
                expanded = value.toString();
            }
            replaced = match.replaceFirst(expanded);
            match = VAR_PTN.matcher(replaced);
        }
        return replaced;
    }

    public static String[] split(String str) {
        return str.split(";(?=([^\"']*\"[^\"']*\")*[^\"']*$)");
    }

    public static String[] splitPipe(String str) {
        return Input.split(str, '|');
    }

    public static String[] split(String str, char split) {
        return Input.split(str, new String[]{String.valueOf(split)}, false);
    }

    public static String[] split(String str, String[] splitters, boolean includeSplitter) {
        String escapeSeq = "\"',;${}";
        char escapeChar = '\\';
        String[] blockStart = new String[]{"\"", "'", "${", "N_(", "N_<"};
        String[] blockEnd = new String[]{"\"", "'", "}", "N_)", "N_>"};
        return Input.split(str, escapeSeq, escapeChar, blockStart, blockEnd, splitters, includeSplitter);
    }

    public static String[] split(String str, String escapeSeq, char escapeChar, String[] blockStart, String[] blockEnd, String[] splitters, boolean includeSplitter) {
        ArrayList<String> splits = new ArrayList<String>();
        String curString = "";
        boolean escape = false;
        int lastEscapeOffset = -1;
        int blockStartPos = -1;
        LinkedList<Integer> blockStack = new LinkedList<Integer>();
        block0: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == escapeChar && !escape) {
                escape = true;
                continue;
            }
            if (escape) {
                if (escapeSeq.indexOf(c) < 0) {
                    curString = curString + escapeChar;
                }
                curString = curString + c;
                escape = false;
                lastEscapeOffset = curString.length();
                continue;
            }
            if (blockStack.size() > 0) {
                curString = curString + c;
                boolean multicharBlockDetected = false;
                for (int b = 0; b < blockStart.length; ++b) {
                    if (blockStartPos < 0 || Input.getBlockStr(blockStart[b]).compareTo(str.substring(blockStartPos, i)) != 0) continue;
                    blockStack.remove(0);
                    blockStack.add(0, b);
                    multicharBlockDetected = true;
                    break;
                }
                if (multicharBlockDetected) continue;
                if (Input.isNestedBlock(blockStart[(Integer)blockStack.get(0)]) && curString.substring(lastEscapeOffset + 1).endsWith(Input.getBlockStr(blockStart[(Integer)blockStack.get(0)]))) {
                    blockStack.add(0, (Integer)blockStack.get(0));
                    blockStartPos = i;
                    continue;
                }
                if (!curString.substring(lastEscapeOffset + 1).endsWith(Input.getBlockStr(blockEnd[(Integer)blockStack.get(0)]))) continue;
                if (!Input.isNestedBlock(blockEnd[(Integer)blockStack.get(0)])) {
                    for (String splitter : splitters) {
                        if (splitter.compareTo(Input.getBlockStr(blockEnd[(Integer)blockStack.get(0)])) != 0) continue;
                        splits.add(curString);
                        if (includeSplitter) {
                            splits.add(splitter);
                        }
                        curString = "";
                        lastEscapeOffset = -1;
                        break;
                    }
                }
                blockStartPos = -1;
                blockStack.remove(0);
                continue;
            }
            boolean splitted = false;
            for (String splitter : splitters) {
                int curentLenght = i + splitter.length();
                if (splitter.compareTo(str.substring(i, Math.min(curentLenght, str.length()))) != 0) continue;
                splits.add(curString);
                if (includeSplitter) {
                    splits.add(splitter);
                }
                curString = "";
                lastEscapeOffset = -1;
                i += splitter.length() - 1;
                splitted = true;
                break;
            }
            if (splitted) continue;
            curString = curString + c;
            for (int b = 0; b < blockStart.length; ++b) {
                if (!curString.substring(lastEscapeOffset + 1).endsWith(Input.getBlockStr(blockStart[b]))) continue;
                blockStack.add(0, b);
                blockStartPos = i;
                continue block0;
            }
        }
        if (curString.length() > 0) {
            splits.add(curString.trim());
        }
        return splits.toArray(new String[0]);
    }

    private static String getBlockStr(String blockDef) {
        if (blockDef.startsWith("N_")) {
            return blockDef.substring("N_".length());
        }
        return blockDef;
    }

    private static boolean isNestedBlock(String blockDef) {
        return blockDef.startsWith("N_");
    }

    public static class ParamOption {
        Object value;
        String displayName;

        public ParamOption(Object value, String displayName) {
            this.value = value;
            this.displayName = displayName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParamOption that = (ParamOption)o;
            if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
                return false;
            }
            return this.displayName != null ? this.displayName.equals(that.displayName) : that.displayName == null;
        }

        public int hashCode() {
            int result = this.value != null ? this.value.hashCode() : 0;
            result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
            return result;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }
    }
}

