/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.net.URL;
import java.util.List;
import java.util.Properties;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.WrappedInterpreter;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.scheduler.Scheduler;

public class ClassloaderInterpreter
extends Interpreter
implements WrappedInterpreter {
    private ClassLoader cl;
    private Interpreter intp;

    public ClassloaderInterpreter(Interpreter intp, ClassLoader cl) {
        super(new Properties());
        this.cl = cl;
        this.intp = intp;
    }

    @Override
    public Interpreter getInnerInterpreter() {
        return this.intp;
    }

    public ClassLoader getClassloader() {
        return this.cl;
    }

    @Override
    public InterpreterResult interpret(String st, InterpreterContext context) {
        ClassLoader oldcl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.cl);
        try {
            InterpreterResult interpreterResult = this.intp.interpret(st, context);
            return interpreterResult;
        }
        catch (InterpreterException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InterpreterException(e);
        }
        finally {
            this.cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(oldcl);
        }
    }

    @Override
    public void open() {
        ClassLoader oldcl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.cl);
        try {
            this.intp.open();
        }
        catch (Exception e) {
            throw new InterpreterException(e);
        }
        finally {
            this.cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(oldcl);
        }
    }

    @Override
    public void close() {
        ClassLoader oldcl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.cl);
        try {
            this.intp.close();
        }
        catch (Exception e) {
            throw new InterpreterException(e);
        }
        finally {
            this.cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(oldcl);
        }
    }

    @Override
    public void cancel(InterpreterContext context) {
        ClassLoader oldcl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.cl);
        try {
            this.intp.cancel(context);
        }
        catch (Exception e) {
            throw new InterpreterException(e);
        }
        finally {
            this.cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(oldcl);
        }
    }

    @Override
    public Interpreter.FormType getFormType() {
        ClassLoader oldcl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.cl);
        try {
            Interpreter.FormType formType = this.intp.getFormType();
            return formType;
        }
        catch (Exception e) {
            throw new InterpreterException(e);
        }
        finally {
            this.cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(oldcl);
        }
    }

    @Override
    public int getProgress(InterpreterContext context) {
        ClassLoader oldcl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.cl);
        try {
            int n = this.intp.getProgress(context);
            return n;
        }
        catch (Exception e) {
            throw new InterpreterException(e);
        }
        finally {
            this.cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(oldcl);
        }
    }

    @Override
    public Scheduler getScheduler() {
        ClassLoader oldcl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.cl);
        try {
            Scheduler scheduler = this.intp.getScheduler();
            return scheduler;
        }
        catch (Exception e) {
            throw new InterpreterException(e);
        }
        finally {
            this.cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(oldcl);
        }
    }

    @Override
    public List<InterpreterCompletion> completion(String buf, int cursor) {
        ClassLoader oldcl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.cl);
        try {
            List<InterpreterCompletion> completion2;
            List<InterpreterCompletion> list = completion2 = this.intp.completion(buf, cursor);
            return list;
        }
        catch (Exception e) {
            throw new InterpreterException(e);
        }
        finally {
            this.cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(oldcl);
        }
    }

    @Override
    public String getClassName() {
        ClassLoader oldcl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.cl);
        try {
            String string = this.intp.getClassName();
            return string;
        }
        catch (Exception e) {
            throw new InterpreterException(e);
        }
        finally {
            this.cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(oldcl);
        }
    }

    @Override
    public void setInterpreterGroup(InterpreterGroup interpreterGroup) {
        ClassLoader oldcl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.cl);
        try {
            this.intp.setInterpreterGroup(interpreterGroup);
        }
        catch (Exception e) {
            throw new InterpreterException(e);
        }
        finally {
            this.cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(oldcl);
        }
    }

    @Override
    public InterpreterGroup getInterpreterGroup() {
        ClassLoader oldcl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.cl);
        try {
            InterpreterGroup interpreterGroup = this.intp.getInterpreterGroup();
            return interpreterGroup;
        }
        catch (Exception e) {
            throw new InterpreterException(e);
        }
        finally {
            this.cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(oldcl);
        }
    }

    @Override
    public void setClassloaderUrls(URL[] urls) {
        ClassLoader oldcl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.cl);
        try {
            this.intp.setClassloaderUrls(urls);
        }
        catch (Exception e) {
            throw new InterpreterException(e);
        }
        finally {
            this.cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(oldcl);
        }
    }

    @Override
    public URL[] getClassloaderUrls() {
        ClassLoader oldcl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.cl);
        try {
            URL[] uRLArray = this.intp.getClassloaderUrls();
            return uRLArray;
        }
        catch (Exception e) {
            throw new InterpreterException(e);
        }
        finally {
            this.cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(oldcl);
        }
    }

    @Override
    public void setProperty(Properties property) {
        ClassLoader oldcl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.cl);
        try {
            this.intp.setProperty(property);
        }
        catch (Exception e) {
            throw new InterpreterException(e);
        }
        finally {
            this.cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(oldcl);
        }
    }

    @Override
    public Properties getProperty() {
        ClassLoader oldcl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.cl);
        try {
            Properties properties = this.intp.getProperty();
            return properties;
        }
        catch (Exception e) {
            throw new InterpreterException(e);
        }
        finally {
            this.cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(oldcl);
        }
    }

    @Override
    public String getProperty(String key) {
        ClassLoader oldcl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.cl);
        try {
            String string = this.intp.getProperty(key);
            return string;
        }
        catch (Exception e) {
            throw new InterpreterException(e);
        }
        finally {
            this.cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(oldcl);
        }
    }
}

