/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class InterpreterResult
implements Serializable {
    Code code;
    Type type;
    String msg;

    public InterpreterResult(Code code) {
        this.code = code;
        this.msg = null;
        this.type = Type.TEXT;
    }

    public InterpreterResult(Code code, String msg) {
        this.code = code;
        this.msg = this.getData(msg);
        this.type = this.getType(msg);
    }

    public InterpreterResult(Code code, Type type, String msg) {
        this.code = code;
        this.msg = msg;
        this.type = type;
    }

    private String getData(String msg) {
        if (msg == null) {
            return null;
        }
        InterpreterResult interpreterResult = this;
        Type[] types = interpreterResult.type.values();
        TreeMap<Integer, Type> typesLastIndexInMsg = this.buildIndexMap(msg);
        if (typesLastIndexInMsg.size() == 0) {
            return msg;
        }
        Map.Entry<Integer, Type> lastType = typesLastIndexInMsg.firstEntry();
        int magicLength = lastType.getValue().name().length() + 1;
        int subStringPos = magicLength + lastType.getKey() + 1;
        return msg.substring(subStringPos);
    }

    private Type getType(String msg) {
        if (msg == null) {
            return Type.TEXT;
        }
        InterpreterResult interpreterResult = this;
        Type[] types = interpreterResult.type.values();
        TreeMap<Integer, Type> typesLastIndexInMsg = this.buildIndexMap(msg);
        if (typesLastIndexInMsg.size() == 0) {
            return Type.TEXT;
        }
        Map.Entry<Integer, Type> lastType = typesLastIndexInMsg.firstEntry();
        return lastType.getValue();
    }

    private int getIndexOfType(String msg, Type t) {
        if (msg == null) {
            return 0;
        }
        String typeString = "%" + t.name().toLowerCase();
        return StringUtils.indexOf((CharSequence)msg, typeString);
    }

    private TreeMap<Integer, Type> buildIndexMap(String msg) {
        Type[] types;
        int lastIndexOftypes = 0;
        TreeMap<Integer, Type> typesLastIndexInMsg = new TreeMap<Integer, Type>();
        for (Type t : types = Type.values()) {
            lastIndexOftypes = this.getIndexOfType(msg, t);
            if (lastIndexOftypes < 0) continue;
            typesLastIndexInMsg.put(lastIndexOftypes, t);
        }
        return typesLastIndexInMsg;
    }

    public Code code() {
        return this.code;
    }

    public String message() {
        return this.msg;
    }

    public Type type() {
        return this.type;
    }

    public InterpreterResult type(Type type) {
        this.type = type;
        return this;
    }

    public String toString() {
        return "%" + this.type.name().toLowerCase() + " " + this.msg;
    }

    public static enum Type {
        TEXT,
        HTML,
        ANGULAR,
        TABLE,
        IMG,
        SVG,
        NULL;

    }

    public static enum Code {
        SUCCESS,
        INCOMPLETE,
        ERROR,
        KEEP_PREVIOUS_RESULT;

    }
}

