/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.zeppelin.interpreter.InterpreterContextRunner;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterpreterContextRunnerPool {
    Logger logger = LoggerFactory.getLogger(InterpreterContextRunnerPool.class);
    private Map<String, List<InterpreterContextRunner>> interpreterContextRunners = new HashMap<String, List<InterpreterContextRunner>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String noteId, InterpreterContextRunner runner) {
        Map<String, List<InterpreterContextRunner>> map = this.interpreterContextRunners;
        synchronized (map) {
            if (!this.interpreterContextRunners.containsKey(noteId)) {
                this.interpreterContextRunners.put(noteId, new LinkedList());
            }
            this.interpreterContextRunners.get(noteId).add(runner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(String noteId, List<InterpreterContextRunner> runners) {
        Map<String, List<InterpreterContextRunner>> map = this.interpreterContextRunners;
        synchronized (map) {
            if (!this.interpreterContextRunners.containsKey(noteId)) {
                this.interpreterContextRunners.put(noteId, new LinkedList());
            }
            this.interpreterContextRunners.get(noteId).addAll(runners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(String noteId) {
        Map<String, List<InterpreterContextRunner>> map = this.interpreterContextRunners;
        synchronized (map) {
            this.interpreterContextRunners.remove(noteId);
        }
    }

    public void run(String noteId, String paragraphId) {
        Map<String, List<InterpreterContextRunner>> map = this.interpreterContextRunners;
        synchronized (map) {
            List<InterpreterContextRunner> list = this.interpreterContextRunners.get(noteId);
            if (list != null) {
                for (InterpreterContextRunner r : list) {
                    if (!noteId.equals(r.getNoteId()) || !paragraphId.equals(r.getParagraphId())) continue;
                    this.logger.info("run paragraph {} on note {} from InterpreterContext", (Object)r.getParagraphId(), (Object)r.getNoteId());
                    r.run();
                    return;
                }
            }
            throw new InterpreterException("Can not run paragraph " + paragraphId + " on " + noteId);
        }
    }
}

