/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.thrift.TException;
import org.apache.zeppelin.display.AngularObject;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.interpreter.InterpreterContextRunner;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.remote.RemoteAngularObject;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterContextRunner;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcess;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcessListener;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterEvent;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterEventType;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterService;
import org.apache.zeppelin.resource.Resource;
import org.apache.zeppelin.resource.ResourceId;
import org.apache.zeppelin.resource.ResourcePool;
import org.apache.zeppelin.resource.ResourceSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteInterpreterEventPoller
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(RemoteInterpreterEventPoller.class);
    private final RemoteInterpreterProcessListener listener;
    private volatile boolean shutdown;
    private RemoteInterpreterProcess interpreterProcess;
    private InterpreterGroup interpreterGroup;

    public RemoteInterpreterEventPoller(RemoteInterpreterProcessListener listener) {
        this.listener = listener;
        this.shutdown = false;
    }

    public void setInterpreterProcess(RemoteInterpreterProcess interpreterProcess) {
        this.interpreterProcess = interpreterProcess;
    }

    public void setInterpreterGroup(InterpreterGroup interpreterGroup) {
        this.interpreterGroup = interpreterGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        RemoteInterpreterService.Client client = null;
        while (!this.shutdown && this.interpreterProcess.isRunning()) {
            try {
                client = this.interpreterProcess.getClient();
            }
            catch (Exception e1) {
                logger.error("Can't get RemoteInterpreterEvent", e1);
                this.waitQuietly();
                continue;
            }
            RemoteInterpreterEvent event = null;
            boolean broken = false;
            try {
                event = client.getEvent();
            }
            catch (TException e) {
                broken = true;
                logger.error("Can't get RemoteInterpreterEvent", e);
                this.waitQuietly();
                continue;
            }
            finally {
                this.interpreterProcess.releaseClient(client, broken);
                continue;
            }
            Gson gson = new Gson();
            AngularObjectRegistry angularObjectRegistry = this.interpreterGroup.getAngularObjectRegistry();
            try {
                String paragraphId;
                String noteId;
                Map outputAppend;
                AngularObject angularObject;
                if (event.getType() == RemoteInterpreterEventType.NO_OP) continue;
                if (event.getType() == RemoteInterpreterEventType.ANGULAR_OBJECT_ADD) {
                    angularObject = gson.fromJson(event.getData(), AngularObject.class);
                    angularObjectRegistry.add(angularObject.getName(), angularObject.get(), angularObject.getNoteId(), angularObject.getParagraphId());
                } else if (event.getType() == RemoteInterpreterEventType.ANGULAR_OBJECT_UPDATE) {
                    angularObject = gson.fromJson(event.getData(), AngularObject.class);
                    AngularObject localAngularObject = angularObjectRegistry.get(angularObject.getName(), angularObject.getNoteId(), angularObject.getParagraphId());
                    if (localAngularObject instanceof RemoteAngularObject) {
                        ((RemoteAngularObject)localAngularObject).set(angularObject.get(), true, false);
                    } else {
                        localAngularObject.set(angularObject.get());
                    }
                } else if (event.getType() == RemoteInterpreterEventType.ANGULAR_OBJECT_REMOVE) {
                    angularObject = gson.fromJson(event.getData(), AngularObject.class);
                    angularObjectRegistry.remove(angularObject.getName(), angularObject.getNoteId(), angularObject.getParagraphId());
                } else if (event.getType() == RemoteInterpreterEventType.RUN_INTERPRETER_CONTEXT_RUNNER) {
                    InterpreterContextRunner runnerFromRemote = gson.fromJson(event.getData(), RemoteInterpreterContextRunner.class);
                    this.interpreterProcess.getInterpreterContextRunnerPool().run(runnerFromRemote.getNoteId(), runnerFromRemote.getParagraphId());
                } else if (event.getType() == RemoteInterpreterEventType.RESOURCE_POOL_GET_ALL) {
                    ResourceSet resourceSet = this.getAllResourcePoolExcept();
                    this.sendResourcePoolResponseGetAll(resourceSet);
                } else if (event.getType() == RemoteInterpreterEventType.RESOURCE_GET) {
                    String resourceIdString = event.getData();
                    ResourceId resourceId = gson.fromJson(resourceIdString, ResourceId.class);
                    logger.debug("RESOURCE_GET {} {}", (Object)resourceId.getResourcePoolId(), (Object)resourceId.getName());
                    Object o = this.getResource(resourceId);
                    this.sendResourceResponseGet(resourceId, o);
                } else if (event.getType() == RemoteInterpreterEventType.OUTPUT_APPEND) {
                    outputAppend = (Map)gson.fromJson(event.getData(), new TypeToken<Map<String, String>>(){}.getType());
                    noteId = (String)outputAppend.get("noteId");
                    paragraphId = (String)outputAppend.get("paragraphId");
                    String outputToAppend = (String)outputAppend.get("data");
                    this.listener.onOutputAppend(noteId, paragraphId, outputToAppend);
                } else if (event.getType() == RemoteInterpreterEventType.OUTPUT_UPDATE) {
                    outputAppend = (Map)gson.fromJson(event.getData(), new TypeToken<Map<String, String>>(){}.getType());
                    noteId = (String)outputAppend.get("noteId");
                    paragraphId = (String)outputAppend.get("paragraphId");
                    String outputToUpdate = (String)outputAppend.get("data");
                    this.listener.onOutputUpdated(noteId, paragraphId, outputToUpdate);
                }
                logger.debug("Event from remoteproceess {}", (Object)event.getType());
            }
            catch (Exception e) {
                logger.error("Can't handle event " + event, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResourcePoolResponseGetAll(ResourceSet resourceSet) {
        RemoteInterpreterService.Client client = null;
        boolean broken = false;
        try {
            client = this.interpreterProcess.getClient();
            LinkedList<String> resourceList = new LinkedList<String>();
            Gson gson = new Gson();
            for (Resource r : resourceSet) {
                resourceList.add(gson.toJson(r));
            }
            client.resourcePoolResponseGetAll(resourceList);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            broken = true;
        }
        finally {
            if (client != null) {
                this.interpreterProcess.releaseClient(client, broken);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceSet getAllResourcePoolExcept() {
        ResourceSet resourceSet = new ResourceSet();
        for (InterpreterGroup intpGroup : InterpreterGroup.getAll()) {
            if (intpGroup.getId().equals(this.interpreterGroup.getId())) continue;
            RemoteInterpreterProcess remoteInterpreterProcess = intpGroup.getRemoteInterpreterProcess();
            if (remoteInterpreterProcess == null) {
                ResourcePool localPool = intpGroup.getResourcePool();
                if (localPool == null) continue;
                resourceSet.addAll(localPool.getAll());
                continue;
            }
            if (!this.interpreterProcess.isRunning()) continue;
            RemoteInterpreterService.Client client = null;
            boolean broken = false;
            try {
                client = remoteInterpreterProcess.getClient();
                List<String> resourceList = client.resourcePoolGetAll();
                Gson gson = new Gson();
                for (String res : resourceList) {
                    resourceSet.add(gson.fromJson(res, Resource.class));
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), e);
                broken = true;
            }
            finally {
                if (client == null) continue;
                intpGroup.getRemoteInterpreterProcess().releaseClient(client, broken);
            }
        }
        return resourceSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResourceResponseGet(ResourceId resourceId, Object o) {
        RemoteInterpreterService.Client client = null;
        boolean broken = false;
        try {
            client = this.interpreterProcess.getClient();
            Gson gson = new Gson();
            String rid = gson.toJson(resourceId);
            ByteBuffer obj = o == null ? ByteBuffer.allocate(0) : Resource.serializeObject(o);
            client.resourceResponseGet(rid, obj);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            broken = true;
        }
        finally {
            if (client != null) {
                this.interpreterProcess.releaseClient(client, broken);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getResource(ResourceId resourceId) {
        InterpreterGroup intpGroup = InterpreterGroup.getByInterpreterGroupId(resourceId.getResourcePoolId());
        if (intpGroup == null) {
            return null;
        }
        RemoteInterpreterProcess remoteInterpreterProcess = intpGroup.getRemoteInterpreterProcess();
        if (remoteInterpreterProcess == null) {
            ResourcePool localPool = intpGroup.getResourcePool();
            if (localPool != null) {
                return localPool.get(resourceId.getName());
            }
        } else if (this.interpreterProcess.isRunning()) {
            RemoteInterpreterService.Client client = null;
            boolean broken = false;
            try {
                Object o;
                client = remoteInterpreterProcess.getClient();
                ByteBuffer res = client.resourceGet(resourceId.getNoteId(), resourceId.getParagraphId(), resourceId.getName());
                Object object = o = Resource.deserializeObject(res);
                return object;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), e);
                broken = true;
            }
            finally {
                if (client != null) {
                    intpGroup.getRemoteInterpreterProcess().releaseClient(client, broken);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitQuietly() {
        try {
            RemoteInterpreterEventPoller remoteInterpreterEventPoller = this;
            synchronized (remoteInterpreterEventPoller) {
                this.wait(1000L);
            }
        }
        catch (InterruptedException ignored) {
            logger.info("Error in RemoteInterpreterEventPoller while waitQuietly : ", ignored);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdown = true;
        RemoteInterpreterEventPoller remoteInterpreterEventPoller = this;
        synchronized (remoteInterpreterEventPoller) {
            this.notify();
        }
    }
}

