/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.resource;

import org.apache.zeppelin.resource.LocalResourcePool;
import org.apache.zeppelin.resource.Resource;
import org.apache.zeppelin.resource.ResourcePoolConnector;
import org.apache.zeppelin.resource.ResourceSet;

public class DistributedResourcePool
extends LocalResourcePool {
    private final ResourcePoolConnector connector;

    public DistributedResourcePool(String id, ResourcePoolConnector connector) {
        super(id);
        this.connector = connector;
    }

    @Override
    public Resource get(String name) {
        return this.get(name, true);
    }

    @Override
    public Resource get(String noteId, String paragraphId, String name) {
        return this.get(noteId, paragraphId, name, true);
    }

    public Resource get(String name, boolean remote) {
        Resource resource = super.get(name);
        if (resource != null) {
            return resource;
        }
        if (remote) {
            ResourceSet resources = this.connector.getAllResources().filterByName(name);
            if (resources.isEmpty()) {
                return null;
            }
            return (Resource)resources.get(0);
        }
        return null;
    }

    public Resource get(String noteId, String paragraphId, String name, boolean remote) {
        Resource resource = super.get(noteId, paragraphId, name);
        if (resource != null) {
            return resource;
        }
        if (remote) {
            ResourceSet resources = this.connector.getAllResources().filterByNoteId(noteId).filterByParagraphId(paragraphId).filterByName(name);
            if (resources.isEmpty()) {
                return null;
            }
            return (Resource)resources.get(0);
        }
        return null;
    }

    @Override
    public ResourceSet getAll() {
        return this.getAll(true);
    }

    public ResourceSet getAll(boolean remote) {
        ResourceSet all = super.getAll();
        if (remote) {
            all.addAll(this.connector.getAllResources());
        }
        return all;
    }
}

