/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.binders;

import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.PrivateBinder;
import com.google.inject.spi.DefaultElementVisitor;
import com.google.inject.spi.Element;
import com.google.inject.spi.InjectionRequest;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.PrivateElements;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderLookup;
import com.google.inject.spi.StaticInjectionRequest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonatype.guice.bean.binders.DependencyAnalyzer;
import org.sonatype.guice.bean.binders.MergedParameters;
import org.sonatype.guice.bean.binders.ParameterKeys;
import org.sonatype.guice.bean.binders.Wiring;
import org.sonatype.guice.bean.reflect.Logs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ElementAnalyzer
extends DefaultElementVisitor<Void> {
    private final Set<Key<?>> localKeys = new HashSet();
    private final DependencyAnalyzer analyzer = new DependencyAnalyzer();
    private final List<ElementAnalyzer> privateAnalyzers = new ArrayList<ElementAnalyzer>();
    private final List<Map<String, String>> params = new ArrayList<Map<String, String>>();
    private final Binder binder;

    ElementAnalyzer(Binder binder) {
        this.binder = binder;
    }

    public void apply(Wiring wiring) {
        Set<Key<Key<?>>> missingKeys = this.analyzer.getRequiredKeys();
        missingKeys.removeAll(this.localKeys);
        this.bindParameters(missingKeys);
        for (Key<?> key : missingKeys) {
            wiring.wire(key);
        }
        for (ElementAnalyzer elementAnalyzer : this.privateAnalyzers) {
            elementAnalyzer.localKeys.addAll(this.localKeys);
            elementAnalyzer.localKeys.addAll(missingKeys);
            elementAnalyzer.apply(wiring);
        }
    }

    @Override
    public <T> Void visit(Binding<T> binding) {
        Key<T> key = binding.getKey();
        if (this.localKeys.contains(key)) {
            return null;
        }
        if (ParameterKeys.PROPERTIES.equals(key)) {
            this.mergeParameters(binding);
        } else if (binding.acceptTargetVisitor(this.analyzer).booleanValue()) {
            this.localKeys.add(key);
            binding.applyTo(this.binder);
        }
        return null;
    }

    @Override
    public Void visit(PrivateElements elements) {
        PrivateBinder privateBinder = this.binder.withSource(elements.getSource()).newPrivateBinder();
        ElementAnalyzer privateAnalyzer = new ElementAnalyzer(privateBinder);
        this.privateAnalyzers.add(privateAnalyzer);
        privateAnalyzer.localKeys.addAll(this.localKeys);
        for (Element element : elements.getElements()) {
            element.acceptVisitor(privateAnalyzer);
        }
        for (Key key : elements.getExposedKeys()) {
            if (!privateAnalyzer.localKeys.contains(key) || !this.localKeys.add(key)) continue;
            privateBinder.withSource(elements.getExposedSource(key)).expose(key);
        }
        return null;
    }

    @Override
    public <T> Void visit(ProviderLookup<T> lookup) {
        this.analyzer.visit(lookup);
        lookup.applyTo(this.binder);
        return null;
    }

    @Override
    public Void visit(StaticInjectionRequest request) {
        this.analyzer.visit(request);
        request.applyTo(this.binder);
        return null;
    }

    @Override
    public Void visit(InjectionRequest<?> request) {
        this.analyzer.visit(request);
        request.applyTo(this.binder);
        return null;
    }

    @Override
    public Void visitOther(Element element) {
        element.applyTo(this.binder);
        return null;
    }

    private <T> void mergeParameters(Binding<T> binding) {
        if (binding instanceof InstanceBinding) {
            this.params.add((Map<String, String>)((InstanceBinding)binding).getInstance());
        } else if (binding instanceof ProviderInstanceBinding) {
            this.params.add((Map<String, String>)((ProviderInstanceBinding)binding).getProviderInstance().get());
        } else {
            Logs.warn("Ignoring non-instance @Parameters binding: {}", binding, null);
        }
    }

    private void bindParameters(Set<Key<?>> missingKeys) {
        if (missingKeys.remove(ParameterKeys.PROPERTIES)) {
            this.binder.bind(ParameterKeys.PROPERTIES).toInstance(new MergedParameters(this.params));
            this.localKeys.add(ParameterKeys.PROPERTIES);
        }
        if (missingKeys.remove(ParameterKeys.ARGUMENTS)) {
            this.binder.bind(ParameterKeys.ARGUMENTS).toInstance(new String[0]);
            this.localKeys.add(ParameterKeys.ARGUMENTS);
        }
    }
}

