/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.reflect;

import java.util.logging.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Logs {
    private static final String ANCHOR = "{}";
    private static final boolean DEBUG_ENABLED;
    private static final boolean SLF4J_ENABLED;
    private static final Object LOGGER;

    private Logs() {
    }

    public static void debug(String format, Object arg1, Object arg2) {
        if (DEBUG_ENABLED) {
            String message = Logs.format(Logs.format(format, arg1), arg2);
            if (arg2 instanceof Throwable) {
                if (SLF4J_ENABLED) {
                    ((Logger)LOGGER).debug(message, (Throwable)arg2);
                } else {
                    ((java.util.logging.Logger)LOGGER).log(Level.FINE, message, (Throwable)arg2);
                }
            } else if (SLF4J_ENABLED) {
                ((Logger)LOGGER).debug(message);
            } else {
                ((java.util.logging.Logger)LOGGER).fine(message);
            }
        }
    }

    public static void warn(String format, Object arg1, Object arg2) {
        String message = Logs.format(Logs.format(format, arg1), arg2);
        if (arg2 instanceof Throwable) {
            if (SLF4J_ENABLED) {
                ((Logger)LOGGER).warn(message, (Throwable)arg2);
            } else {
                ((java.util.logging.Logger)LOGGER).log(Level.WARNING, message, (Throwable)arg2);
            }
        } else if (SLF4J_ENABLED) {
            ((Logger)LOGGER).warn(message);
        } else {
            ((java.util.logging.Logger)LOGGER).warning(message);
        }
    }

    private static String format(String format, Object arg) {
        int cursor = format.indexOf(ANCHOR);
        if (cursor < 0) {
            return format;
        }
        StringBuilder buf = new StringBuilder();
        if (cursor > 0) {
            buf.append(format.substring(0, cursor));
        }
        try {
            buf.append(arg);
        }
        catch (Throwable e) {
            buf.append(arg.getClass());
        }
        if ((cursor += ANCHOR.length()) < format.length()) {
            buf.append(format.substring(cursor, format.length()));
        }
        return buf.toString();
    }

    static {
        boolean debugEnabled = false;
        boolean slf4jEnabled = false;
        Object[] logger = new Object[]{null};
        String name = "Sisu";
        try {
            logger[0] = LoggerFactory.getLogger("Sisu");
            debugEnabled = ((Logger)logger[0]).isDebugEnabled();
            slf4jEnabled = true;
        }
        catch (Throwable e) {
            logger[0] = java.util.logging.Logger.getLogger("Sisu");
            debugEnabled = ((java.util.logging.Logger)logger[0]).isLoggable(Level.FINE);
        }
        DEBUG_ENABLED = debugEnabled;
        SLF4J_ENABLED = slf4jEnabled;
        LOGGER = logger[0];
    }
}

