/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.reflect;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.Manifest;
import org.sonatype.guice.bean.reflect.ClassSpace;
import org.sonatype.guice.bean.reflect.DeferredClass;
import org.sonatype.guice.bean.reflect.NamedClass;
import org.sonatype.guice.bean.reflect.ResourceEnumeration;
import org.sonatype.guice.bean.reflect.Streams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class URLClassSpace
implements ClassSpace {
    private static final String MANIFEST_ENTRY = "META-INF/MANIFEST.MF";
    private static final URL[] NO_URLS = new URL[0];
    private static final Enumeration<URL> NO_ENTRIES = Collections.enumeration(Arrays.asList(NO_URLS));
    private static final String[] EMPTY_CLASSPATH = new String[0];
    private final ClassLoader loader;
    private URL[] classPath;

    public URLClassSpace(ClassLoader loader) {
        this.loader = loader;
    }

    public URLClassSpace(ClassLoader loader, URL[] path) {
        this.loader = loader;
        this.classPath = null != path && path.length > 0 ? URLClassSpace.expandClassPath(path) : NO_URLS;
    }

    @Override
    public Class<?> loadClass(String name) {
        try {
            return this.loader.loadClass(name);
        }
        catch (Throwable e) {
            throw new TypeNotPresentException(name, e);
        }
    }

    @Override
    public DeferredClass<?> deferLoadClass(String name) {
        return new NamedClass(this, name);
    }

    @Override
    public URL getResource(String name) {
        return this.loader.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) {
        try {
            return this.loader.getResources(name);
        }
        catch (IOException e) {
            return NO_ENTRIES;
        }
    }

    @Override
    public Enumeration<URL> findEntries(String path, String glob, boolean recurse) {
        return new ResourceEnumeration(path, glob, recurse, this.getClassPath());
    }

    @Override
    public boolean loadedClass(Class<?> clazz) {
        return this.loader.equals(clazz.getClassLoader());
    }

    public URL[] getURLs() {
        return (URL[])this.getClassPath().clone();
    }

    public int hashCode() {
        return this.loader.hashCode();
    }

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (rhs instanceof URLClassSpace) {
            return this.loader.equals(((URLClassSpace)rhs).loader);
        }
        return false;
    }

    public String toString() {
        return this.loader.toString();
    }

    private synchronized URL[] getClassPath() {
        if (null == this.classPath) {
            for (ClassLoader l = this.loader; l != null; l = l.getParent()) {
                URL[] path;
                if (!(l instanceof URLClassLoader) || null == (path = ((URLClassLoader)l).getURLs()) || path.length <= 0) continue;
                this.classPath = URLClassSpace.expandClassPath(path);
                break;
            }
            if (null == this.classPath) {
                this.classPath = NO_URLS;
            }
        }
        return this.classPath;
    }

    private static URL[] expandClassPath(URL[] classPath) {
        ArrayList<URL> searchPath = new ArrayList<URL>();
        Collections.addAll(searchPath, classPath);
        ArrayList<URL> expandedPath = new ArrayList<URL>();
        HashSet<String> visited = new HashSet<String>();
        for (int i = 0; i < searchPath.size(); ++i) {
            String[] classPathEntries;
            URL url = URLClassSpace.normalizeEntry((URL)searchPath.get(i));
            if (null == url || !visited.add(url.toString())) continue;
            expandedPath.add(url);
            try {
                classPathEntries = URLClassSpace.getClassPathEntries(url);
            }
            catch (IOException e) {
                continue;
            }
            for (String entry : classPathEntries) {
                try {
                    searchPath.add(new URL(url, entry));
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
        }
        return expandedPath.toArray(new URL[expandedPath.size()]);
    }

    private static URL normalizeEntry(URL url) {
        String path;
        if (null != url && "jar".equals(url.getProtocol()) && (path = url.getPath()).endsWith("!/")) {
            try {
                return new URL(path.substring(0, path.length() - 2));
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e.toString());
            }
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getClassPathEntries(URL url) throws IOException {
        URL manifestURL = url.getPath().endsWith("/") ? new URL(url, MANIFEST_ENTRY) : new URL("jar:" + url + "!/" + MANIFEST_ENTRY);
        InputStream in = Streams.open(manifestURL);
        try {
            String classPath = new Manifest(in).getMainAttributes().getValue("Class-Path");
            String[] stringArray = null != classPath ? classPath.split(" ") : EMPTY_CLASSPATH;
            return stringArray;
        }
        finally {
            in.close();
        }
    }
}

