/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.dep;

import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.zeppelin.dep.Booter;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.repository.Proxy;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.repository.RepositoryPolicy;
import org.sonatype.aether.resolution.ArtifactResult;

public abstract class AbstractDependencyResolver {
    protected RepositorySystem system = Booter.newRepositorySystem();
    protected List<RemoteRepository> repos = new LinkedList<RemoteRepository>();
    protected RepositorySystemSession session;

    public AbstractDependencyResolver(String localRepoPath) {
        this.session = Booter.newRepositorySystemSession(this.system, localRepoPath);
        this.repos.add(Booter.newCentralRepository());
        this.repos.add(Booter.newLocalRepository());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProxy(URL proxyUrl, String proxyUser, String proxyPassword) {
        Authentication auth = new Authentication(proxyUser, proxyPassword);
        Proxy proxy = new Proxy(proxyUrl.getProtocol(), proxyUrl.getHost(), proxyUrl.getPort(), auth);
        List<RemoteRepository> list = this.repos;
        synchronized (list) {
            for (RemoteRepository repo : this.repos) {
                repo.setProxy(proxy);
            }
        }
    }

    public List<RemoteRepository> getRepos() {
        return this.repos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRepo(String id, String url, boolean snapshot) {
        List<RemoteRepository> list = this.repos;
        synchronized (list) {
            this.delRepo(id);
            RemoteRepository rr = new RemoteRepository(id, "default", url);
            rr.setPolicy(snapshot, new RepositoryPolicy(true, "daily", "warn"));
            this.repos.add(rr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRepo(String id, String url, boolean snapshot, Authentication auth) {
        List<RemoteRepository> list = this.repos;
        synchronized (list) {
            this.delRepo(id);
            RemoteRepository rr = new RemoteRepository(id, "default", url);
            rr.setPolicy(snapshot, new RepositoryPolicy(true, "daily", "warn"));
            rr.setAuthentication(auth);
            this.repos.add(rr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteRepository delRepo(String id) {
        List<RemoteRepository> list = this.repos;
        synchronized (list) {
            Iterator<RemoteRepository> it = this.repos.iterator();
            while (it.hasNext()) {
                RemoteRepository repo = it.next();
                if (!repo.getId().equals(id)) continue;
                it.remove();
                return repo;
            }
        }
        return null;
    }

    public abstract List<ArtifactResult> getArtifactsWithDep(String var1, Collection<String> var2) throws Exception;
}

