/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import com.google.gson.Gson;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.zeppelin.display.AngularObject;
import org.apache.zeppelin.interpreter.InterpreterContextRunner;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterEvent;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterEventType;
import org.apache.zeppelin.resource.RemoteResource;
import org.apache.zeppelin.resource.Resource;
import org.apache.zeppelin.resource.ResourceId;
import org.apache.zeppelin.resource.ResourcePoolConnector;
import org.apache.zeppelin.resource.ResourceSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteInterpreterEventClient
implements ResourcePoolConnector {
    private final Logger logger = LoggerFactory.getLogger(RemoteInterpreterEvent.class);
    private final List<RemoteInterpreterEvent> eventQueue = new LinkedList<RemoteInterpreterEvent>();
    private final List<ResourceSet> getAllResourceResponse = new LinkedList<ResourceSet>();
    private final Map<ResourceId, Object> getResourceResponse = new HashMap<ResourceId, Object>();
    private final Gson gson = new Gson();

    public void run(InterpreterContextRunner runner) {
        this.sendEvent(new RemoteInterpreterEvent(RemoteInterpreterEventType.RUN_INTERPRETER_CONTEXT_RUNNER, this.gson.toJson(runner)));
    }

    public void angularObjectAdd(AngularObject object) {
        this.sendEvent(new RemoteInterpreterEvent(RemoteInterpreterEventType.ANGULAR_OBJECT_ADD, this.gson.toJson(object)));
    }

    public void angularObjectUpdate(AngularObject object) {
        this.sendEvent(new RemoteInterpreterEvent(RemoteInterpreterEventType.ANGULAR_OBJECT_UPDATE, this.gson.toJson(object)));
    }

    public void angularObjectRemove(String name, String noteId, String paragraphId) {
        HashMap<String, String> removeObject = new HashMap<String, String>();
        removeObject.put("name", name);
        removeObject.put("noteId", noteId);
        removeObject.put("paragraphId", paragraphId);
        this.sendEvent(new RemoteInterpreterEvent(RemoteInterpreterEventType.ANGULAR_OBJECT_REMOVE, this.gson.toJson(removeObject)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceSet getAllResources() {
        this.sendEvent(new RemoteInterpreterEvent(RemoteInterpreterEventType.RESOURCE_POOL_GET_ALL, null));
        List<ResourceSet> list = this.getAllResourceResponse;
        synchronized (list) {
            while (this.getAllResourceResponse.isEmpty()) {
                try {
                    this.getAllResourceResponse.wait();
                }
                catch (InterruptedException e) {
                    this.logger.warn(e.getMessage(), e);
                }
            }
            ResourceSet resourceSet = this.getAllResourceResponse.remove(0);
            return resourceSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object readResource(ResourceId resourceId) {
        this.logger.debug("Request Read Resource {} from ZeppelinServer", (Object)resourceId.getName());
        Map<ResourceId, Object> map = this.getResourceResponse;
        synchronized (map) {
            while (this.getResourceResponse.containsKey(resourceId)) {
                try {
                    this.getResourceResponse.wait();
                }
                catch (InterruptedException e) {
                    this.logger.warn(e.getMessage(), e);
                }
            }
            Gson gson = new Gson();
            this.sendEvent(new RemoteInterpreterEvent(RemoteInterpreterEventType.RESOURCE_GET, gson.toJson(resourceId)));
            while (!this.getResourceResponse.containsKey(resourceId)) {
                try {
                    this.getResourceResponse.wait();
                }
                catch (InterruptedException e) {
                    this.logger.warn(e.getMessage(), e);
                }
            }
            Object o = this.getResourceResponse.remove(resourceId);
            this.getResourceResponse.notifyAll();
            return o;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putResponseGetAllResources(List<String> resources) {
        this.logger.debug("ResourceSet from ZeppelinServer");
        ResourceSet resourceSet = new ResourceSet();
        for (String res : resources) {
            RemoteResource resource = this.gson.fromJson(res, RemoteResource.class);
            resource.setResourcePoolConnector(this);
            resourceSet.add(resource);
        }
        List<ResourceSet> list = this.getAllResourceResponse;
        synchronized (list) {
            this.getAllResourceResponse.add(resourceSet);
            this.getAllResourceResponse.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putResponseGetResource(String resourceId, ByteBuffer object) {
        ResourceId rid = this.gson.fromJson(resourceId, ResourceId.class);
        this.logger.debug("Response resource {} from RemoteInterpreter", (Object)rid.getName());
        Object o = null;
        try {
            o = Resource.deserializeObject(object);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            this.logger.error(e.getMessage(), e);
        }
        Map<ResourceId, Object> map = this.getResourceResponse;
        synchronized (map) {
            this.getResourceResponse.put(rid, o);
            this.getResourceResponse.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteInterpreterEvent pollEvent() {
        List<RemoteInterpreterEvent> list = this.eventQueue;
        synchronized (list) {
            if (this.eventQueue.isEmpty()) {
                try {
                    this.eventQueue.wait(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (this.eventQueue.isEmpty()) {
                return new RemoteInterpreterEvent(RemoteInterpreterEventType.NO_OP, "");
            }
            RemoteInterpreterEvent event = this.eventQueue.remove(0);
            this.logger.debug("Send event {}", (Object)event.getType());
            return event;
        }
    }

    public void onInterpreterOutputAppend(String noteId, String paragraphId, String output) {
        HashMap<String, String> appendOutput = new HashMap<String, String>();
        appendOutput.put("noteId", noteId);
        appendOutput.put("paragraphId", paragraphId);
        appendOutput.put("data", output);
        this.sendEvent(new RemoteInterpreterEvent(RemoteInterpreterEventType.OUTPUT_APPEND, this.gson.toJson(appendOutput)));
    }

    public void onInterpreterOutputUpdate(String noteId, String paragraphId, String output) {
        HashMap<String, String> appendOutput = new HashMap<String, String>();
        appendOutput.put("noteId", noteId);
        appendOutput.put("paragraphId", paragraphId);
        appendOutput.put("data", output);
        this.sendEvent(new RemoteInterpreterEvent(RemoteInterpreterEventType.OUTPUT_UPDATE, this.gson.toJson(appendOutput)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEvent(RemoteInterpreterEvent event) {
        List<RemoteInterpreterEvent> list = this.eventQueue;
        synchronized (list) {
            this.eventQueue.add(event);
            this.eventQueue.notifyAll();
        }
    }
}

