/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.connector.file;

import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.connector.file.FileRepositoryConnector;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.spi.connector.RepositoryConnector;
import org.sonatype.aether.spi.connector.RepositoryConnectorFactory;
import org.sonatype.aether.spi.io.FileProcessor;
import org.sonatype.aether.spi.locator.Service;
import org.sonatype.aether.spi.locator.ServiceLocator;
import org.sonatype.aether.spi.log.Logger;
import org.sonatype.aether.spi.log.NullLogger;
import org.sonatype.aether.transfer.NoRepositoryConnectorException;

@Component(role=RepositoryConnectorFactory.class, hint="file")
public class FileRepositoryConnectorFactory
implements RepositoryConnectorFactory,
Service {
    @Requirement
    private Logger logger = NullLogger.INSTANCE;
    @Requirement
    private FileProcessor fileProcessor;
    private int priority = 1;
    public static final String CFG_PREFIX = "aether.connector.file";

    public FileRepositoryConnectorFactory() {
    }

    public FileRepositoryConnectorFactory(Logger logger, FileProcessor fileProcessor) {
        this.setLogger(logger);
        this.setFileProcessor(fileProcessor);
    }

    public void initService(ServiceLocator locator) {
        this.setLogger(locator.getService(Logger.class));
        this.setFileProcessor(locator.getService(FileProcessor.class));
    }

    public FileRepositoryConnectorFactory setLogger(Logger logger) {
        this.logger = logger != null ? logger : NullLogger.INSTANCE;
        return this;
    }

    public FileRepositoryConnectorFactory setFileProcessor(FileProcessor fileProcessor) {
        if (fileProcessor == null) {
            throw new IllegalArgumentException("file processor has not been specified");
        }
        this.fileProcessor = fileProcessor;
        return this;
    }

    public RepositoryConnector newInstance(RepositorySystemSession session, RemoteRepository repository) throws NoRepositoryConnectorException {
        if ("file".equalsIgnoreCase(repository.getProtocol())) {
            FileRepositoryConnector connector = new FileRepositoryConnector(session, repository, this.fileProcessor, this.logger);
            return connector;
        }
        throw new NoRepositoryConnectorException(repository);
    }

    public int getPriority() {
        return this.priority;
    }

    public FileRepositoryConnectorFactory setPriority(int priority) {
        this.priority = priority;
        return this;
    }
}

