/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.containers;

import com.google.inject.Injector;
import com.google.inject.Key;
import java.util.Iterator;
import java.util.Map;
import org.sonatype.guice.bean.binders.ParameterKeys;
import org.sonatype.guice.bean.containers.SisuContext;
import org.sonatype.guice.bean.locators.BeanLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SisuContainer {
    private static final SisuContext MISSING_CONTEXT = new MissingContext();
    private static SisuContext context;

    public static void configure(Class<?> type, Map<String, String> properties) {
        SisuContainer.injector(type).getInstance(ParameterKeys.PROPERTIES).putAll(properties);
    }

    public static <T> T lookup(Key<T> key) {
        BeanLocator locator = SisuContainer.injector(key.getTypeLiteral().getRawType()).getInstance(BeanLocator.class);
        Iterator i = locator.locate(key).iterator();
        return i.hasNext() ? (T)((Map.Entry)i.next()).getValue() : null;
    }

    public static void inject(Object that) {
        SisuContainer.injector(that.getClass()).injectMembers(that);
    }

    static synchronized void context(SisuContext newContext) {
        context = newContext;
    }

    static synchronized Injector injector(Class<?> type) {
        return (null != context ? context : MISSING_CONTEXT).injector(type);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class MissingContext
    implements SisuContext {
        MissingContext() {
        }

        @Override
        public Injector injector(Class<?> type) {
            throw new IllegalStateException("No Sisu Context for thread: " + Thread.currentThread());
        }
    }
}

