/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.locators;

import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.spi.BindingScopingVisitor;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.ElementVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DelegatingBinding<T>
implements Binding<T> {
    private final Key<T> key;
    private final Binding<T> binding;

    DelegatingBinding(Key<T> key, Binding<T> binding) {
        this.key = key;
        this.binding = binding;
    }

    @Override
    public Key<T> getKey() {
        return this.key;
    }

    @Override
    public Provider<T> getProvider() {
        return this.binding.getProvider();
    }

    @Override
    public Object getSource() {
        return this.binding.getSource();
    }

    @Override
    public void applyTo(Binder binder) {
        binder.bind(this.getKey()).toProvider(this.getProvider());
    }

    public <V> V acceptVisitor(ElementVisitor<V> visitor) {
        return this.binding.acceptVisitor(visitor);
    }

    @Override
    public <V> V acceptScopingVisitor(BindingScopingVisitor<V> visitor) {
        return this.binding.acceptScopingVisitor(visitor);
    }

    @Override
    public <V> V acceptTargetVisitor(BindingTargetVisitor<? super T, V> visitor) {
        return this.binding.acceptTargetVisitor(visitor);
    }
}

