/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.reflect;

import com.google.inject.TypeLiteral;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeParameters {
    private static final TypeLiteral<?>[] NO_TYPE_LITERALS = new TypeLiteral[0];
    private static final TypeLiteral<?> OBJECT_TYPE_LITERAL = TypeLiteral.get(Object.class);

    private TypeParameters() {
    }

    public static TypeLiteral<?>[] get(TypeLiteral<?> typeLiteral) {
        Type type = typeLiteral.getType();
        if (type instanceof ParameterizedType) {
            Type[] argumentTypes = ((ParameterizedType)type).getActualTypeArguments();
            TypeLiteral[] argumentLiterals = new TypeLiteral[argumentTypes.length];
            for (int i = 0; i < argumentTypes.length; ++i) {
                argumentLiterals[i] = TypeParameters.expand(argumentTypes[i]);
            }
            return argumentLiterals;
        }
        if (type instanceof GenericArrayType) {
            return new TypeLiteral[]{TypeParameters.expand(((GenericArrayType)type).getGenericComponentType())};
        }
        return NO_TYPE_LITERALS;
    }

    public static TypeLiteral<?> get(TypeLiteral<?> typeLiteral, int index) {
        Type type = typeLiteral.getType();
        if (type instanceof ParameterizedType) {
            return TypeParameters.expand(((ParameterizedType)type).getActualTypeArguments()[index]);
        }
        if (type instanceof GenericArrayType) {
            if (0 == index) {
                return TypeParameters.expand(((GenericArrayType)type).getGenericComponentType());
            }
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return OBJECT_TYPE_LITERAL;
    }

    public static boolean isAssignableFrom(TypeLiteral<?> superLiteral, TypeLiteral<?> subLiteral) {
        Type resolvedType;
        Class<?> superClazz = superLiteral.getRawType();
        if (!superClazz.isAssignableFrom(subLiteral.getRawType())) {
            return false;
        }
        Type superType = superLiteral.getType();
        if (superClazz == superType) {
            return true;
        }
        if (superType instanceof ParameterizedType) {
            Type resolvedType2 = subLiteral.getSupertype(superClazz).getType();
            if (resolvedType2 instanceof ParameterizedType) {
                Type[] superArgs = ((ParameterizedType)superType).getActualTypeArguments();
                Type[] subArgs = ((ParameterizedType)resolvedType2).getActualTypeArguments();
                return TypeParameters.isAssignableFrom(superArgs, subArgs);
            }
        } else if (superType instanceof GenericArrayType && (resolvedType = subLiteral.getSupertype(superClazz).getType()) instanceof GenericArrayType) {
            Type superComponent = ((GenericArrayType)superType).getGenericComponentType();
            Type subComponent = ((GenericArrayType)resolvedType).getGenericComponentType();
            return TypeParameters.isAssignableFrom(new Type[]{superComponent}, new Type[]{subComponent});
        }
        return false;
    }

    private static TypeLiteral<?> expand(Type type) {
        if (type instanceof WildcardType) {
            return TypeLiteral.get(((WildcardType)type).getUpperBounds()[0]);
        }
        if (type instanceof TypeVariable) {
            return TypeLiteral.get(((TypeVariable)type).getBounds()[0]);
        }
        return TypeLiteral.get(type);
    }

    private static boolean isAssignableFrom(Type[] superArgs, Type[] subArgs) {
        int len = Math.min(superArgs.length, subArgs.length);
        for (int i = 0; i < len; ++i) {
            Type superType = superArgs[i];
            Type subType = subArgs[i];
            if (subType instanceof TypeVariable && TypeParameters.isAssignableFrom(TypeParameters.expand(subType), TypeParameters.expand(superType)) || !(superType instanceof WildcardType || superType instanceof TypeVariable ? !TypeParameters.isAssignableFrom(TypeParameters.expand(superType), TypeParameters.expand(subType)) : !superType.equals(subType))) continue;
            return false;
        }
        return true;
    }
}

