/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.cluster.listener;

import io.atomix.cluster.ClusterMembershipEvent;
import io.atomix.cluster.ClusterMembershipEventListener;
import io.atomix.cluster.Member;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeppelinClusterMembershipEventListener
implements ClusterMembershipEventListener {
    private static Logger logger = LoggerFactory.getLogger(ZeppelinClusterMembershipEventListener.class);

    public void event(ClusterMembershipEvent event) {
        switch ((ClusterMembershipEvent.Type)event.type()) {
            case MEMBER_ADDED: {
                logger.info(((Member)event.subject()).id() + " joined the cluster.");
                break;
            }
            case MEMBER_REMOVED: {
                logger.info(((Member)event.subject()).id() + " left the cluster.");
                break;
            }
            case METADATA_CHANGED: {
                logger.info(((Member)event.subject()).id() + " meta data changed.");
                break;
            }
            case REACHABILITY_CHANGED: {
                logger.info(((Member)event.subject()).id() + " reachability changed.");
            }
        }
    }
}

