/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.display;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.zeppelin.display.Input;
import org.apache.zeppelin.display.OldInput;
import org.apache.zeppelin.display.ui.CheckBox;
import org.apache.zeppelin.display.ui.OptionInput;
import org.apache.zeppelin.display.ui.Password;
import org.apache.zeppelin.display.ui.Select;
import org.apache.zeppelin.display.ui.TextBox;

public class GUI
implements Serializable {
    private static Gson gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)Input.TypeAdapterFactory).create();
    Map<String, Object> params = new HashMap<String, Object>();
    Map<String, Input> forms = new LinkedHashMap<String, Input>();

    public void setParams(Map<String, Object> values) {
        this.params = values;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public Map<String, Input> getForms() {
        return this.forms;
    }

    public void setForms(Map<String, Input> forms) {
        this.forms = forms;
    }

    @Deprecated
    public Object input(String id) {
        return this.textbox(id, "");
    }

    @Deprecated
    public Object input(String id, Object defaultValue) {
        return this.textbox(id, defaultValue.toString());
    }

    public Object textbox(String id, String defaultValue) {
        Object value = this.params.get(id);
        if (value == null) {
            value = defaultValue;
        }
        this.forms.put(id, new TextBox(id, defaultValue));
        this.params.put(id, value);
        return value;
    }

    public Object textbox(String id) {
        return this.textbox(id, "");
    }

    public Object password(String id) {
        this.forms.put(id, new Password(id));
        return this.params.get(id);
    }

    public Object select(String id, OptionInput.ParamOption[] options, Object defaultValue) {
        if (defaultValue == null && options != null && options.length > 0) {
            defaultValue = options[0].getValue();
        }
        this.forms.put(id, new Select(id, defaultValue, options));
        Object value = this.params.get(id);
        if (value == null) {
            value = defaultValue;
        }
        this.params.put(id, value);
        return value;
    }

    public List<Object> checkbox(String id, OptionInput.ParamOption[] options, Collection<Object> defaultChecked) {
        Collection<Object> checked = (Collection<Object>)this.params.get(id);
        if (checked == null) {
            checked = defaultChecked;
        }
        this.forms.put(id, new CheckBox(id, defaultChecked, options));
        LinkedList<Object> filtered = new LinkedList<Object>();
        for (Object o : checked) {
            if (!this.isValidOption(o, options)) continue;
            filtered.add(o);
        }
        this.params.put(id, filtered);
        return filtered;
    }

    private boolean isValidOption(Object o, OptionInput.ParamOption[] options) {
        for (OptionInput.ParamOption option : options) {
            if (!o.equals(option.getValue())) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.forms = new LinkedHashMap<String, Input>();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GUI gui = (GUI)o;
        if (this.params != null ? !this.params.equals(gui.params) : gui.params != null) {
            return false;
        }
        return this.forms != null ? this.forms.equals(gui.forms) : gui.forms == null;
    }

    public int hashCode() {
        int result = this.params != null ? this.params.hashCode() : 0;
        result = 31 * result + (this.forms != null ? this.forms.hashCode() : 0);
        return result;
    }

    public String toJson() {
        return gson.toJson((Object)this);
    }

    public void convertOldInput() {
        for (Map.Entry<String, Input> entry : this.forms.entrySet()) {
            if (!(entry.getValue() instanceof OldInput)) continue;
            Input convertedInput = this.convertFromOldInput((OldInput)entry.getValue());
            this.forms.put(entry.getKey(), convertedInput);
        }
    }

    public static GUI fromJson(String json) {
        GUI gui = (GUI)gson.fromJson(json, GUI.class);
        gui.convertOldInput();
        return gui;
    }

    private Input convertFromOldInput(OldInput oldInput) {
        Input convertedInput = null;
        if (oldInput.options == null || oldInput instanceof OldInput.OldTextBox) {
            convertedInput = new TextBox(oldInput.name, oldInput.defaultValue.toString());
        } else if (oldInput instanceof OldInput.OldCheckBox) {
            convertedInput = new CheckBox(oldInput.name, (List)oldInput.defaultValue, oldInput.options);
        } else if (oldInput instanceof OldInput && oldInput.options != null) {
            convertedInput = new Select(oldInput.name, oldInput.defaultValue, oldInput.options);
        } else {
            throw new RuntimeException("Can not convert this OldInput.");
        }
        convertedInput.setDisplayName(oldInput.getDisplayName());
        convertedInput.setHidden(oldInput.isHidden());
        convertedInput.setArgument(oldInput.getArgument());
        return convertedInput;
    }
}

