/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import com.google.gson.Gson;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.zeppelin.display.AngularObject;
import org.apache.zeppelin.display.AngularObjectRegistryListener;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.interpreter.remote.InvokeResourceMethodEventMessage;
import org.apache.zeppelin.interpreter.remote.PooledRemoteClient;
import org.apache.zeppelin.interpreter.thrift.AppOutputAppendEvent;
import org.apache.zeppelin.interpreter.thrift.AppOutputUpdateEvent;
import org.apache.zeppelin.interpreter.thrift.AppStatusUpdateEvent;
import org.apache.zeppelin.interpreter.thrift.OutputAppendEvent;
import org.apache.zeppelin.interpreter.thrift.OutputUpdateAllEvent;
import org.apache.zeppelin.interpreter.thrift.OutputUpdateEvent;
import org.apache.zeppelin.interpreter.thrift.ParagraphInfo;
import org.apache.zeppelin.interpreter.thrift.RegisterInfo;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterEventService;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterResultMessage;
import org.apache.zeppelin.interpreter.thrift.RunParagraphsEvent;
import org.apache.zeppelin.resource.RemoteResource;
import org.apache.zeppelin.resource.Resource;
import org.apache.zeppelin.resource.ResourceId;
import org.apache.zeppelin.resource.ResourcePoolConnector;
import org.apache.zeppelin.resource.ResourceSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteInterpreterEventClient
implements ResourcePoolConnector,
AngularObjectRegistryListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteInterpreterEventClient.class);
    private static final Gson GSON = new Gson();
    private PooledRemoteClient<RemoteInterpreterEventService.Client> remoteClient = new PooledRemoteClient<RemoteInterpreterEventService.Client>(() -> {
        TSocket transport = new TSocket(intpEventHost, intpEventPort);
        try {
            transport.open();
        }
        catch (TTransportException e) {
            throw new IOException(e);
        }
        TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
        return new RemoteInterpreterEventService.Client((TProtocol)protocol);
    });
    private String intpGroupId;

    public RemoteInterpreterEventClient(String intpEventHost, int intpEventPort) {
    }

    public <R> R callRemoteFunction(PooledRemoteClient.RemoteFunction<R, RemoteInterpreterEventService.Client> func) {
        return this.remoteClient.callRemoteFunction(func);
    }

    public void setIntpGroupId(String intpGroupId) {
        this.intpGroupId = intpGroupId;
    }

    public void registerInterpreterProcess(RegisterInfo registerInfo) {
        this.callRemoteFunction(client -> {
            client.registerInterpreterProcess(registerInfo);
            return null;
        });
    }

    @Override
    public ResourceSet getAllResources() {
        try {
            List resources = this.callRemoteFunction(client -> client.getAllResources(this.intpGroupId));
            ResourceSet resourceSet = new ResourceSet();
            for (String res : resources) {
                RemoteResource resource = RemoteResource.fromJson(res);
                resource.setResourcePoolConnector(this);
                resourceSet.add(resource);
            }
            return resourceSet;
        }
        catch (Exception e) {
            LOGGER.warn("Fail to getAllResources", (Throwable)e);
            return null;
        }
    }

    public List<ParagraphInfo> getParagraphList(String user, String noteId) {
        List paragraphList = this.callRemoteFunction(client -> client.getParagraphList(user, noteId));
        return paragraphList;
    }

    @Override
    public Object readResource(ResourceId resourceId) {
        try {
            ByteBuffer buffer = this.callRemoteFunction(client -> client.getResource(resourceId.toJson()));
            Object o = Resource.deserializeObject(buffer);
            return o;
        }
        catch (IOException | ClassNotFoundException e) {
            LOGGER.warn("Fail to readResource: " + resourceId, (Throwable)e);
            return null;
        }
    }

    @Override
    public Object invokeMethod(ResourceId resourceId, String methodName, Class[] paramTypes, Object[] params) {
        LOGGER.debug("Request Invoke method {} of Resource {}", (Object)methodName, (Object)resourceId.getName());
        InvokeResourceMethodEventMessage invokeMethod2 = new InvokeResourceMethodEventMessage(resourceId, methodName, paramTypes, params, null);
        try {
            ByteBuffer buffer = this.callRemoteFunction(client -> client.invokeMethod(this.intpGroupId, invokeMethod2.toJson()));
            Object o = Resource.deserializeObject(buffer);
            return o;
        }
        catch (IOException | ClassNotFoundException e) {
            LOGGER.error("Failed to invoke method", (Throwable)e);
            return null;
        }
    }

    @Override
    public Resource invokeMethod(ResourceId resourceId, String methodName, Class[] paramTypes, Object[] params, String returnResourceName) {
        LOGGER.debug("Request Invoke method {} of Resource {}", (Object)methodName, (Object)resourceId.getName());
        InvokeResourceMethodEventMessage invokeMethod2 = new InvokeResourceMethodEventMessage(resourceId, methodName, paramTypes, params, returnResourceName);
        try {
            ByteBuffer serializedResource = this.callRemoteFunction(client -> client.invokeMethod(this.intpGroupId, invokeMethod2.toJson()));
            Resource deserializedResource = (Resource)Resource.deserializeObject(serializedResource);
            RemoteResource remoteResource = RemoteResource.fromJson(GSON.toJson((Object)deserializedResource));
            remoteResource.setResourcePoolConnector(this);
            return remoteResource;
        }
        catch (IOException | ClassNotFoundException e) {
            LOGGER.error("Failed to invoke method", (Throwable)e);
            return null;
        }
    }

    public void onInterpreterOutputAppend(String noteId, String paragraphId, int outputIndex, String output) {
        try {
            this.callRemoteFunction(client -> {
                client.appendOutput(new OutputAppendEvent(noteId, paragraphId, outputIndex, output, null));
                return null;
            });
        }
        catch (Exception e) {
            LOGGER.warn("Fail to appendOutput", (Throwable)e);
        }
    }

    public void onInterpreterOutputUpdate(String noteId, String paragraphId, int outputIndex, InterpreterResult.Type type, String output) {
        try {
            this.callRemoteFunction(client -> {
                client.updateOutput(new OutputUpdateEvent(noteId, paragraphId, outputIndex, type.name(), output, null));
                return null;
            });
        }
        catch (Exception e) {
            LOGGER.warn("Fail to updateOutput", (Throwable)e);
        }
    }

    public void onInterpreterOutputUpdateAll(String noteId, String paragraphId, List<InterpreterResultMessage> messages) {
        try {
            this.callRemoteFunction(client -> {
                client.updateAllOutput(new OutputUpdateAllEvent(noteId, paragraphId, this.convertToThrift(messages)));
                return null;
            });
        }
        catch (Exception e) {
            LOGGER.warn("Fail to updateAllOutput", (Throwable)e);
        }
    }

    private List<RemoteInterpreterResultMessage> convertToThrift(List<InterpreterResultMessage> messages) {
        ArrayList<RemoteInterpreterResultMessage> thriftMessages = new ArrayList<RemoteInterpreterResultMessage>();
        for (InterpreterResultMessage message : messages) {
            thriftMessages.add(new RemoteInterpreterResultMessage(message.getType().name(), message.getData()));
        }
        return thriftMessages;
    }

    public void runParagraphs(String noteId, List<String> paragraphIds, List<Integer> paragraphIndices, String curParagraphId) {
        RunParagraphsEvent event = new RunParagraphsEvent(noteId, paragraphIds, paragraphIndices, curParagraphId);
        try {
            this.callRemoteFunction(client -> {
                client.runParagraphs(event);
                return null;
            });
        }
        catch (Exception e) {
            LOGGER.warn("Fail to runParagraphs: " + event, (Throwable)e);
        }
    }

    public void checkpointOutput(String noteId, String paragraphId) {
        try {
            this.callRemoteFunction(client -> {
                client.checkpointOutput(noteId, paragraphId);
                return null;
            });
        }
        catch (Exception e) {
            LOGGER.warn("Fail to checkpointOutput of paragraph: " + paragraphId + " of note: " + noteId, (Throwable)e);
        }
    }

    public void onAppOutputAppend(String noteId, String paragraphId, int index, String appId, String output) {
        AppOutputAppendEvent event = new AppOutputAppendEvent(noteId, paragraphId, appId, index, output);
        try {
            this.callRemoteFunction(client -> {
                client.appendAppOutput(event);
                return null;
            });
        }
        catch (Exception e) {
            LOGGER.warn("Fail to appendAppOutput: " + event, (Throwable)e);
        }
    }

    public void onAppOutputUpdate(String noteId, String paragraphId, int index, String appId, InterpreterResult.Type type, String output) {
        AppOutputUpdateEvent event = new AppOutputUpdateEvent(noteId, paragraphId, appId, index, type.name(), output);
        try {
            this.callRemoteFunction(client -> {
                client.updateAppOutput(event);
                return null;
            });
        }
        catch (Exception e) {
            LOGGER.warn("Fail to updateAppOutput: " + event, (Throwable)e);
        }
    }

    public void onAppStatusUpdate(String noteId, String paragraphId, String appId, String status) {
        AppStatusUpdateEvent event = new AppStatusUpdateEvent(noteId, paragraphId, appId, status);
        try {
            this.callRemoteFunction(client -> {
                client.updateAppStatus(event);
                return null;
            });
        }
        catch (Exception e) {
            LOGGER.warn("Fail to updateAppStatus: " + event, (Throwable)e);
        }
    }

    public void onParaInfosReceived(Map<String, String> infos) {
        try {
            this.callRemoteFunction(client -> {
                client.sendParagraphInfo(this.intpGroupId, GSON.toJson((Object)infos));
                return null;
            });
        }
        catch (Exception e) {
            LOGGER.warn("Fail to onParaInfosReceived: " + infos, (Throwable)e);
        }
    }

    @Override
    public synchronized void onAddAngularObject(String interpreterGroupId, AngularObject angularObject) {
        try {
            this.callRemoteFunction(client -> {
                client.addAngularObject(this.intpGroupId, angularObject.toJson());
                return null;
            });
        }
        catch (Exception e) {
            LOGGER.warn("Fail to add AngularObject: " + angularObject, (Throwable)e);
        }
    }

    @Override
    public void onUpdateAngularObject(String interpreterGroupId, AngularObject angularObject) {
        try {
            this.callRemoteFunction(client -> {
                client.updateAngularObject(this.intpGroupId, angularObject.toJson());
                return null;
            });
        }
        catch (Exception e) {
            LOGGER.warn("Fail to update AngularObject: " + angularObject, (Throwable)e);
        }
    }

    @Override
    public void onRemoveAngularObject(String interpreterGroupId, AngularObject angularObject) {
        try {
            this.callRemoteFunction(client -> {
                client.removeAngularObject(this.intpGroupId, angularObject.getNoteId(), angularObject.getParagraphId(), angularObject.getName());
                return null;
            });
        }
        catch (Exception e) {
            LOGGER.warn("Fail to remove AngularObject", (Throwable)e);
        }
    }
}

