/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.resource;

import com.google.gson.Gson;
import java.io.Serializable;
import org.apache.zeppelin.common.JsonSerializable;

public class ResourceId
implements JsonSerializable,
Serializable {
    private static final Gson gson = new Gson();
    private final String resourcePoolId;
    private final String name;
    private final String noteId;
    private final String paragraphId;

    ResourceId(String resourcePoolId, String name) {
        this.resourcePoolId = resourcePoolId;
        this.noteId = null;
        this.paragraphId = null;
        this.name = name;
    }

    ResourceId(String resourcePoolId, String noteId, String paragraphId, String name) {
        this.resourcePoolId = resourcePoolId;
        this.noteId = noteId;
        this.paragraphId = paragraphId;
        this.name = name;
    }

    public String getResourcePoolId() {
        return this.resourcePoolId;
    }

    public String getName() {
        return this.name;
    }

    public String getNoteId() {
        return this.noteId;
    }

    public String getParagraphId() {
        return this.paragraphId;
    }

    public int hashCode() {
        return (this.resourcePoolId + this.noteId + this.paragraphId + this.name).hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ResourceId) {
            ResourceId r = (ResourceId)o;
            return this.equals(r.name, this.name) && this.equals(r.resourcePoolId, this.resourcePoolId) && this.equals(r.noteId, this.noteId) && this.equals(r.paragraphId, this.paragraphId);
        }
        return false;
    }

    private boolean equals(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null && b != null) {
            return a.equals(b);
        }
        return false;
    }

    @Override
    public String toJson() {
        return gson.toJson((Object)this);
    }

    public static ResourceId fromJson(String json) {
        return (ResourceId)gson.fromJson(json, ResourceId.class);
    }
}

