/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.scheduler;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.scheduler.ExecutorFactory;
import org.apache.zeppelin.scheduler.FIFOScheduler;
import org.apache.zeppelin.scheduler.ParallelScheduler;
import org.apache.zeppelin.scheduler.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchedulerFactory.class);
    private static final String SCHEDULER_EXECUTOR_NAME = "SchedulerFactory";
    protected ExecutorService executor;
    protected Map<String, Scheduler> schedulers = new HashMap<String, Scheduler>();
    private static SchedulerFactory singleton;
    private static Long singletonLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SchedulerFactory singleton() {
        if (singleton == null) {
            Long l = singletonLock;
            synchronized (l) {
                if (singleton == null) {
                    try {
                        singleton = new SchedulerFactory();
                    }
                    catch (Exception e) {
                        LOGGER.error(e.toString(), (Throwable)e);
                    }
                }
            }
        }
        return singleton;
    }

    SchedulerFactory() {
        ZeppelinConfiguration zConf = ZeppelinConfiguration.create();
        int threadPoolSize = zConf.getInt(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_SCHEDULER_POOL_SIZE);
        LOGGER.info("Scheduler Thread Pool Size: " + threadPoolSize);
        this.executor = ExecutorFactory.singleton().createOrGet(SCHEDULER_EXECUTOR_NAME, threadPoolSize);
    }

    public void destroy() {
        LOGGER.info("Destroy all executors");
        ExecutorFactory.singleton().shutdown(SCHEDULER_EXECUTOR_NAME);
        this.executor.shutdownNow();
        this.executor = null;
        singleton = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scheduler createOrGetFIFOScheduler(String name) {
        Map<String, Scheduler> map = this.schedulers;
        synchronized (map) {
            if (!this.schedulers.containsKey(name)) {
                FIFOScheduler s = new FIFOScheduler(name);
                this.schedulers.put(name, s);
                this.executor.execute(s);
            }
            return this.schedulers.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scheduler createOrGetParallelScheduler(String name, int maxConcurrency) {
        Map<String, Scheduler> map = this.schedulers;
        synchronized (map) {
            if (!this.schedulers.containsKey(name)) {
                ParallelScheduler s = new ParallelScheduler(name, maxConcurrency);
                this.schedulers.put(name, s);
                this.executor.execute(s);
            }
            return this.schedulers.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scheduler createOrGetScheduler(Scheduler scheduler) {
        Map<String, Scheduler> map = this.schedulers;
        synchronized (map) {
            if (!this.schedulers.containsKey(scheduler.getName())) {
                this.schedulers.put(scheduler.getName(), scheduler);
                this.executor.execute(scheduler);
            }
            return this.schedulers.get(scheduler.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeScheduler(String name) {
        Map<String, Scheduler> map = this.schedulers;
        synchronized (map) {
            Scheduler s = this.schedulers.remove(name);
            if (s != null) {
                s.stop();
            }
        }
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    static {
        singletonLock = new Long(0L);
    }
}

