/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.zeppelin.interpreter.InvalidHookException;

public class InterpreterHookRegistry {
    static final String GLOBAL_KEY = "_GLOBAL_";
    private Map<String, Map<String, Map<String, String>>> registry = new HashMap<String, Map<String, Map<String, String>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNote(String noteId) {
        Map<String, Map<String, Map<String, String>>> map = this.registry;
        synchronized (map) {
            if (this.registry.get(noteId) == null) {
                this.registry.put(noteId, new HashMap());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRepl(String noteId, String className) {
        Map<String, Map<String, Map<String, String>>> map = this.registry;
        synchronized (map) {
            this.addNote(noteId);
            if (this.registry.get(noteId).get(className) == null) {
                this.registry.get(noteId).put(className, new HashMap());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String noteId, String className, String event, String cmd) throws InvalidHookException {
        Map<String, Map<String, Map<String, String>>> map = this.registry;
        synchronized (map) {
            if (!HookType.ValidEvents.contains(event)) {
                throw new InvalidHookException("event " + event + " is not valid hook event");
            }
            if (noteId == null) {
                noteId = GLOBAL_KEY;
            }
            this.addRepl(noteId, className);
            this.registry.get(noteId).get(className).put(event, cmd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(String noteId, String className, String event) {
        Map<String, Map<String, Map<String, String>>> map = this.registry;
        synchronized (map) {
            if (noteId == null) {
                noteId = GLOBAL_KEY;
            }
            this.addRepl(noteId, className);
            this.registry.get(noteId).get(className).remove(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String noteId, String className, String event) {
        Map<String, Map<String, Map<String, String>>> map = this.registry;
        synchronized (map) {
            if (noteId == null) {
                noteId = GLOBAL_KEY;
            }
            this.addRepl(noteId, className);
            return this.registry.get(noteId).get(className).get(event);
        }
    }

    public static enum HookType {
        PRE_EXEC("pre_exec"),
        POST_EXEC("post_exec"),
        PRE_EXEC_DEV("pre_exec_dev"),
        POST_EXEC_DEV("post_exec_dev");

        private String name;
        public static Set<String> ValidEvents;

        private HookType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        static {
            ValidEvents = new HashSet<String>();
            for (HookType type : HookType.values()) {
                ValidEvents.add(type.getName());
            }
        }
    }
}

