/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.launcher;

import java.io.IOException;
import java.util.Properties;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.launcher.InterpreterClient;
import org.apache.zeppelin.interpreter.launcher.InterpreterLaunchContext;
import org.apache.zeppelin.interpreter.recovery.RecoveryStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InterpreterLauncher {
    private static final Logger LOGGER = LoggerFactory.getLogger(InterpreterLauncher.class);
    private static final String SPECIAL_CHARACTER = "{}()<>&*\u2018|=?;[]$\u2013#~!.\"%/\\:+,`";
    protected ZeppelinConfiguration zConf;
    protected Properties properties;
    protected RecoveryStorage recoveryStorage;

    public InterpreterLauncher(ZeppelinConfiguration zConf, RecoveryStorage recoveryStorage) {
        this.zConf = zConf;
        this.recoveryStorage = recoveryStorage;
    }

    public void setProperties(Properties props) {
        this.properties = props;
    }

    protected int getConnectTimeout() {
        int connectTimeout = this.zConf.getInt(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_CONNECT_TIMEOUT);
        if (this.properties != null && this.properties.containsKey(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_CONNECT_TIMEOUT.getVarName())) {
            connectTimeout = Integer.parseInt(this.properties.getProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_CONNECT_TIMEOUT.getVarName()));
        }
        return connectTimeout;
    }

    protected int getConnectPoolSize() {
        return Integer.parseInt(this.properties.getProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_CONNECTION_POOL_SIZE.getVarName(), ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_CONNECTION_POOL_SIZE.getIntValue() + ""));
    }

    public static String escapeSpecialCharacter(String command) {
        StringBuilder builder = new StringBuilder();
        for (char c : command.toCharArray()) {
            if (SPECIAL_CHARACTER.indexOf(c) != -1) {
                builder.append("\\");
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public InterpreterClient launch(InterpreterLaunchContext context) throws IOException {
        InterpreterClient recoveredClient;
        if (this.zConf.isRecoveryEnabled() && (recoveredClient = this.recoveryStorage.getInterpreterClient(context.getInterpreterGroupId())) != null) {
            if (recoveredClient.isRunning()) {
                LOGGER.info("Recover interpreter process running at {}:{} of interpreter group: {}", new Object[]{recoveredClient.getHost(), recoveredClient.getPort(), recoveredClient.getInterpreterGroupId()});
                return recoveredClient;
            }
            this.recoveryStorage.removeInterpreterClient(context.getInterpreterGroupId());
            LOGGER.warn("Unable to recover interpreter process: {}:{}, as it is already terminated.", (Object)recoveredClient.getHost(), (Object)recoveredClient.getPort());
        }
        return this.launchDirectly(context);
    }

    public abstract InterpreterClient launchDirectly(InterpreterLaunchContext var1) throws IOException;
}

