/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.thrift.TServiceClient;
import org.apache.zeppelin.interpreter.remote.SupplierWithIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteClientFactory<T extends TServiceClient>
extends BasePooledObjectFactory<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteClientFactory.class);
    private Set<T> clientSockets = ConcurrentHashMap.newKeySet();
    private SupplierWithIO<T> supplier;

    public RemoteClientFactory(SupplierWithIO<T> supplier) {
        this.supplier = supplier;
    }

    public void close() {
        for (TServiceClient clientSocket : this.clientSockets) {
            clientSocket.getInputProtocol().getTransport().close();
            clientSocket.getOutputProtocol().getTransport().close();
        }
    }

    public T create() throws Exception {
        TServiceClient clientSocket = (TServiceClient)this.supplier.getWithIO();
        this.clientSockets.add(clientSocket);
        return (T)clientSocket;
    }

    public PooledObject<T> wrap(T client) {
        return new DefaultPooledObject(client);
    }

    public void destroyObject(PooledObject<T> p) {
        ((TServiceClient)p.getObject()).getOutputProtocol().getTransport().close();
        ((TServiceClient)p.getObject()).getInputProtocol().getTransport().close();
        this.clientSockets.remove(p.getObject());
    }

    public boolean validateObject(PooledObject<T> p) {
        return ((TServiceClient)p.getObject()).getOutputProtocol().getTransport().isOpen();
    }
}

