/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.markdown;

import com.vladsch.flexmark.ext.gitlab.internal.GitLabOptions;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.markdown.MarkdownUtils;
import org.apache.zeppelin.markdown.UMLBlockQuote;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UMLNodeRenderer
implements NodeRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(UMLNodeRenderer.class);
    public static final String YUML = "yuml";
    public static final String SEQUENCE = "sequence";
    final GitLabOptions options;

    public UMLNodeRenderer(DataHolder options) {
        this.options = new GitLabOptions(options);
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler(UMLBlockQuote.class, (NodeRenderingHandler.CustomNodeRenderer)new NodeRenderingHandler.CustomNodeRenderer<UMLBlockQuote>(){

            public void render(UMLBlockQuote node, NodeRendererContext context, HtmlWriter html) {
                UMLNodeRenderer.this.render(node, context, html);
            }
        }));
        return set;
    }

    private void render(final UMLBlockQuote node, final NodeRendererContext context, HtmlWriter html) {
        LOGGER.debug("Rendering HTML");
        String firstLine = node.getOpeningTrailing().toString();
        String[] splitWithSpace = firstLine.split(" ");
        LOGGER.debug("Start of the node {} ", (Object)firstLine);
        LOGGER.debug("Content within block {} ", (Object)node.getFirstChild().getChars());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (int i = 1; i < splitWithSpace.length; ++i) {
            String[] splitWithEqual = splitWithSpace[i].split("=");
            paramMap.put(splitWithEqual[0], splitWithEqual[1]);
        }
        String url = "";
        if (splitWithSpace[0].equals(YUML) && !Objects.isNull(node.getFirstChild())) {
            url = UMLNodeRenderer.createYumlUrl(paramMap, node.getFirstChild().getChars().toString());
            LOGGER.debug("Encoded YUML URL {} ", (Object)url);
        } else if (splitWithSpace[0].equals(SEQUENCE) && !Objects.isNull(node.getFirstChild())) {
            url = MarkdownUtils.createWebsequenceUrl((String)paramMap.get("style"), node.getFirstChild().getChars().toString());
            LOGGER.debug("Encoded web sequence diagram URL {} ", (Object)url);
        } else {
            html.withAttr().tagLineIndent((CharSequence)"blockquote", new Runnable(){

                @Override
                public void run() {
                    context.renderChildren((Node)node);
                }
            });
            return;
        }
        html.attr((CharSequence)"src", (CharSequence)url);
        html.attr((CharSequence)"alt", (CharSequence)"");
        html.srcPos(node.getChars()).withAttr().tagVoid((CharSequence)"img");
    }

    public static String createYumlUrl(Map<String, String> params, String body) {
        StringBuilder inlined = new StringBuilder();
        for (String line : body.split("\\r?\\n")) {
            if ((line = line.trim()).length() <= 0) continue;
            if (inlined.length() > 0) {
                inlined.append(", ");
            }
            inlined.append(line);
        }
        String encodedBody = null;
        try {
            encodedBody = URLEncoder.encode(inlined.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            new RuntimeException("Failed to encode YUML markdown body", e);
        }
        StringBuilder mergedStyle = new StringBuilder();
        String style = StringUtils.defaultString((String)params.get("style"), (String)"scruffy");
        String type = StringUtils.defaultString((String)params.get("type"), (String)"class");
        String format = StringUtils.defaultString((String)params.get("format"), (String)"svg");
        mergedStyle.append(style);
        if (null != params.get("dir")) {
            mergedStyle.append(";dir:" + params.get("dir"));
        }
        if (null != params.get("scale")) {
            mergedStyle.append(";scale:" + params.get("scale"));
        }
        return "http://yuml.me/diagram/" + (mergedStyle.toString() + "/") + (type + "/") + encodedBody + ("." + format);
    }

    public static class Factory
    implements NodeRendererFactory {
        public NodeRenderer apply(DataHolder options) {
            return new UMLNodeRenderer(options);
        }
    }
}

