/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.rest;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import javax.ws.rs.WebApplicationException;
import org.apache.zeppelin.service.AuthenticationService;
import org.apache.zeppelin.service.ServiceContext;
import org.apache.zeppelin.service.SimpleServiceCallback;
import org.apache.zeppelin.user.AuthenticationInfo;

public class AbstractRestApi {
    protected AuthenticationService authenticationService;

    protected AbstractRestApi(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    protected ServiceContext getServiceContext() {
        AuthenticationInfo authInfo = new AuthenticationInfo(this.authenticationService.getPrincipal());
        HashSet userAndRoles = Sets.newHashSet();
        userAndRoles.add(this.authenticationService.getPrincipal());
        userAndRoles.addAll(this.authenticationService.getAssociatedRoles());
        return new ServiceContext(authInfo, userAndRoles);
    }

    public static class RestServiceCallback<T>
    extends SimpleServiceCallback<T> {
        @Override
        public void onFailure(Exception ex, ServiceContext context) throws IOException {
            super.onFailure(ex, context);
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)ex;
            }
            throw new IOException(ex);
        }
    }
}

