/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.socket;

import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.socket.NotebookServer;
import org.apache.zeppelin.socket.NotebookSocket;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotebookWebSocketCreator
implements WebSocketCreator {
    private static final Logger LOG = LoggerFactory.getLogger(NotebookWebSocketCreator.class);
    private final NotebookServer notebookServer;

    public NotebookWebSocketCreator(NotebookServer notebookServer) {
        this.notebookServer = notebookServer;
    }

    public Object createWebSocket(ServletUpgradeRequest request, ServletUpgradeResponse response) {
        String origin = request.getHeader("Origin");
        if (this.notebookServer.checkOrigin(request.getHttpServletRequest(), origin)) {
            return new NotebookSocket(request.getHttpServletRequest(), "", this.notebookServer);
        }
        LOG.error("Websocket request is not allowed by {} settings. Origin: {}", (Object)ZeppelinConfiguration.ConfVars.ZEPPELIN_ALLOWED_ORIGINS, (Object)origin);
        return null;
    }
}

