/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.rest;

import java.io.IOException;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.zeppelin.annotation.ZeppelinApi;
import org.apache.zeppelin.rest.AbstractRestApi;
import org.apache.zeppelin.server.JsonResponse;
import org.apache.zeppelin.service.AuthenticationService;
import org.apache.zeppelin.service.ConfigurationService;

@Path(value="/configurations")
@Produces(value={"application/json"})
@Singleton
public class ConfigurationsRestApi
extends AbstractRestApi {
    private final ConfigurationService configurationService;

    @Inject
    public ConfigurationsRestApi(AuthenticationService authenticationService, ConfigurationService configurationService) {
        super(authenticationService);
        this.configurationService = configurationService;
    }

    @GET
    @Path(value="all")
    @ZeppelinApi
    public Response getAll() {
        try {
            Map<String, String> properties = this.configurationService.getAllProperties(this.getServiceContext(), new AbstractRestApi.RestServiceCallback<Map<String, String>>());
            return new JsonResponse<Map<String, String>>(Response.Status.OK, "", properties).build();
        }
        catch (IOException e) {
            return new JsonResponse<IOException>(Response.Status.INTERNAL_SERVER_ERROR, "Fail to get configuration", e).build();
        }
    }

    @GET
    @Path(value="prefix/{prefix}")
    @ZeppelinApi
    public Response getByPrefix(@PathParam(value="prefix") String prefix) {
        try {
            Map<String, String> properties = this.configurationService.getPropertiesWithPrefix(prefix, this.getServiceContext(), new AbstractRestApi.RestServiceCallback<Map<String, String>>());
            return new JsonResponse<Map<String, String>>(Response.Status.OK, "", properties).build();
        }
        catch (IOException e) {
            return new JsonResponse<IOException>(Response.Status.INTERNAL_SERVER_ERROR, "Fail to get configuration", e).build();
        }
    }
}

