/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.rest;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.validation.constraints.NotNull;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.zeppelin.annotation.ZeppelinApi;
import org.apache.zeppelin.common.Message;
import org.apache.zeppelin.dep.Repository;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterPropertyType;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.InterpreterSettingManager;
import org.apache.zeppelin.notebook.AuthorizationService;
import org.apache.zeppelin.rest.AbstractRestApi;
import org.apache.zeppelin.rest.message.InterpreterInstallationRequest;
import org.apache.zeppelin.rest.message.NewInterpreterSettingRequest;
import org.apache.zeppelin.rest.message.RestartInterpreterRequest;
import org.apache.zeppelin.rest.message.UpdateInterpreterSettingRequest;
import org.apache.zeppelin.server.JsonResponse;
import org.apache.zeppelin.service.AuthenticationService;
import org.apache.zeppelin.service.InterpreterService;
import org.apache.zeppelin.service.ServiceCallback;
import org.apache.zeppelin.service.ServiceContext;
import org.apache.zeppelin.service.SimpleServiceCallback;
import org.apache.zeppelin.socket.NotebookServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/interpreter")
@Produces(value={"application/json"})
@Singleton
public class InterpreterRestApi
extends AbstractRestApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(InterpreterRestApi.class);
    private final AuthorizationService authorizationService;
    private final InterpreterService interpreterService;
    private final InterpreterSettingManager interpreterSettingManager;
    private final NotebookServer notebookServer;

    @Inject
    public InterpreterRestApi(AuthenticationService authenticationService, AuthorizationService authorizationService, InterpreterService interpreterService, InterpreterSettingManager interpreterSettingManager, NotebookServer notebookWsServer) {
        super(authenticationService);
        this.authorizationService = authorizationService;
        this.interpreterService = interpreterService;
        this.interpreterSettingManager = interpreterSettingManager;
        this.notebookServer = notebookWsServer;
    }

    @GET
    @Path(value="setting")
    @ZeppelinApi
    public Response listSettings() {
        return new JsonResponse<List>(Response.Status.OK, "", this.interpreterSettingManager.get()).build();
    }

    @GET
    @Path(value="setting/{settingId}")
    @ZeppelinApi
    public Response getSetting(@PathParam(value="settingId") String settingId) {
        try {
            InterpreterSetting setting = this.interpreterSettingManager.get(settingId);
            if (setting == null) {
                return new JsonResponse(Response.Status.NOT_FOUND).build();
            }
            return new JsonResponse<InterpreterSetting>(Response.Status.OK, "", setting).build();
        }
        catch (NullPointerException e) {
            LOGGER.error("Exception in InterpreterRestApi while creating ", (Throwable)e);
            return new JsonResponse<String>(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e)).build();
        }
    }

    @POST
    @Path(value="setting")
    @ZeppelinApi
    public Response newSettings(String message) {
        try {
            NewInterpreterSettingRequest request = (NewInterpreterSettingRequest)GSON.fromJson(message, NewInterpreterSettingRequest.class);
            if (request == null) {
                return new JsonResponse(Response.Status.BAD_REQUEST).build();
            }
            InterpreterSetting interpreterSetting = this.interpreterSettingManager.createNewSetting(request.getName(), request.getGroup(), request.getDependencies(), request.getOption(), request.getProperties());
            LOGGER.info("new setting created with {}", (Object)interpreterSetting.getId());
            return new JsonResponse<InterpreterSetting>(Response.Status.OK, "", interpreterSetting).build();
        }
        catch (IOException e) {
            LOGGER.error("Exception in InterpreterRestApi while creating ", (Throwable)e);
            return new JsonResponse<String>(Response.Status.NOT_FOUND, e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e)).build();
        }
    }

    @PUT
    @Path(value="setting/{settingId}")
    @ZeppelinApi
    public Response updateSetting(String message, @PathParam(value="settingId") String settingId) {
        LOGGER.info("Update interpreterSetting {}", (Object)settingId);
        try {
            UpdateInterpreterSettingRequest request = (UpdateInterpreterSettingRequest)GSON.fromJson(message, UpdateInterpreterSettingRequest.class);
            this.interpreterSettingManager.setPropertyAndRestart(settingId, request.getOption(), request.getProperties(), request.getDependencies());
        }
        catch (InterpreterException e) {
            LOGGER.error("Exception in InterpreterRestApi while updateSetting ", (Throwable)e);
            return new JsonResponse<String>(Response.Status.NOT_FOUND, e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e)).build();
        }
        catch (IOException e) {
            LOGGER.error("Exception in InterpreterRestApi while updateSetting ", (Throwable)e);
            return new JsonResponse<String>(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e)).build();
        }
        InterpreterSetting setting = this.interpreterSettingManager.get(settingId);
        if (setting == null) {
            return new JsonResponse<String>(Response.Status.NOT_FOUND, "", settingId).build();
        }
        return new JsonResponse<InterpreterSetting>(Response.Status.OK, "", setting).build();
    }

    @DELETE
    @Path(value="setting/{settingId}")
    @ZeppelinApi
    public Response removeSetting(@PathParam(value="settingId") String settingId) throws IOException {
        LOGGER.info("Remove interpreterSetting {}", (Object)settingId);
        this.interpreterSettingManager.remove(settingId);
        return new JsonResponse(Response.Status.OK).build();
    }

    @PUT
    @Path(value="setting/restart/{settingId}")
    @ZeppelinApi
    public Response restartSetting(String message, @PathParam(value="settingId") String settingId) {
        InterpreterSetting setting;
        block5: {
            LOGGER.info("Restart interpreterSetting {}, msg={}, user={}", new Object[]{settingId, message, this.authenticationService.getPrincipal()});
            setting = this.interpreterSettingManager.get(settingId);
            try {
                String noteId;
                RestartInterpreterRequest request = (RestartInterpreterRequest)GSON.fromJson(message, RestartInterpreterRequest.class);
                String string = noteId = request == null ? null : request.getNoteId();
                if (null == noteId) {
                    this.interpreterSettingManager.close(settingId);
                    break block5;
                }
                HashSet<String> entities = new HashSet<String>();
                entities.add(this.authenticationService.getPrincipal());
                entities.addAll(this.authenticationService.getAssociatedRoles());
                if (this.authorizationService.hasRunPermission(entities, noteId) || this.authorizationService.hasWritePermission(entities, noteId) || this.authorizationService.isOwner(entities, noteId)) {
                    this.interpreterSettingManager.restart(settingId, this.authenticationService.getPrincipal(), noteId);
                    break block5;
                }
                return new JsonResponse<String>(Response.Status.FORBIDDEN, "No privilege to restart interpreter").build();
            }
            catch (InterpreterException e) {
                LOGGER.error("Exception in InterpreterRestApi while restartSetting ", (Throwable)e);
                return new JsonResponse<String>(Response.Status.NOT_FOUND, e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e)).build();
            }
        }
        if (setting == null) {
            return new JsonResponse<String>(Response.Status.NOT_FOUND, "", settingId).build();
        }
        return new JsonResponse<InterpreterSetting>(Response.Status.OK, "", setting).build();
    }

    @GET
    @ZeppelinApi
    public Response listInterpreter() {
        Map m = this.interpreterSettingManager.getInterpreterSettingTemplates();
        return new JsonResponse<Map>(Response.Status.OK, "", m).build();
    }

    @GET
    @Path(value="repository")
    @ZeppelinApi
    public Response listRepositories() {
        List interpreterRepositories = this.interpreterSettingManager.getRepositories();
        return new JsonResponse<List>(Response.Status.OK, "", interpreterRepositories).build();
    }

    @POST
    @Path(value="repository")
    @ZeppelinApi
    public Response addRepository(String message) {
        try {
            Repository request = Repository.fromJson((String)message);
            this.interpreterSettingManager.addRepository(request.getId(), request.getUrl(), request.isSnapshot(), request.getAuthentication(), request.getProxy());
            LOGGER.info("New repository {} added", (Object)request.getId());
        }
        catch (Exception e) {
            LOGGER.error("Exception in InterpreterRestApi while adding repository ", (Throwable)e);
            return new JsonResponse<String>(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e)).build();
        }
        return new JsonResponse(Response.Status.OK).build();
    }

    @DELETE
    @Path(value="repository/{repoId}")
    @ZeppelinApi
    public Response removeRepository(@PathParam(value="repoId") String repoId) {
        LOGGER.info("Remove repository {}", (Object)repoId);
        try {
            this.interpreterSettingManager.removeRepository(repoId);
        }
        catch (Exception e) {
            LOGGER.error("Exception in InterpreterRestApi while removing repository ", (Throwable)e);
            return new JsonResponse<String>(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e)).build();
        }
        return new JsonResponse(Response.Status.OK).build();
    }

    @GET
    @Path(value="property/types")
    public Response listInterpreterPropertyTypes() {
        return new JsonResponse<List>(Response.Status.OK, InterpreterPropertyType.getTypes()).build();
    }

    @POST
    @Path(value="install")
    @ZeppelinApi
    public Response installInterpreter(@NotNull String message) {
        LOGGER.info("Install interpreter: {}", (Object)message);
        InterpreterInstallationRequest request = (InterpreterInstallationRequest)GSON.fromJson(message, InterpreterInstallationRequest.class);
        try {
            this.interpreterService.installInterpreter(request, (ServiceCallback<String>)new SimpleServiceCallback<String>(){

                @Override
                public void onStart(String message, ServiceContext context) {
                    Message m = new Message(Message.OP.INTERPRETER_INSTALL_STARTED);
                    HashMap<String, String> data = new HashMap<String, String>();
                    data.put("result", "Starting");
                    data.put("message", message);
                    m.data = data;
                    InterpreterRestApi.this.notebookServer.broadcast(m);
                }

                @Override
                public void onSuccess(String message, ServiceContext context) {
                    Message m = new Message(Message.OP.INTERPRETER_INSTALL_RESULT);
                    HashMap<String, String> data = new HashMap<String, String>();
                    data.put("result", "Succeed");
                    data.put("message", message);
                    m.data = data;
                    InterpreterRestApi.this.notebookServer.broadcast(m);
                }

                @Override
                public void onFailure(Exception ex, ServiceContext context) {
                    Message m = new Message(Message.OP.INTERPRETER_INSTALL_RESULT);
                    HashMap<String, String> data = new HashMap<String, String>();
                    data.put("result", "Failed");
                    data.put("message", ex.getMessage());
                    m.data = data;
                    InterpreterRestApi.this.notebookServer.broadcast(m);
                }
            });
        }
        catch (Throwable t) {
            return new JsonResponse<String>(Response.Status.INTERNAL_SERVER_ERROR, t.getMessage()).build();
        }
        return new JsonResponse(Response.Status.OK).build();
    }
}

