/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.utils;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authz.RolesAuthorizationFilter;

public class AnyOfRolesUserAuthorizationFilter
extends RolesAuthorizationFilter {
    public boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        Subject subject = this.getSubject(request, response);
        String[] rolesArray = (String[])mappedValue;
        if (rolesArray == null || rolesArray.length == 0) {
            return true;
        }
        for (String roleName : rolesArray) {
            if (!subject.hasRole(roleName) && !subject.getPrincipal().equals(roleName)) continue;
            return true;
        }
        return false;
    }
}

