/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.rest;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.zeppelin.annotation.ZeppelinApi;
import org.apache.zeppelin.dep.Repository;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterFactory;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.rest.message.NewInterpreterSettingRequest;
import org.apache.zeppelin.rest.message.UpdateInterpreterSettingRequest;
import org.apache.zeppelin.server.JsonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.RepositoryException;

@Path(value="/interpreter")
@Produces(value={"application/json"})
public class InterpreterRestApi {
    Logger logger = LoggerFactory.getLogger(InterpreterRestApi.class);
    private InterpreterFactory interpreterFactory;
    Gson gson = new Gson();

    public InterpreterRestApi() {
    }

    public InterpreterRestApi(InterpreterFactory interpreterFactory) {
        this.interpreterFactory = interpreterFactory;
    }

    @GET
    @Path(value="setting")
    @ZeppelinApi
    public Response listSettings() {
        List interpreterSettings = null;
        interpreterSettings = this.interpreterFactory.get();
        return new JsonResponse<List>(Response.Status.OK, "", interpreterSettings).build();
    }

    @POST
    @Path(value="setting")
    @ZeppelinApi
    public Response newSettings(String message) {
        try {
            NewInterpreterSettingRequest request = (NewInterpreterSettingRequest)this.gson.fromJson(message, NewInterpreterSettingRequest.class);
            Properties p = new Properties();
            p.putAll(request.getProperties());
            InterpreterSetting interpreterSetting = this.interpreterFactory.add(request.getName(), request.getGroup(), request.getDependencies(), request.getOption(), p);
            this.logger.info("new setting created with {}", (Object)interpreterSetting.id());
            return new JsonResponse<InterpreterSetting>(Response.Status.CREATED, "", interpreterSetting).build();
        }
        catch (InterpreterException e) {
            this.logger.error("Exception in InterpreterRestApi while creating ", (Throwable)e);
            return new JsonResponse<String>(Response.Status.NOT_FOUND, e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e)).build();
        }
        catch (IOException | RepositoryException e) {
            this.logger.error("Exception in InterpreterRestApi while creating ", e);
            return new JsonResponse<String>(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e)).build();
        }
    }

    @PUT
    @Path(value="setting/{settingId}")
    @ZeppelinApi
    public Response updateSetting(String message, @PathParam(value="settingId") String settingId) {
        this.logger.info("Update interpreterSetting {}", (Object)settingId);
        try {
            UpdateInterpreterSettingRequest request = (UpdateInterpreterSettingRequest)this.gson.fromJson(message, UpdateInterpreterSettingRequest.class);
            this.interpreterFactory.setPropertyAndRestart(settingId, request.getOption(), request.getProperties(), request.getDependencies());
        }
        catch (InterpreterException e) {
            this.logger.error("Exception in InterpreterRestApi while updateSetting ", (Throwable)e);
            return new JsonResponse<String>(Response.Status.NOT_FOUND, e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e)).build();
        }
        catch (IOException | RepositoryException e) {
            this.logger.error("Exception in InterpreterRestApi while updateSetting ", e);
            return new JsonResponse<String>(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e)).build();
        }
        InterpreterSetting setting = this.interpreterFactory.get(settingId);
        if (setting == null) {
            return new JsonResponse<String>(Response.Status.NOT_FOUND, "", settingId).build();
        }
        return new JsonResponse<InterpreterSetting>(Response.Status.OK, "", setting).build();
    }

    @DELETE
    @Path(value="setting/{settingId}")
    @ZeppelinApi
    public Response removeSetting(@PathParam(value="settingId") String settingId) throws IOException {
        this.logger.info("Remove interpreterSetting {}", (Object)settingId);
        this.interpreterFactory.remove(settingId);
        return new JsonResponse(Response.Status.OK).build();
    }

    @PUT
    @Path(value="setting/restart/{settingId}")
    @ZeppelinApi
    public Response restartSetting(@PathParam(value="settingId") String settingId) {
        this.logger.info("Restart interpreterSetting {}", (Object)settingId);
        try {
            this.interpreterFactory.restart(settingId);
        }
        catch (InterpreterException e) {
            this.logger.error("Exception in InterpreterRestApi while restartSetting ", (Throwable)e);
            return new JsonResponse<String>(Response.Status.NOT_FOUND, e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e)).build();
        }
        InterpreterSetting setting = this.interpreterFactory.get(settingId);
        if (setting == null) {
            return new JsonResponse<String>(Response.Status.NOT_FOUND, "", settingId).build();
        }
        return new JsonResponse<InterpreterSetting>(Response.Status.OK, "", setting).build();
    }

    @GET
    @ZeppelinApi
    public Response listInterpreter(String message) {
        Map m = Interpreter.registeredInterpreters;
        return new JsonResponse<Map>(Response.Status.OK, "", m).build();
    }

    @GET
    @Path(value="repository")
    @ZeppelinApi
    public Response listRepositories() {
        List interpreterRepositories = null;
        interpreterRepositories = this.interpreterFactory.getRepositories();
        return new JsonResponse<List>(Response.Status.OK, "", interpreterRepositories).build();
    }

    @POST
    @Path(value="repository")
    @ZeppelinApi
    public Response addRepository(String message) {
        try {
            Repository request = (Repository)this.gson.fromJson(message, Repository.class);
            this.interpreterFactory.addRepository(request.getId(), request.getUrl(), request.isSnapshot(), request.getAuthentication());
            this.logger.info("New repository {} added", (Object)request.getId());
        }
        catch (Exception e) {
            this.logger.error("Exception in InterpreterRestApi while adding repository ", (Throwable)e);
            return new JsonResponse<String>(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e)).build();
        }
        return new JsonResponse(Response.Status.CREATED).build();
    }

    @DELETE
    @Path(value="repository/{repoId}")
    @ZeppelinApi
    public Response removeRepository(@PathParam(value="repoId") String repoId) {
        this.logger.info("Remove repository {}", (Object)repoId);
        try {
            this.interpreterFactory.removeRepository(repoId);
        }
        catch (Exception e) {
            this.logger.error("Exception in InterpreterRestApi while removing repository ", (Throwable)e);
            return new JsonResponse<String>(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e)).build();
        }
        return new JsonResponse(Response.Status.OK).build();
    }
}

