/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.rest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.realm.jdbc.JdbcRealm;
import org.apache.shiro.realm.ldap.JndiLdapRealm;
import org.apache.shiro.realm.text.IniRealm;
import org.apache.zeppelin.annotation.ZeppelinApi;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.rest.GetUserList;
import org.apache.zeppelin.server.JsonResponse;
import org.apache.zeppelin.ticket.TicketContainer;
import org.apache.zeppelin.utils.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/security")
@Produces(value={"application/json"})
public class SecurityRestApi {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityRestApi.class);

    @GET
    @Path(value="ticket")
    @ZeppelinApi
    public Response ticket() {
        ZeppelinConfiguration conf = ZeppelinConfiguration.create();
        String principal = SecurityUtils.getPrincipal();
        HashSet<String> roles = SecurityUtils.getRoles();
        String ticket = "anonymous".equals(principal) ? "anonymous" : TicketContainer.instance.getTicket(principal);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("principal", principal);
        data.put("roles", roles.toString());
        data.put("ticket", ticket);
        JsonResponse response = new JsonResponse(Response.Status.OK, "", data);
        LOG.warn(response.toString());
        return response.build();
    }

    @GET
    @Path(value="userlist/{searchText}")
    public Response getUserList(@PathParam(value="searchText") String searchText) {
        ArrayList<String> usersList = new ArrayList<String>();
        try {
            GetUserList getUserListObj = new GetUserList();
            Collection realmsList = SecurityUtils.getRealmsList();
            for (Realm realm : realmsList) {
                String name = realm.getName();
                if (name.equals("iniRealm")) {
                    usersList.addAll(getUserListObj.getUserList((IniRealm)realm));
                    continue;
                }
                if (name.equals("ldapRealm")) {
                    usersList.addAll(getUserListObj.getUserList((JndiLdapRealm)realm));
                    continue;
                }
                if (!name.equals("jdbcRealm")) continue;
                usersList.addAll(getUserListObj.getUserList((JdbcRealm)realm));
            }
        }
        catch (Exception e) {
            LOG.error("Exception in retrieving Users from realms ", (Throwable)e);
        }
        ArrayList autoSuggestList = new ArrayList();
        Collections.sort(usersList);
        int maxLength = 0;
        for (int i = 0; i < usersList.size(); ++i) {
            String searchTextLowerCase;
            String userLowerCase = ((String)usersList.get(i)).toLowerCase();
            if (userLowerCase.indexOf(searchTextLowerCase = searchText.toLowerCase()) != -1) {
                ++maxLength;
                autoSuggestList.add(usersList.get(i));
            }
            if (maxLength == 5) break;
        }
        return new JsonResponse(Response.Status.OK, "", autoSuggestList).build();
    }
}

